/***********************************************************************/
/*                                                                     */
/*      PROJECT NAME :  sketch                                         */
/*      FILE         :  interrupt_handlers.h                           */
/*      DESCRIPTION  :  Interrupt Handler Declarations                 */
/*      CPU SERIES   :  RX600                                          */
/*      CPU TYPE     :  RX63N                                          */
/*                                                                     */
/*      This file is generated by e2studio.                            */
/*                                                                     */
/***********************************************************************/

#ifndef INTERRUPT_HANDLERS_H
#define INTERRUPT_HANDLERS_H

/**
 * MOD EK 20/08/13 : Changed to C linkage.
 * MOD EK 14/11/13 : Changed SPI and I2C to use PDL interrupts.
 * MOD EK 21/11/13 : Changed brk interrupt.
 */
#ifdef __cplusplus
extern "C" {
#endif

#if !defined(__ATTRIBUTE_INTERRUPT)
#define __ATTRIBUTE_INTERRUPT __attribute__ ((interrupt, weak))
#endif

// Exception(Supervisor Instruction)
void INT_Excep_SuperVisorInst(void) __ATTRIBUTE_INTERRUPT;

// Exception(Access Instruction)

void INT_Excep_AccessInst(void) __ATTRIBUTE_INTERRUPT;

// Exception(Undefined Instruction)
void INT_Excep_UndefinedInst(void) __ATTRIBUTE_INTERRUPT;

// Exception(Floating Point)
void INT_Excep_FloatingPoint(void) __ATTRIBUTE_INTERRUPT;

// NMI
void NonMaskableInterrupt(void) __ATTRIBUTE_INTERRUPT;

// Dummy
void Dummy(void) __ATTRIBUTE_INTERRUPT;

//// BRK
//void INT_Excep_BRK(void) __ATTRIBUTE_INTERRUPT;
void Interrupt_BRK(void) __ATTRIBUTE_INTERRUPT;

// vector  1 reserved
// vector  2 reserved
// vector  3 reserved
// vector  4 reserved
// vector  5 reserved
// vector  6 reserved
// vector  7 reserved
// vector  8 reserved
// vector  9 reserved
// vector 10 reserved
// vector 11 reserved
void usb_cpu_GoWait(void) __ATTRIBUTE_INTERRUPT;
// vector 12 reserved
// vector 13 reserved
// vector 14 reserved
// vector 15 reserved

// BSC BUSERR
void INT_Excep_BSC_BUSERR(void) __ATTRIBUTE_INTERRUPT;

// vector 17 reserved
// vector 18 reserved
// vector 19 reserved
// vector 20 reserved

// FCU_FIFERR
void INT_Excep_FCU_FIFERR(void) __ATTRIBUTE_INTERRUPT;

// vector 22 reserved

// FCU_FRDYI
void INT_Excep_FCU_FRDYI(void) __ATTRIBUTE_INTERRUPT;

// vector 24 reserved
// vector 25 reserved
// vector 26 reserved

// ICU SWINT
void INT_Excep_ICU_SWINT(void) __ATTRIBUTE_INTERRUPT;

// CMT0_CMI0
void INT_Excep_CMT0_CMI0(void) __ATTRIBUTE_INTERRUPT;

// CMT1_CMI1
void INT_Excep_CMT1_CMI1(void) __ATTRIBUTE_INTERRUPT;

// CMT2_CMI2
void INT_Excep_CMT2_CMI2(void) __ATTRIBUTE_INTERRUPT;

// CMT3_CMI3
void INT_Excep_CMT3_CMI3(void) __ATTRIBUTE_INTERRUPT;

// ETHER EINT
void INT_Excep_ETHER_EINT(void) __ATTRIBUTE_INTERRUPT;

// USB0 D0FIFO0
void INT_Excep_USB0_D0FIFO0(void) __ATTRIBUTE_INTERRUPT;

// USB0 D1FIFO0
void INT_Excep_USB0_D1FIFO0(void) __ATTRIBUTE_INTERRUPT;

// USB0 USBI0
void INT_Excep_USB0_USBI0(void) __ATTRIBUTE_INTERRUPT;

// USB1 D0FIFO1
void INT_Excep_USB1_D0FIFO1(void) __ATTRIBUTE_INTERRUPT;

// USB1 D1FIFO1
void INT_Excep_USB1_D1FIFO1(void) __ATTRIBUTE_INTERRUPT;

// USB1 USBI1
void INT_Excep_USB1_USBI1(void) __ATTRIBUTE_INTERRUPT;

// RSPI0 SPRI0
void INT_Excep_RSPI0_SPRI0(void) __ATTRIBUTE_INTERRUPT;

// RSPI0 SPTI0
void INT_Excep_RSPI0_SPTI0(void) __ATTRIBUTE_INTERRUPT;

// RSPI0 SPII0
void INT_Excep_RSPI0_SPII0(void) __ATTRIBUTE_INTERRUPT;

// RSPI1 SPRI1
void INT_Excep_RSPI1_SPRI1(void) __ATTRIBUTE_INTERRUPT;

// RSPI1 SPTI1
void INT_Excep_RSPI1_SPTI1(void) __ATTRIBUTE_INTERRUPT;

// RSPI1 SPII1
void INT_Excep_RSPI1_SPII1(void) __ATTRIBUTE_INTERRUPT;

// RSPI2 SPRI2
void INT_Excep_RSPI2_SPRI2(void) __ATTRIBUTE_INTERRUPT;

// RSPI2 SPTI2
void INT_Excep_RSPI2_SPTI2(void) __ATTRIBUTE_INTERRUPT;

// RSPI2 SPII2
void INT_Excep_RSPI2_SPII2(void) __ATTRIBUTE_INTERRUPT;

// CAN0 RXF0
void INT_Excep_CAN0_RXF0(void) __ATTRIBUTE_INTERRUPT;

// CAN0 TXF0
void INT_Excep_CAN0_TXF0(void) __ATTRIBUTE_INTERRUPT;

// CAN0 RXM0
void INT_Excep_CAN0_RXM0(void) __ATTRIBUTE_INTERRUPT;

// CAN0 TXM0
void INT_Excep_CAN0_TXM0(void) __ATTRIBUTE_INTERRUPT;

// CAN1 RXF1
void INT_Excep_CAN1_RXF1(void) __ATTRIBUTE_INTERRUPT;

// CAN1 TXF1
void INT_Excep_CAN1_TXF1(void) __ATTRIBUTE_INTERRUPT;

// CAN1 RXM1
void INT_Excep_CAN1_RXM1(void) __ATTRIBUTE_INTERRUPT;

// CAN1 TXM1
void INT_Excep_CAN1_TXM1(void) __ATTRIBUTE_INTERRUPT;

// CAN2 RXF2
void INT_Excep_CAN2_RXF2(void) __ATTRIBUTE_INTERRUPT;

// CAN2 TXF2
void INT_Excep_CAN2_TXF2(void) __ATTRIBUTE_INTERRUPT;

// CAN2 RXM2
void INT_Excep_CAN2_RXM2(void) __ATTRIBUTE_INTERRUPT;

// CAN2 TXM2
void INT_Excep_CAN2_TXM2(void) __ATTRIBUTE_INTERRUPT;

// vector 60 reserved
// vector 61 reserved

// RTC CUP
void INT_Excep_RTC_CUP(void) __ATTRIBUTE_INTERRUPT;

// vector 63 reserved

// ICU IRQ0
void INT_Excep_ICU_IRQ0(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ1
void INT_Excep_ICU_IRQ1(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ2
void INT_Excep_ICU_IRQ2(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ3
void INT_Excep_ICU_IRQ3(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ4
void INT_Excep_ICU_IRQ4(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ5
void INT_Excep_ICU_IRQ5(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ6
void INT_Excep_ICU_IRQ6(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ7
void INT_Excep_ICU_IRQ7(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ8
void INT_Excep_ICU_IRQ8(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ9
void INT_Excep_ICU_IRQ9(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ10
void INT_Excep_ICU_IRQ10(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ11
void INT_Excep_ICU_IRQ11(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ12
void INT_Excep_ICU_IRQ12(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ13
void INT_Excep_ICU_IRQ13(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ14
void INT_Excep_ICU_IRQ14(void) __ATTRIBUTE_INTERRUPT;

// ICU IRQ15
void INT_Excep_ICU_IRQ15(void) __ATTRIBUTE_INTERRUPT;

// vector 80 reserved
// vector 81 reserved
// vector 82 reserved
// vector 83 reserved
// vector 84 reserved
// vector 85 reserved
// vector 86 reserved
// vector 87 reserved
// vector 88 reserved
// vector 89 reserved

// USB USBR0
void INT_Excep_USB_USBR0(void) __ATTRIBUTE_INTERRUPT;

// USB USBR1
void INT_Excep_USB_USBR1(void) __ATTRIBUTE_INTERRUPT;

// RTC ALM
void INT_Excep_RTC_ALM(void) __ATTRIBUTE_INTERRUPT;

// RTC PRD
void INT_Excep_RTC_PRD(void) __ATTRIBUTE_INTERRUPT;

// vector 94 reserved
// vector 95 reserved
// vector 96 reserved
// vector 97 reserved

// AD ADI0
void INT_Excep_AD_ADI0(void) __ATTRIBUTE_INTERRUPT;

// vector 99 reserved
// vector 100 reserved
// vector 101 reserved

// S12AD S12ADI0
void INT_Excep_S12AD_S12ADI0(void) __ATTRIBUTE_INTERRUPT;

// vector 103 reserved
// vector 104 reserved
// vector 105 reserved

// ICU GROUP0
void INT_Excep_ICU_GROUP0(void) __ATTRIBUTE_INTERRUPT;

// ICU GROUP1
void INT_Excep_ICU_GROUP1(void) __ATTRIBUTE_INTERRUPT;

// ICU GROUP2
void INT_Excep_ICU_GROUP2(void) __ATTRIBUTE_INTERRUPT;

// ICU GROUP3
void INT_Excep_ICU_GROUP3(void) __ATTRIBUTE_INTERRUPT;

// ICU GROUP4
void INT_Excep_ICU_GROUP4(void) __ATTRIBUTE_INTERRUPT;

// ICU GROUP5
void INT_Excep_ICU_GROUP5(void) __ATTRIBUTE_INTERRUPT;

// ICU GROUP6
void INT_Excep_ICU_GROUP6(void) __ATTRIBUTE_INTERRUPT;

// vector 113 reserved

// ICU GROUP12
void INT_Excep_ICU_GROUP12(void) __ATTRIBUTE_INTERRUPT;

// vector 115 reserved
// vector 116 reserved
// vector 117 reserved
// vector 118 reserved
// vector 119 reserved
// vector 120 reserved
// vector 121 reserved

// SCI12_SCIX0
void INT_Excep_SCI2_SCIX0(void) __ATTRIBUTE_INTERRUPT;

// SCI12_SCIX1
void INT_Excep_SCI2_SCIX1(void) __ATTRIBUTE_INTERRUPT;

// SCI12_SCIX2
void INT_Excep_SCI2_SCIX2(void) __ATTRIBUTE_INTERRUPT;

// SCI12_SCIX3
void INT_Excep_SCI2_SCIX3(void) __ATTRIBUTE_INTERRUPT;

// TPU0 TGI0A
void INT_Excep_TPU0_TGI0A(void) __ATTRIBUTE_INTERRUPT;

// TPU0 TGI0B
void INT_Excep_TPU0_TGI0B(void) __ATTRIBUTE_INTERRUPT;

// TPU0 TGI0C
void INT_Excep_TPU0_TGI0C(void) __ATTRIBUTE_INTERRUPT;

// TPU0 TGI0D
void INT_Excep_TPU0_TGI0D(void) __ATTRIBUTE_INTERRUPT;

// TPU1 TGI1A
void INT_Excep_TPU1_TGI1A(void) __ATTRIBUTE_INTERRUPT;

// TPU1 TGI1B
void INT_Excep_TPU1_TGI1B(void) __ATTRIBUTE_INTERRUPT;

// TPU2 TGI2A
void INT_Excep_TPU2_TGI2A(void) __ATTRIBUTE_INTERRUPT;

// TPU2 TGI2B
void INT_Excep_TPU2_TGI2B(void) __ATTRIBUTE_INTERRUPT;

// TPU3 TGI3A
void INT_Excep_TPU3_TGI3A(void) __ATTRIBUTE_INTERRUPT;

// TPU3 TGI3B
void INT_Excep_TPU3_TGI3B(void) __ATTRIBUTE_INTERRUPT;

// TPU3 TGI3C
void INT_Excep_TPU3_TGI3C(void) __ATTRIBUTE_INTERRUPT;

// TPU3 TGI3D
void INT_Excep_TPU3_TGI3D(void) __ATTRIBUTE_INTERRUPT;

// TPU4 TGI4A
void INT_Excep_TPU4_TGI4A(void) __ATTRIBUTE_INTERRUPT;

// TPU4 TGI4B
void INT_Excep_TPU4_TGI4B(void) __ATTRIBUTE_INTERRUPT;

// TPU5 TGI5A
void INT_Excep_TPU5_TGI5A(void) __ATTRIBUTE_INTERRUPT;

// TPU5 TGI5B
void INT_Excep_TPU5_TGI5B(void) __ATTRIBUTE_INTERRUPT;

// TPU6 TGI6A
void INT_Excep_TPU6_TGI6A(void) __ATTRIBUTE_INTERRUPT;

// MTU0 TGIA0
//void INT_Excep_MTU0_TGIA0(void) __ATTRIBUTE_INTERRUPT;
// TPU6 TGI6B
void INT_Excep_TPU6_TGI6B(void) __ATTRIBUTE_INTERRUPT;

// MTU0 TGIB0
//void INT_Excep_MTU0_TGIB0(void) __ATTRIBUTE_INTERRUPT;
// TPU6 TGI6C
void INT_Excep_TPU6_TGI6C(void) __ATTRIBUTE_INTERRUPT;

// MTU0 TGIC0
//void INT_Excep_MTU0_TGIC0(void) __ATTRIBUTE_INTERRUPT;
// TPU6 TGI6D
void INT_Excep_TPU6_TGI6D(void) __ATTRIBUTE_INTERRUPT;

// MTU0 TGID0
//void INT_Excep_MTU0_TGID0(void) __ATTRIBUTE_INTERRUPT;
// MTU0 TGIE0
void INT_Excep_MTU0_TGIE0(void) __ATTRIBUTE_INTERRUPT;

// MTU0 TGIF0
void INT_Excep_MTU0_TGIF0(void) __ATTRIBUTE_INTERRUPT;

// TPU7 TGI7A
void INT_Excep_TPU7_TGI7A(void) __ATTRIBUTE_INTERRUPT;

// MTU1 TGIA1
//void INT_Excep_MTU1_TGIA1(void)
// TPU7 TGI7B
void INT_Excep_TPU7_TGI7B(void) __ATTRIBUTE_INTERRUPT;

// MTU1 TGIB1
//void INT_Excep_MTU1_TGIB1(void) __ATTRIBUTE_INTERRUPT;
// TPU8 TGI8A
void INT_Excep_TPU8_TGI8A(void) __ATTRIBUTE_INTERRUPT;

// MTU2 TGIA2
//void INT_Excep_MTU2_TGIA2(void);
// TPU8 TGI8B
void INT_Excep_TPU8_TGI8B(void) __ATTRIBUTE_INTERRUPT;

// MTU2 TGIB2
//void INT_Excep_MTU2_TGIB2(void) __ATTRIBUTE_INTERRUPT;
// TPU9 TGI9A
void INT_Excep_TPU9_TGI9A(void) __ATTRIBUTE_INTERRUPT;

// MTU3 TGIA3
//void INT_Excep_MTU3_TGIA3(void) __ATTRIBUTE_INTERRUPT;
// TPU9 TGI9B
void INT_Excep_TPU9_TGI9B(void) __ATTRIBUTE_INTERRUPT;

// MTU3 TGIB3
//void INT_Excep_MTU3_TGIB3(void) __ATTRIBUTE_INTERRUPT;
// TPU9 TGI9C
void INT_Excep_TPU9_TGI9C(void) __ATTRIBUTE_INTERRUPT;

// MTU3 TGIC3
//void INT_Excep_MTU3_TGIC3(void) __ATTRIBUTE_INTERRUPT;
// TPU9 TGI9D
void INT_Excep_TPU9_TGI9D(void) __ATTRIBUTE_INTERRUPT;

// MTU3 TGID3
//void INT_Excep_MTU3_TGID3(void) __ATTRIBUTE_INTERRUPT;
// TPU10 TGI10A
void INT_Excep_TPU10_TGI10A(void) __ATTRIBUTE_INTERRUPT;

// MTU4 TGIA4
//void INT_Excep_MTU4_TGIA4(void) __ATTRIBUTE_INTERRUPT;
// TPU10 TGI10B
void INT_Excep_TPU10_TGI10B(void) __ATTRIBUTE_INTERRUPT;

// MTU4 TGIB4
//void INT_Excep_MTU4_TGIB4(void) __ATTRIBUTE_INTERRUPT;
// MTU4 TGIC4
void INT_Excep_MTU4_TGIC4(void) __ATTRIBUTE_INTERRUPT;

// MTU4 TGID4
void INT_Excep_MTU4_TGID4(void) __ATTRIBUTE_INTERRUPT;

// MTU4 TCIV4
void INT_Excep_MTU4_TCIV4(void) __ATTRIBUTE_INTERRUPT;

// MTU5 TGIU5
void INT_Excep_MTU5_TGIU5(void) __ATTRIBUTE_INTERRUPT;

// MTU5 TGIV5
void INT_Excep_MTU5_TGIV5(void) __ATTRIBUTE_INTERRUPT;

// MTU5 TGIW5
void INT_Excep_MTU5_TGIW5(void) __ATTRIBUTE_INTERRUPT;

// TPU11 TGI11A
void INT_Excep_TPU11_TGI11A(void) __ATTRIBUTE_INTERRUPT;

// TPU11 TGI11B
void INT_Excep_TPU11_TGI11B(void) __ATTRIBUTE_INTERRUPT;

// POE OEI1
void INT_Excep_POE_OEI1(void) __ATTRIBUTE_INTERRUPT;

// POE OEI2
void INT_Excep_POE_OEI2(void) __ATTRIBUTE_INTERRUPT;

// vector 168 reserved
// vector 169 reserved

// TMR0_CMIA0
void INT_Excep_TMR0_CMIA0(void) __ATTRIBUTE_INTERRUPT;

// TMR0_CMIB0
void INT_Excep_TMR0_CMIB0(void) __ATTRIBUTE_INTERRUPT;

// TMR0_OVI0
void INT_Excep_TMR0_OVI0(void) __ATTRIBUTE_INTERRUPT;

// TMR1_CMIA1
void INT_Excep_TMR1_CMIA1(void) __ATTRIBUTE_INTERRUPT;

// TMR1_CMIB1
void INT_Excep_TMR1_CMIB1(void) __ATTRIBUTE_INTERRUPT;

// TMR1_OVI1
void INT_Excep_TMR1_OVI1(void) __ATTRIBUTE_INTERRUPT;

// TMR2_CMIA2
void INT_Excep_TMR2_CMIA2(void) __ATTRIBUTE_INTERRUPT;

// TMR2_CMIB2
void INT_Excep_TMR2_CMIB2(void) __ATTRIBUTE_INTERRUPT;

// TMR2_OVI2
void INT_Excep_TMR2_OVI2(void) __ATTRIBUTE_INTERRUPT;

// TMR3_CMIA3
void INT_Excep_TMR3_CMIA3(void) __ATTRIBUTE_INTERRUPT;

// TMR3_CMIB3
void INT_Excep_TMR3_CMIB3(void) __ATTRIBUTE_INTERRUPT;

// TMR3_OVI3
void INT_Excep_TMR3_OVI3(void) __ATTRIBUTE_INTERRUPT;

//// RIIC0 EEI0
//void INT_Excep_RIIC0_EEI0(void) __ATTRIBUTE_INTERRUPT;
//
// RIIC0 RXI0
void INT_Excep_RIIC0_RXI0(void) __ATTRIBUTE_INTERRUPT;
//
// RIIC0 TXI0
void INT_Excep_RIIC0_TXI0(void) __ATTRIBUTE_INTERRUPT;
//
//// RIIC0 TEI0
//void INT_Excep_RIIC0_TEI0(void) __ATTRIBUTE_INTERRUPT;
//
//// RIIC1 EEI1
//void INT_Excep_RIIC1_EEI1(void) __ATTRIBUTE_INTERRUPT;
//
//// RIIC1 RXI1
//void INT_Excep_RIIC1_RXI1(void) __ATTRIBUTE_INTERRUPT;
//
//// RIIC1 TXI1
//void INT_Excep_RIIC1_TXI1(void) __ATTRIBUTE_INTERRUPT;
//
//// RIIC1 TEI1
//void INT_Excep_RIIC1_TEI1(void) __ATTRIBUTE_INTERRUPT;
//
//// RIIC2 EEI2
//void INT_Excep_RIIC2_EEI2(void) __ATTRIBUTE_INTERRUPT;
//
//// RIIC2 RXI2
//void INT_Excep_RIIC2_RXI2(void) __ATTRIBUTE_INTERRUPT;
//
//// RIIC2 TXI2
//void INT_Excep_RIIC2_TXI2(void) __ATTRIBUTE_INTERRUPT;
//
//// RIIC2 TEI2
//void INT_Excep_RIIC2_TEI2(void) __ATTRIBUTE_INTERRUPT;
//
//// RIIC3 EEI3
//void INT_Excep_RIIC3_EEI3(void) __ATTRIBUTE_INTERRUPT;
//
//// RIIC3 RXI3
//void INT_Excep_RIIC3_RXI3(void) __ATTRIBUTE_INTERRUPT;
//
//// RIIC3 TXI3
//void INT_Excep_RIIC3_TXI3(void) __ATTRIBUTE_INTERRUPT;
//
//// RIIC3 TEI3
//void INT_Excep_RIIC3_TEI3(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICEEI0(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICRXI0(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICTXI0(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICTEI0(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICEEI1(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICRXI1(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICTXI1(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICTEI1(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICEEI2(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICRXI2(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICTXI2(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICTEI2(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICEEI3(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICRXI3(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICTXI3(void) __ATTRIBUTE_INTERRUPT;

void  Interrupt_IIC_ICTEI3(void) __ATTRIBUTE_INTERRUPT;

// DMAC DMAC0I
void INT_Excep_DMAC_DMAC0I(void) __ATTRIBUTE_INTERRUPT;

// DMAC DMAC1I
void INT_Excep_DMAC_DMAC1I(void) __ATTRIBUTE_INTERRUPT;

// DMAC DMAC2I
void INT_Excep_DMAC_DMAC2I(void) __ATTRIBUTE_INTERRUPT;

// DMAC DMAC3I
void INT_Excep_DMAC_DMAC3I(void) __ATTRIBUTE_INTERRUPT;

// EXDMAC EXDMAC0I
void INT_Excep_EXDMAC_EXDMAC0I(void) __ATTRIBUTE_INTERRUPT;

// EXDMAC EXDMAC1I
void INT_Excep_EXDMAC_EXDMAC1I(void) __ATTRIBUTE_INTERRUPT;

// vector 204 reserved
// vector 205 reserved
// vector 206 reserved
// vector 207 reserved
// vector 208 reserved
// vector 209 reserved
// vector 210 reserved
// vector 211 reserved
// vector 212 reserved
// vector 213 reserved

// SCI0_RXI0
void INT_Excep_SCI0_RXI0(void) __ATTRIBUTE_INTERRUPT;

// SCI0_TXI0
void INT_Excep_SCI0_TXI0(void) __ATTRIBUTE_INTERRUPT;

// SCI0_TEI0
void INT_Excep_SCI0_TEI0(void) __ATTRIBUTE_INTERRUPT;

// SCI1_RXI1
void INT_Excep_SCI1_RXI1(void) __ATTRIBUTE_INTERRUPT;

// SCI1_TXI1
void INT_Excep_SCI1_TXI1(void) __ATTRIBUTE_INTERRUPT;

// SCI1_TEI1
void INT_Excep_SCI1_TEI1(void) __ATTRIBUTE_INTERRUPT;

// SCI2_RXI2
void INT_Excep_SCI2_RXI2(void) __ATTRIBUTE_INTERRUPT;

// SCI2_TXI2
void INT_Excep_SCI2_TXI2(void) __ATTRIBUTE_INTERRUPT;

// SCI2_TEI2
void INT_Excep_SCI2_TEI2(void) __ATTRIBUTE_INTERRUPT;

// SCI3_RXI3
void INT_Excep_SCI3_RXI3(void) __ATTRIBUTE_INTERRUPT;

// SCI3_TXI3
void INT_Excep_SCI3_TXI3(void) __ATTRIBUTE_INTERRUPT;

// SCI3_TEI3
void INT_Excep_SCI3_TEI3(void) __ATTRIBUTE_INTERRUPT;

// SCI4_RXI4
void INT_Excep_SCI4_RXI4(void) __ATTRIBUTE_INTERRUPT;

// SCI4_TXI4
void INT_Excep_SCI4_TXI4(void) __ATTRIBUTE_INTERRUPT;

// SCI4_TEI4
void INT_Excep_SCI4_TEI4(void) __ATTRIBUTE_INTERRUPT;

// SCI5_RXI5
void INT_Excep_SCI5_RXI5(void) __ATTRIBUTE_INTERRUPT;

// SCI5_TXI5
void INT_Excep_SCI5_TXI5(void) __ATTRIBUTE_INTERRUPT;

// SCI5_TEI5
void INT_Excep_SCI5_TEI5(void) __ATTRIBUTE_INTERRUPT;

// SCI6_RXI6
void INT_Excep_SCI6_RXI6(void) __ATTRIBUTE_INTERRUPT;

// SCI6_TXI6
void INT_Excep_SCI6_TXI6(void) __ATTRIBUTE_INTERRUPT;

// SCI6_TEI6
void INT_Excep_SCI6_TEI6(void) __ATTRIBUTE_INTERRUPT;

// SCI7_RXI7
void INT_Excep_SCI7_RXI7(void) __ATTRIBUTE_INTERRUPT;

// SCI7_TXI7
void INT_Excep_SCI7_TXI7(void) __ATTRIBUTE_INTERRUPT;

// SCI7_TEI7
void INT_Excep_SCI7_TEI7(void) __ATTRIBUTE_INTERRUPT;

// SCI8_RXI8
void INT_Excep_SCI8_RXI8(void) __ATTRIBUTE_INTERRUPT;

// SCI8_TXI8
void INT_Excep_SCI8_TXI8(void) __ATTRIBUTE_INTERRUPT;

// SCI8_TEI8
void INT_Excep_SCI8_TEI8(void) __ATTRIBUTE_INTERRUPT;

// SCI9_RXI9
void INT_Excep_SCI9_RXI9(void) __ATTRIBUTE_INTERRUPT;

// SCI9_TXI9
void INT_Excep_SCI9_TXI9(void) __ATTRIBUTE_INTERRUPT;

// SCI9_TEI9
void INT_Excep_SCI9_TEI9(void) __ATTRIBUTE_INTERRUPT;

// SCI10_RXI10
void INT_Excep_SCI10_RXI10(void) __ATTRIBUTE_INTERRUPT;

// SCI10_TXI10
void INT_Excep_SCI10_TXI10(void) __ATTRIBUTE_INTERRUPT;

// SCI10_TEI10
void INT_Excep_SCI10_TEI10(void) __ATTRIBUTE_INTERRUPT;

// SCI11_RXI11
void INT_Excep_SCI11_RXI11(void) __ATTRIBUTE_INTERRUPT;

// SCI11_TXI11
void INT_Excep_SCI11_TXI11(void) __ATTRIBUTE_INTERRUPT;

// SCI11_TEI11
void INT_Excep_SCI11_TEI11(void) __ATTRIBUTE_INTERRUPT;

// SCI12_RXI12
void INT_Excep_SCI12_RXI12(void) __ATTRIBUTE_INTERRUPT;

// SCI12_TXI12
void INT_Excep_SCI12_TXI12(void) __ATTRIBUTE_INTERRUPT;

// SCI12_TEI12
void INT_Excep_SCI12_TEI12(void) __ATTRIBUTE_INTERRUPT;

// IEB IEBINT
void INT_Excep_IEB_IEBINT(void) __ATTRIBUTE_INTERRUPT;

// vector 254 reserved
// vector 255 reserved

//;<<VECTOR DATA START (POWER ON RESET)>>
//;Power On Reset PC
extern void PowerON_Reset_PC(void) __ATTRIBUTE_INTERRUPT;
//;<<VECTOR DATA END (POWER ON RESET)>>

#ifdef __cplusplus
}
#endif

#endif
