// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file Header.c
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "Header.h"

#include <ucdr/microcdr.h>
#include <string.h>

bool Header_serialize_topic(ucdrBuffer* writer, const Header* topic)
{
    (void) Time_serialize_topic(writer, &topic->stamp);
    (void) ucdr_serialize_string(writer, topic->frame_id);

    return !writer->error;
}

bool Header_deserialize_topic(ucdrBuffer* reader, Header* topic)
{
    (void) Time_deserialize_topic(reader, &topic->stamp);
    (void) ucdr_deserialize_string(reader, topic->frame_id, 64);

    return !reader->error;
}

uint32_t Header_size_of_topic(const Header* topic, uint32_t size)
{
    uint32_t previousSize = size;
    size += Time_size_of_topic(&topic->stamp, size);
    size += ucdr_alignment(size, 4) + 4 + (uint32_t)strlen(topic->frame_id) + 1;

    return size - previousSize;
}
