// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file JointTrajectoryPoint.c
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "JointTrajectoryPoint.h"

#include <ucdr/microcdr.h>
#include <string.h>

bool JointTrajectoryPoint_serialize_topic(ucdrBuffer* writer, const JointTrajectoryPoint* topic)
{
    (void) ucdr_serialize_sequence_double(writer, topic->positions, topic->positions_size);

    (void) ucdr_serialize_sequence_double(writer, topic->velocities, topic->velocities_size);

    (void) ucdr_serialize_sequence_double(writer, topic->accelerations, topic->accelerations_size);

    (void) ucdr_serialize_sequence_double(writer, topic->effort, topic->effort_size);

    (void) Duration_serialize_topic(writer, &topic->time_from_start);
    return !writer->error;
}

bool JointTrajectoryPoint_deserialize_topic(ucdrBuffer* reader, JointTrajectoryPoint* topic)
{
    (void) ucdr_deserialize_sequence_double(reader, topic->positions, 100, &topic->positions_size);

    (void) ucdr_deserialize_sequence_double(reader, topic->velocities, 100, &topic->velocities_size);

    (void) ucdr_deserialize_sequence_double(reader, topic->accelerations, 100, &topic->accelerations_size);

    (void) ucdr_deserialize_sequence_double(reader, topic->effort, 100, &topic->effort_size);

    (void) Duration_deserialize_topic(reader, &topic->time_from_start);
    return !reader->error;
}

uint32_t JointTrajectoryPoint_size_of_topic(const JointTrajectoryPoint* topic, uint32_t size)
{
    uint32_t previousSize = size;
    size += ucdr_alignment(size, 4) + 4;
    size += ucdr_alignment(size, 8) + topic->positions_size * 8;

    size += ucdr_alignment(size, 4) + 4;
    size += ucdr_alignment(size, 8) + topic->velocities_size * 8;

    size += ucdr_alignment(size, 4) + 4;
    size += ucdr_alignment(size, 8) + topic->accelerations_size * 8;

    size += ucdr_alignment(size, 4) + 4;
    size += ucdr_alignment(size, 8) + topic->effort_size * 8;

    size += Duration_size_of_topic(&topic->time_from_start, size);
    return size - previousSize;
}
