// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file Joy.c
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "Joy.h"

#include <ucdr/microcdr.h>
#include <string.h>

bool Joy_serialize_topic(ucdrBuffer* writer, const Joy* topic)
{
    (void) Header_serialize_topic(writer, &topic->header);
    (void) ucdr_serialize_uint32_t(writer, topic->axes_size);

    (void) ucdr_serialize_array_float(writer, topic->axes, sizeof(topic->axes) / sizeof(float));

    (void) ucdr_serialize_uint32_t(writer, topic->buttons_size);

    (void) ucdr_serialize_array_int32_t(writer, topic->buttons, sizeof(topic->buttons) / sizeof(int32_t));

    return !writer->error;
}

bool Joy_deserialize_topic(ucdrBuffer* reader, Joy* topic)
{
    (void) Header_deserialize_topic(reader, &topic->header);
    (void) ucdr_deserialize_uint32_t(reader, &topic->axes_size);

    (void) ucdr_deserialize_array_float(reader, topic->axes, sizeof(topic->axes) / sizeof(float));

    (void) ucdr_deserialize_uint32_t(reader, &topic->buttons_size);

    (void) ucdr_deserialize_array_int32_t(reader, topic->buttons, sizeof(topic->buttons) / sizeof(int32_t));

    return !reader->error;
}

uint32_t Joy_size_of_topic(const Joy* topic, uint32_t size)
{
    uint32_t previousSize = size;
    size += Header_size_of_topic(&topic->header, size);
    size += ucdr_alignment(size, 4) + 4;

    size += ucdr_alignment(size, 4) + sizeof(topic->axes);

    size += ucdr_alignment(size, 4) + 4;

    size += ucdr_alignment(size, 4) + sizeof(topic->buttons);

    return size - previousSize;
}
