// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file UInt64.c
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "UInt64.h"

#include <ucdr/microcdr.h>
#include <string.h>

bool UInt64_serialize_topic(ucdrBuffer* writer, const UInt64* topic)
{
    (void) ucdr_serialize_uint64_t(writer, topic->data);

    return !writer->error;
}

bool UInt64_deserialize_topic(ucdrBuffer* reader, UInt64* topic)
{
    (void) ucdr_deserialize_uint64_t(reader, &topic->data);

    return !reader->error;
}

uint32_t UInt64_size_of_topic(const UInt64* topic, uint32_t size)
{
    uint32_t previousSize = size;
    size += ucdr_alignment(size, 8) + 8;

    return size - previousSize;
}
