// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file MagneticField.c
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "MagneticField.h"

#include <ucdr/microcdr.h>
#include <string.h>

bool MagneticField_serialize_topic(ucdrBuffer* writer, const MagneticField* topic)
{
    (void) Header_serialize_topic(writer, &topic->header);
    (void) Vector3_serialize_topic(writer, &topic->magnetic_field);
    (void) ucdr_serialize_array_double(writer, topic->magnetic_field_covariance, sizeof(topic->magnetic_field_covariance) / sizeof(double));

    return !writer->error;
}

bool MagneticField_deserialize_topic(ucdrBuffer* reader, MagneticField* topic)
{
    (void) Header_deserialize_topic(reader, &topic->header);
    (void) Vector3_deserialize_topic(reader, &topic->magnetic_field);
    (void) ucdr_deserialize_array_double(reader, topic->magnetic_field_covariance, sizeof(topic->magnetic_field_covariance) / sizeof(double));

    return !reader->error;
}

uint32_t MagneticField_size_of_topic(const MagneticField* topic, uint32_t size)
{
    uint32_t previousSize = size;
    size += Header_size_of_topic(&topic->header, size);
    size += Vector3_size_of_topic(&topic->magnetic_field, size);
    size += ucdr_alignment(size, 8) + sizeof(topic->magnetic_field_covariance);

    return size - previousSize;
}
