// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file Transform.c
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "Transform.h"

#include <ucdr/microcdr.h>
#include <string.h>

bool Transform_serialize_topic(ucdrBuffer* writer, const Transform* topic)
{
    (void) Vector3_serialize_topic(writer, &topic->translation);
    (void) Quaternion_serialize_topic(writer, &topic->rotation);
    return !writer->error;
}

bool Transform_deserialize_topic(ucdrBuffer* reader, Transform* topic)
{
    (void) Vector3_deserialize_topic(reader, &topic->translation);
    (void) Quaternion_deserialize_topic(reader, &topic->rotation);
    return !reader->error;
}

uint32_t Transform_size_of_topic(const Transform* topic, uint32_t size)
{
    uint32_t previousSize = size;
    size += Vector3_size_of_topic(&topic->translation, size);
    size += Quaternion_size_of_topic(&topic->rotation, size);
    return size - previousSize;
}
