// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file TwistWithCovariance.c
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "TwistWithCovariance.h"

#include <ucdr/microcdr.h>
#include <string.h>

bool TwistWithCovariance_serialize_topic(ucdrBuffer* writer, const TwistWithCovariance* topic)
{
    (void) Twist_serialize_topic(writer, &topic->twist);
    (void) ucdr_serialize_array_double(writer, topic->covariance, sizeof(topic->covariance) / sizeof(double));

    return !writer->error;
}

bool TwistWithCovariance_deserialize_topic(ucdrBuffer* reader, TwistWithCovariance* topic)
{
    (void) Twist_deserialize_topic(reader, &topic->twist);
    (void) ucdr_deserialize_array_double(reader, topic->covariance, sizeof(topic->covariance) / sizeof(double));

    return !reader->error;
}

uint32_t TwistWithCovariance_size_of_topic(const TwistWithCovariance* topic, uint32_t size)
{
    uint32_t previousSize = size;
    size += Twist_size_of_topic(&topic->twist, size);
    size += ucdr_alignment(size, 8) + sizeof(topic->covariance);

    return size - previousSize;
}
