// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file JointState.c
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "JointState.h"

#include <ucdr/microcdr.h>
#include <string.h>

bool JointState_serialize_topic(ucdrBuffer* writer, const JointState* topic)
{
    (void) Header_serialize_topic(writer, &topic->header);
    (void) ucdr_serialize_uint32_t(writer, topic->name_size);
    for(int i = 0; i < topic->name_size; ++i)
    {
        (void) ucdr_serialize_string(writer, topic->name[i]);
    }

#ifdef NEVER
    (void) ucdr_serialize_sequence_double(writer, topic->position, topic->position_size);
#else
    (void) ucdr_serialize_uint32_t(writer, topic->position_size);
    ucdr_array_to_buffer(writer, &topic->position[0], sizeof(double) * topic->position_size, sizeof(double) * topic->position_size);
#endif

#ifdef NEVER
    (void) ucdr_serialize_sequence_double(writer, topic->velocity, topic->velocity_size);
#else
    (void) ucdr_serialize_uint32_t(writer, topic->velocity_size);
    ucdr_array_to_buffer(writer, &topic->velocity[0], sizeof(double) * topic->velocity_size, sizeof(double) * topic->velocity_size);
#endif

#ifdef NEVER
    (void) ucdr_serialize_sequence_double(writer, topic->effort, topic->effort_size);
#else
    (void) ucdr_serialize_uint32_t(writer, topic->effort_size);
    ucdr_array_to_buffer(writer, &topic->effort[0], sizeof(double) * topic->effort_size, sizeof(double) * topic->effort_size);
#endif

    return !writer->error;
}

bool JointState_deserialize_topic(ucdrBuffer* reader, JointState* topic)
{
    (void) Header_deserialize_topic(reader, &topic->header);
    (void) ucdr_deserialize_uint32_t(reader, &topic->name_size);
    if(topic->name_size > 10)
    {
        reader->error = true;
    }
    else
    {
        for(int i = 0; i < topic->name_size; ++i)
        {
            (void) ucdr_deserialize_string(reader, topic->name[i], 32);
        }
    }

#ifdef NEVER
    (void) ucdr_deserialize_sequence_double(reader, topic->position, 10, &topic->position_size);
#else
    (void) ucdr_deserialize_uint32_t(reader, &topic->position_size);
    ucdr_buffer_to_array(reader, topic->position, sizeof(double) * topic->position_size, sizeof(double) * topic->position_size);
#endif

#ifdef NEVER
    (void) ucdr_deserialize_sequence_double(reader, topic->velocity, 10, &topic->velocity_size);
#else
    (void) ucdr_deserialize_uint32_t(reader, &topic->velocity_size);
    ucdr_buffer_to_array(reader, topic->velocity, sizeof(double) * topic->position_size, sizeof(double) * topic->velocity_size);
#endif

#ifdef NEVER
    (void) ucdr_deserialize_sequence_double(reader, topic->effort, 10, &topic->effort_size);
#else
    (void) ucdr_deserialize_uint32_t(reader, &topic->effort_size);
    ucdr_buffer_to_array(reader, topic->effort, sizeof(double) * topic->position_size, sizeof(double) * topic->effort_size);
#endif

    return !reader->error;
}

uint32_t JointState_size_of_topic(const JointState* topic, uint32_t size)
{
    uint32_t previousSize = size;
    size += Header_size_of_topic(&topic->header, size);
    size += ucdr_alignment(size, 4) + 4;
    for(int i = 0; i < topic->name_size; ++i)
    {
        size += ucdr_alignment(size, 4) + 4 + (uint32_t)strlen(topic->name[i]) + 1;
    }

    size += ucdr_alignment(size, 4) + 4;
    size += ucdr_alignment(size, 8) + topic->position_size * 8;

    size += ucdr_alignment(size, 4) + 4;
    size += ucdr_alignment(size, 8) + topic->velocity_size * 8;

    size += ucdr_alignment(size, 4) + 4;
    size += ucdr_alignment(size, 8) + topic->effort_size * 8;

    return size - previousSize;
}
