// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file Odometry.c
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "Odometry.h"

#include <ucdr/microcdr.h>
#include <string.h>

bool Odometry_serialize_topic(ucdrBuffer* writer, const Odometry* topic)
{
    (void) Header_serialize_topic(writer, &topic->header);
    (void) ucdr_serialize_string(writer, topic->child_frame_id);

    (void) PoseWithCovariance_serialize_topic(writer, &topic->pose);
    (void) TwistWithCovariance_serialize_topic(writer, &topic->twist);
    return !writer->error;
}

bool Odometry_deserialize_topic(ucdrBuffer* reader, Odometry* topic)
{
    (void) Header_deserialize_topic(reader, &topic->header);
    (void) ucdr_deserialize_string(reader, topic->child_frame_id, 255);

    (void) PoseWithCovariance_deserialize_topic(reader, &topic->pose);
    (void) TwistWithCovariance_deserialize_topic(reader, &topic->twist);
    return !reader->error;
}

uint32_t Odometry_size_of_topic(const Odometry* topic, uint32_t size)
{
    uint32_t previousSize = size;
    size += Header_size_of_topic(&topic->header, size);
    size += ucdr_alignment(size, 4) + 4 + (uint32_t)strlen(topic->child_frame_id) + 1;

    size += PoseWithCovariance_size_of_topic(&topic->pose, size);
    size += TwistWithCovariance_size_of_topic(&topic->twist, size);
    return size - previousSize;
}
