// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file PoseWithCovariance.c
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "PoseWithCovariance.h"

#include <ucdr/microcdr.h>
#include <string.h>

bool PoseWithCovariance_serialize_topic(ucdrBuffer* writer, const PoseWithCovariance* topic)
{
    (void) Pose_serialize_topic(writer, &topic->pose);
    (void) ucdr_serialize_array_double(writer, topic->covariance, sizeof(topic->covariance) / sizeof(double));

    return !writer->error;
}

bool PoseWithCovariance_deserialize_topic(ucdrBuffer* reader, PoseWithCovariance* topic)
{
    (void) Pose_deserialize_topic(reader, &topic->pose);
    (void) ucdr_deserialize_array_double(reader, topic->covariance, sizeof(topic->covariance) / sizeof(double));

    return !reader->error;
}

uint32_t PoseWithCovariance_size_of_topic(const PoseWithCovariance* topic, uint32_t size)
{
    uint32_t previousSize = size;
    size += Pose_size_of_topic(&topic->pose, size);
    size += ucdr_alignment(size, 8) + sizeof(topic->covariance);

    return size - previousSize;
}
