/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import processing.app.I18n;
import processing.app.UpdateThread;
import processing.app.UpdateUtility;

public class UpdateProgressDialog
extends JDialog {
    private UpdateThread updateThread;
    private TimeTask task;
    private Timer timer;
    private JButton cancelJButton;
    private JLabel downloadingFileNameJLabel;
    private JProgressBar jProgressBar1;
    private JLabel notificationJLabel;

    public UpdateProgressDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initialize();
    }

    public void setUpdateThread(UpdateThread updateThread) {
        this.updateThread = updateThread;
    }

    public void runUpdate() {
        EventQueue.invokeLater(() -> this.timer.schedule((TimerTask)this.task, 0L, 500L));
        this.updateThread.start();
    }

    public void updateCallback() {
        this.timer.cancel();
        this.timer = null;
        if (this.updateThread.getSuccess().booleanValue()) {
            System.exit(0);
        } else if (this.updateThread.getCancelRequest().booleanValue()) {
            JOptionPane.showMessageDialog(this, I18n._("Update has been canceled."), "W002002", 2);
            this.dispose();
        } else if (!this.updateThread.getCancelRequest().booleanValue()) {
            String title = "";
            StringBuilder builder = new StringBuilder();
            switch (this.updateThread.getUpdateStage()) {
                case 0: {
                    title = "E002009";
                    builder.append(I18n._("Failed to prepare for updating."));
                    break;
                }
                case 1: {
                    title = "E00200A";
                    builder.append(I18n._("Failed to check update information."));
                    break;
                }
                case 2: {
                    title = "E00200B";
                    builder.append(I18n._("Failed to download update file."));
                    break;
                }
                case 3: {
                    title = "E00200C";
                    builder.append(I18n._("Failed to bakup."));
                    break;
                }
                case 4: {
                    title = "E00200D";
                    builder.append(I18n._("Application of update failed."));
                    break;
                }
                default: {
                    title = "E00200E";
                    builder.append(I18n._("Failed update."));
                }
            }
            builder.append(UpdateUtility.getSeparator());
            if (this.updateThread.getException() != null) {
                builder.append(this.updateThread.getException().getMessage());
            }
            JOptionPane.showMessageDialog(this, builder.toString(), title, 0);
            this.dispose();
        }
    }

    protected void updateProgress() {
        if (this.updateThread.getCancelRequest().booleanValue()) {
            this.jProgressBar1.setIndeterminate(true);
            this.notificationJLabel.setText(I18n._("Cancel update..."));
            this.downloadingFileNameJLabel.setText("");
        } else {
            switch (this.updateThread.getUpdateStage()) {
                case 0: {
                    this.jProgressBar1.setIndeterminate(true);
                    this.notificationJLabel.setText(I18n._("Preparing for update..."));
                    this.downloadingFileNameJLabel.setText("");
                    break;
                }
                case 1: {
                    this.jProgressBar1.setIndeterminate(true);
                    this.notificationJLabel.setText(I18n._("Checking update information..."));
                    this.downloadingFileNameJLabel.setText("");
                    break;
                }
                case 2: {
                    this.jProgressBar1.setIndeterminate(false);
                    this.jProgressBar1.setValue(UpdateUtility.getProgress());
                    this.notificationJLabel.setText(I18n._("Downloading to update file..."));
                    this.downloadingFileNameJLabel.setText(UpdateUtility.getDownloadFileName());
                    break;
                }
                case 3: {
                    this.jProgressBar1.setIndeterminate(true);
                    this.notificationJLabel.setText(I18n._("Backup files..."));
                    this.downloadingFileNameJLabel.setText("");
                    break;
                }
                case 4: {
                    this.jProgressBar1.setIndeterminate(false);
                    this.jProgressBar1.setValue(100);
                    this.notificationJLabel.setText(I18n._("Applying update..."));
                    this.downloadingFileNameJLabel.setText("");
                    break;
                }
                case 5: {
                    this.jProgressBar1.setIndeterminate(true);
                    this.notificationJLabel.setText(I18n._("Cancel update..."));
                    this.downloadingFileNameJLabel.setText("");
                    break;
                }
            }
        }
    }

    private void initialize() {
        this.setTitle(I18n._("Update"));
        this.task = new TimeTask(this);
        this.timer = new Timer();
    }

    private void initComponents() {
        this.jProgressBar1 = new JProgressBar();
        this.cancelJButton = new JButton();
        this.notificationJLabel = new JLabel();
        this.downloadingFileNameJLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                UpdateProgressDialog.this.formWindowClosing(evt);
            }
        });
        this.cancelJButton.setFont(new Font("Meiryo UI", 0, 14));
        this.cancelJButton.setText("Cancel");
        this.cancelJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProgressDialog.this.cancelJButtonActionPerformed(evt);
            }
        });
        this.notificationJLabel.setFont(new Font("Meiryo UI", 0, 14));
        this.notificationJLabel.setText("Downloading to update file.");
        this.downloadingFileNameJLabel.setFont(new Font("Meiryo UI", 0, 14));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar1, -1, 391, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.downloadingFileNameJLabel, -1, -1, Short.MAX_VALUE).addGap(13, 13, 13).addComponent(this.cancelJButton)).addGroup(layout.createSequentialGroup().addComponent(this.notificationJLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.notificationJLabel).addGap(18, 18, 18).addComponent(this.jProgressBar1, -2, 32, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelJButton).addComponent(this.downloadingFileNameJLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelJButtonActionPerformed(ActionEvent evt) {
        if (this.updateThread.isAlive()) {
            this.updateThread.SetCancel();
        } else {
            this.dispose();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.updateThread.isAlive()) {
            this.updateThread.SetCancel();
            this.setDefaultCloseOperation(0);
        } else {
            this.dispose();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(UpdateProgressDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(UpdateProgressDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(UpdateProgressDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(UpdateProgressDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateProgressDialog dialog = new UpdateProgressDialog((Frame)new JFrame(), true);
                dialog.setVisible(true);
            }
        });
    }

    private class TimeTask
    extends TimerTask {
        private final UpdateProgressDialog dialog;

        public TimeTask(UpdateProgressDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void run() {
            try {
                this.dialog.updateProgress();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

