/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import processing.app.Base;

public final class UpdateUtility {
    private static final String JSON_KEY_WIN = "win";
    private static final String JSON_KEY_VER = "ver";
    private static final String JSON_KEY_ROOT = "root";
    private static final String JSON_KEY_STRUCTURE = "structure";
    private static final String JSON_KEY_PATH = "path";
    private static final String JSON_KEY_NAME = "name";
    private static final String JSON_KEY_TYPE = "type";
    private static final String JSON_KEY_TIME = "time";
    private static final String JSON_KEY_SIZE = "size";
    public static final String FILE_TYPE_1 = "1";
    public static final String FILE_TYPE_2 = "2";
    private static final String PATH_BASE = "http://tool-cloud2.renesas.com/ide4gr";
    private static final String PATH_BASE_DIRECTORY = "/ide4gr";
    private static final String PATH_IDE_VERSION_INFO = "/ide_version.json";
    private static final String PATH_VERSION_INFO = "/ver_info.json";
    private static final String PATH_FILE_INFO = "/file_info.json";
    private static final String PATH_UPDATE_BAT = "/update.bat";
    private static final int CONNECTION_TIMEOUT = 30000;
    public static final int UPDATE_STAGE_1 = 0;
    public static final int UPDATE_STAGE_2 = 1;
    public static final int UPDATE_STAGE_3 = 2;
    public static final int UPDATE_STAGE_4 = 3;
    public static final int UPDATE_STAGE_5 = 4;
    public static final int UPDATE_STAGE_6 = 5;
    private static String root;
    private static double totalSize;
    private static double downloadSize;
    private static String downloadFileName;
    private static Boolean cancelRequest;

    public static int getProgress() {
        return (int)Math.round(downloadSize / totalSize * 100.0);
    }

    public static String getDownloadFileName() {
        return downloadFileName;
    }

    private static int[] getVersion(String version) {
        int[] result = new int[]{0, 0, 0};
        String[] split = version.split("\\.", 0);
        for (int count = 0; count < result.length && count < split.length; ++count) {
            result[count] = Integer.parseInt(split[count]);
        }
        return result;
    }

    private static Boolean compareVersion(int[] current, int[] target) {
        Boolean result = false;
        if (current[0] < target[0] || current[0] == target[0] && current[1] < target[1] || current[0] == target[0] && current[1] == target[1] && current[2] < target[2]) {
            result = true;
        }
        return result;
    }

    private static String getString(String path) throws IOException {
        StringBuilder result = new StringBuilder();
        URL url = new URL(path);
        URLConnection connection = url.openConnection();
        connection.setReadTimeout(30000);
        connection.setConnectTimeout(30000);
        Object content = connection.getContent();
        if (content instanceof InputStream) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)content));
            while ((temp = reader.readLine()) != null && !cancelRequest.booleanValue()) {
                result.append(temp);
            }
        }
        return result.toString();
    }

    private static JSONArray getWinVersionInfo(String content) {
        JSONArray result = null;
        JSONObject structure = JSONObject.fromObject((Object)content);
        if (structure.containsKey((Object)JSON_KEY_STRUCTURE)) {
            JSONArray array = structure.getJSONArray(JSON_KEY_STRUCTURE);
            Iterator iterator = array.iterator();
            while (iterator.hasNext() && !cancelRequest.booleanValue()) {
                JSONObject object = (JSONObject)iterator.next();
                if (!object.containsKey((Object)JSON_KEY_WIN)) continue;
                result = object.getJSONArray(JSON_KEY_WIN);
                break;
            }
        }
        return result;
    }

    private static void download(URL url, FileOutputStream target) throws IOException {
        byte[] buffer = new byte[2048];
        int length = 0;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setReadTimeout(30000);
        connection.setConnectTimeout(30000);
        connection.setRequestMethod("GET");
        BufferedInputStream reader = new BufferedInputStream(connection.getInputStream());
        while ((length = reader.read(buffer)) != -1 && !cancelRequest.booleanValue()) {
            target.write(buffer, 0, length);
            downloadSize += (double)length;
        }
    }

    public static Boolean checkUpdate() throws IOException {
        JSONArray array;
        Boolean result = false;
        cancelRequest = false;
        String content = UpdateUtility.getString("http://tool-cloud2.renesas.com/ide4gr/ide_version.json");
        if (content != null && 0 < content.length() && (array = UpdateUtility.getWinVersionInfo(content)) != null) {
            Iterator iterator = array.iterator();
            while (iterator.hasNext() && !cancelRequest.booleanValue()) {
                JSONObject info = (JSONObject)iterator.next();
                if (info.containsKey((Object)JSON_KEY_VER)) {
                    if (!UpdateUtility.compareVersion(UpdateUtility.getVersion(Base.getVersionName()), UpdateUtility.getVersion(info.getString(JSON_KEY_VER))).booleanValue()) break;
                    result = true;
                    continue;
                }
                if (!info.containsKey((Object)JSON_KEY_ROOT)) continue;
                root = info.getString(JSON_KEY_ROOT);
            }
        }
        return result;
    }

    public static LocalDateTime getVersionInfo(String version) throws FileNotFoundException, IOException {
        JSONObject structure;
        LocalDateTime result = null;
        cancelRequest = false;
        String content = UpdateUtility.getString(PATH_BASE + root + PATH_VERSION_INFO);
        if (content != null && 0 < content.length() && (structure = JSONObject.fromObject((Object)content)).containsKey((Object)JSON_KEY_STRUCTURE)) {
            JSONArray array = structure.getJSONArray(JSON_KEY_STRUCTURE);
            Iterator iterator = array.iterator();
            while (iterator.hasNext() && !cancelRequest.booleanValue()) {
                JSONObject object = (JSONObject)iterator.next();
                if (!object.containsKey((Object)JSON_KEY_VER) || !Arrays.equals(UpdateUtility.getVersion(version), UpdateUtility.getVersion(object.getString(JSON_KEY_VER)))) continue;
                result = LocalDateTime.parse(object.getString(JSON_KEY_TIME), DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss"));
                break;
            }
        }
        return result;
    }

    public static HashMap<String, String> getUpdateFileInfo(LocalDateTime threshold) throws FileNotFoundException, IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        totalSize = 0.0;
        downloadSize = 0.0;
        downloadFileName = "";
        cancelRequest = false;
        String content = UpdateUtility.getString(PATH_BASE + root + PATH_FILE_INFO);
        if (content != null && 0 < content.length()) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
            JSONObject structure = JSONObject.fromObject((Object)content);
            if (structure.containsKey((Object)JSON_KEY_STRUCTURE)) {
                JSONArray array = structure.getJSONArray(JSON_KEY_STRUCTURE);
                Iterator iterator = array.iterator();
                while (iterator.hasNext() && !cancelRequest.booleanValue()) {
                    LocalDateTime local;
                    JSONObject info = (JSONObject)iterator.next();
                    if (info.getString(JSON_KEY_TYPE).equals(FILE_TYPE_1)) {
                        String path = info.getString(JSON_KEY_PATH).equals("/") ? info.getString(JSON_KEY_PATH) + info.getString(JSON_KEY_NAME) : info.getString(JSON_KEY_PATH) + "/" + info.getString(JSON_KEY_NAME);
                        result.put(path, FILE_TYPE_1);
                        continue;
                    }
                    if (!info.getString(JSON_KEY_TYPE).equals(FILE_TYPE_2) || !(local = LocalDateTime.parse(info.getString(JSON_KEY_TIME), formatter)).isAfter(threshold)) continue;
                    String path = info.getString(JSON_KEY_PATH).equals("/") ? info.getString(JSON_KEY_PATH) + info.getString(JSON_KEY_NAME) : info.getString(JSON_KEY_PATH) + "/" + info.getString(JSON_KEY_NAME);
                    result.put(path, FILE_TYPE_2);
                    totalSize += (double)Long.parseLong(info.getString(JSON_KEY_SIZE));
                }
            }
        }
        return result;
    }

    public static void downloadUpdateBat(String destination) throws IOException {
        cancelRequest = false;
        try (FileOutputStream stream = new FileOutputStream(new File(destination));){
            UpdateUtility.download(new URL(PATH_BASE + root + PATH_UPDATE_BAT), stream);
        }
    }

    public static void downloadFile(String destination, String source) throws IOException {
        cancelRequest = false;
        try (FileOutputStream stream = new FileOutputStream(new File(destination));){
            downloadFileName = new File(destination).getName();
            UpdateUtility.download(new URL((PATH_BASE + root + PATH_BASE_DIRECTORY + source).replace(" ", "%20")), stream);
        }
    }

    public static String getSeparator() {
        return System.getProperty("line.separator");
    }

    static {
        cancelRequest = false;
    }
}

