/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.dump;

import com.sun.org.glassfish.gmbal.ManagedAttribute;
import com.sun.org.glassfish.gmbal.ManagedData;
import com.sun.xml.internal.ws.api.FeatureConstructor;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.xml.ws.WebServiceFeature;

@ManagedData
public final class MessageDumpingFeature
extends WebServiceFeature {
    public static final String ID = "com.sun.xml.internal.ws.messagedump.MessageDumpingFeature";
    private static final Level DEFAULT_MSG_LOG_LEVEL = Level.FINE;
    private final Queue<String> messageQueue;
    private final AtomicBoolean messageLoggingStatus;
    private final String messageLoggingRoot;
    private final Level messageLoggingLevel;

    public MessageDumpingFeature() {
        this(null, null, true);
    }

    public MessageDumpingFeature(String string, Level level, boolean bl) {
        this.messageQueue = bl ? new ConcurrentLinkedQueue() : null;
        this.messageLoggingStatus = new AtomicBoolean(true);
        this.messageLoggingRoot = string != null && string.length() > 0 ? string : "com.sun.xml.internal.ws.messagedump";
        this.messageLoggingLevel = level != null ? level : DEFAULT_MSG_LOG_LEVEL;
        this.enabled = true;
    }

    public MessageDumpingFeature(boolean bl) {
        this();
        this.enabled = bl;
    }

    @FeatureConstructor(value={"enabled", "messageLoggingRoot", "messageLoggingLevel", "storeMessages"})
    public MessageDumpingFeature(boolean bl, String string, String string2, boolean bl2) {
        this(string, Level.parse(string2), bl2);
        this.enabled = bl;
    }

    @Override
    @ManagedAttribute
    public String getID() {
        return ID;
    }

    public String nextMessage() {
        return this.messageQueue != null ? this.messageQueue.poll() : null;
    }

    public void enableMessageLogging() {
        this.messageLoggingStatus.set(true);
    }

    public void disableMessageLogging() {
        this.messageLoggingStatus.set(false);
    }

    @ManagedAttribute
    public boolean getMessageLoggingStatus() {
        return this.messageLoggingStatus.get();
    }

    @ManagedAttribute
    public String getMessageLoggingRoot() {
        return this.messageLoggingRoot;
    }

    @ManagedAttribute
    public Level getMessageLoggingLevel() {
        return this.messageLoggingLevel;
    }

    boolean offerMessage(String string) {
        return this.messageQueue != null ? this.messageQueue.offer(string) : false;
    }
}

