/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy;

import com.sun.xml.internal.ws.policy.AssertionSet;
import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.NamespaceVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public final class PolicyIntersector {
    private static final PolicyIntersector STRICT_INTERSECTOR = new PolicyIntersector(CompatibilityMode.STRICT);
    private static final PolicyIntersector LAX_INTERSECTOR = new PolicyIntersector(CompatibilityMode.LAX);
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyIntersector.class);
    private CompatibilityMode mode;

    private PolicyIntersector(CompatibilityMode compatibilityMode) {
        this.mode = compatibilityMode;
    }

    public static PolicyIntersector createStrictPolicyIntersector() {
        return STRICT_INTERSECTOR;
    }

    public static PolicyIntersector createLaxPolicyIntersector() {
        return LAX_INTERSECTOR;
    }

    public Policy intersect(Policy ... policyArray) {
        if (policyArray == null || policyArray.length == 0) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0056_NEITHER_NULL_NOR_EMPTY_POLICY_COLLECTION_EXPECTED()));
        }
        if (policyArray.length == 1) {
            return policyArray[0];
        }
        boolean bl = false;
        boolean bl2 = true;
        NamespaceVersion namespaceVersion = null;
        for (Policy policy : policyArray) {
            if (policy.isEmpty()) {
                bl = true;
            } else {
                if (policy.isNull()) {
                    bl = true;
                }
                bl2 = false;
            }
            if (namespaceVersion == null) {
                namespaceVersion = policy.getNamespaceVersion();
            } else if (namespaceVersion.compareTo(policy.getNamespaceVersion()) < 0) {
                namespaceVersion = policy.getNamespaceVersion();
            }
            if (!bl || bl2) continue;
            return Policy.createNullPolicy(namespaceVersion, null, null);
        }
        NamespaceVersion namespaceVersion2 = namespaceVersion = namespaceVersion != null ? namespaceVersion : NamespaceVersion.getLatestVersion();
        if (bl2) {
            return Policy.createEmptyPolicy(namespaceVersion, null, null);
        }
        LinkedList<AssertionSet> linkedList = new LinkedList<AssertionSet>(policyArray[0].getContent());
        LinkedList linkedList2 = new LinkedList();
        ArrayList<AssertionSet> arrayList = new ArrayList<AssertionSet>(2);
        for (int i = 1; i < policyArray.length; ++i) {
            AssertionSet assertionSet;
            Collection<AssertionSet> collection = policyArray[i].getContent();
            linkedList2.clear();
            linkedList2.addAll(linkedList);
            linkedList.clear();
            while ((assertionSet = (AssertionSet)linkedList2.poll()) != null) {
                for (AssertionSet assertionSet2 : collection) {
                    if (!assertionSet.isCompatibleWith(assertionSet2, this.mode)) continue;
                    arrayList.add(assertionSet);
                    arrayList.add(assertionSet2);
                    linkedList.add(AssertionSet.createMergedAssertionSet(arrayList));
                    arrayList.clear();
                }
            }
        }
        return Policy.createPolicy(namespaceVersion, null, null, (Collection<AssertionSet>)linkedList);
    }

    static enum CompatibilityMode {
        STRICT,
        LAX;

    }
}

