/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.databinding.MetadataReader;
import com.sun.xml.internal.ws.api.server.AsyncProvider;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.handler.HandlerChainsModel;
import com.sun.xml.internal.ws.model.ReflectAnnotationReader;
import com.sun.xml.internal.ws.server.EndpointFactory;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.HandlerAnnotationInfo;
import com.sun.xml.internal.ws.util.UtilException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.jws.soap.SOAPMessageHandlers;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;

public class HandlerAnnotationProcessor {
    private static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.util");

    public static HandlerAnnotationInfo buildHandlerInfo(@NotNull Class<?> clazz, QName qName, QName qName2, WSBinding wSBinding) {
        HandlerChain handlerChain;
        MetadataReader metadataReader = EndpointFactory.getExternalMetadatReader(clazz, wSBinding);
        if (metadataReader == null) {
            metadataReader = new ReflectAnnotationReader();
        }
        if ((handlerChain = metadataReader.getAnnotation(HandlerChain.class, clazz)) == null) {
            if ((clazz = HandlerAnnotationProcessor.getSEI(clazz, metadataReader)) != null) {
                handlerChain = metadataReader.getAnnotation(HandlerChain.class, clazz);
            }
            if (handlerChain == null) {
                return null;
            }
        }
        if (clazz.getAnnotation(SOAPMessageHandlers.class) != null) {
            throw new UtilException("util.handler.cannot.combine.soapmessagehandlers", new Object[0]);
        }
        InputStream inputStream = HandlerAnnotationProcessor.getFileAsStream(clazz, handlerChain);
        XMLStreamReader xMLStreamReader = XMLStreamReaderFactory.create(null, inputStream, true);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        HandlerAnnotationInfo handlerAnnotationInfo = HandlerChainsModel.parseHandlerFile(xMLStreamReader, clazz.getClassLoader(), qName, qName2, wSBinding);
        try {
            xMLStreamReader.close();
            inputStream.close();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
            throw new UtilException(xMLStreamException.getMessage(), new Object[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new UtilException(iOException.getMessage(), new Object[0]);
        }
        return handlerAnnotationInfo;
    }

    public static HandlerChainsModel buildHandlerChainsModel(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        HandlerChain handlerChain = clazz.getAnnotation(HandlerChain.class);
        if (handlerChain == null) {
            return null;
        }
        InputStream inputStream = HandlerAnnotationProcessor.getFileAsStream(clazz, handlerChain);
        XMLStreamReader xMLStreamReader = XMLStreamReaderFactory.create(null, inputStream, true);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        HandlerChainsModel handlerChainsModel = HandlerChainsModel.parseHandlerConfigFile(clazz, xMLStreamReader);
        try {
            xMLStreamReader.close();
            inputStream.close();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
            throw new UtilException(xMLStreamException.getMessage(), new Object[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new UtilException(iOException.getMessage(), new Object[0]);
        }
        return handlerChainsModel;
    }

    static Class getClass(String string) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UtilException("util.handler.class.not.found", string);
        }
    }

    static Class getSEI(Class<?> clazz, MetadataReader metadataReader) {
        if (metadataReader == null) {
            metadataReader = new ReflectAnnotationReader();
        }
        if (Provider.class.isAssignableFrom(clazz) || AsyncProvider.class.isAssignableFrom(clazz)) {
            return null;
        }
        if (Service.class.isAssignableFrom(clazz)) {
            return null;
        }
        WebService webService = metadataReader.getAnnotation(WebService.class, clazz);
        if (webService == null) {
            throw new UtilException("util.handler.no.webservice.annotation", clazz.getCanonicalName());
        }
        String string = webService.endpointInterface();
        if (string.length() > 0) {
            clazz = HandlerAnnotationProcessor.getClass(webService.endpointInterface());
            WebService webService2 = metadataReader.getAnnotation(WebService.class, clazz);
            if (webService2 == null) {
                throw new UtilException("util.handler.endpoint.interface.no.webservice", webService.endpointInterface());
            }
            return clazz;
        }
        return null;
    }

    static InputStream getFileAsStream(Class clazz, HandlerChain handlerChain) {
        URL uRL = clazz.getResource(handlerChain.file());
        if (uRL == null) {
            uRL = Thread.currentThread().getContextClassLoader().getResource(handlerChain.file());
        }
        if (uRL == null) {
            String string = clazz.getPackage().getName();
            string = string.replace('.', '/');
            string = string + "/" + handlerChain.file();
            uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        }
        if (uRL == null) {
            throw new UtilException("util.failed.to.find.handlerchain.file", clazz.getName(), handlerChain.file());
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            throw new UtilException("util.failed.to.parse.handlerchain.file", clazz.getName(), handlerChain.file());
        }
    }
}

