/*
 * Decompiled with CFR 0.152.
 */
package processing.app.packages;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.StringMatchers;

public class Library {
    private String name;
    private String version;
    private String author;
    private String email;
    private String url;
    private String sentence;
    private String paragraph;
    private List<String> coreDependencies;
    private List<String> dependencies;
    private File folder;
    private File srcFolder;
    private File archFolder;
    private List<String> architectures;
    private boolean pre15Lib;
    private static final List<String> MANDATORY_PROPERTIES = Arrays.asList("architectures", "author", "core-dependencies", "dependencies", "email", "name", "paragraph", "sentence", "url", "version");
    private static final List<String> OPTIONAL_FOLDERS = Arrays.asList("arch", "examples", "extras", "src");
    private static final List<String> OPTIONAL_FILES = Arrays.asList("keywords.txt", "library.properties");
    public static final Comparator<Library> CASE_INSENSITIVE_ORDER = new Comparator<Library>(){

        @Override
        public int compare(Library o1, Library o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };

    public static Library create(File libFolder) throws IOException {
        File check = new File(libFolder, "library.properties");
        if (!check.exists() || !check.isFile()) {
            return Library.createPre15Library(libFolder);
        }
        return Library.createLibrary(libFolder);
    }

    private static Library createLibrary(File libFolder) throws IOException {
        File propertiesFile = new File(libFolder, "library.properties");
        PreferencesMap properties = new PreferencesMap();
        properties.load(propertiesFile);
        for (String string : MANDATORY_PROPERTIES) {
            if (properties.containsKey(string)) continue;
            throw new IOException("Missing '" + string + "' from library");
        }
        File srcFolder = new File(libFolder, "src");
        if (!srcFolder.exists() || !srcFolder.isDirectory()) {
            throw new IOException("Missing 'src' folder");
        }
        for (File file : libFolder.listFiles()) {
            if (file.isDirectory()) {
                if (OPTIONAL_FOLDERS.contains(file.getName())) continue;
                throw new IOException("Invalid folder '" + file.getName() + "'.");
            }
            if (OPTIONAL_FILES.contains(file.getName())) continue;
            throw new IOException("Invalid file '" + file.getName() + "'.");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String arch : ((String)properties.get("architectures")).split(",")) {
            arrayList.add(arch.trim());
        }
        ArrayList<String> coreDeps = new ArrayList<String>();
        for (String dep : ((String)properties.get("core-dependencies")).split(",")) {
            coreDeps.add(dep.trim());
        }
        ArrayList<String> dependencies = new ArrayList<String>();
        for (String dependency : ((String)properties.get("dependencies")).split(",")) {
            if ((dependency = dependency.trim()).equals("")) continue;
            dependencies.add(dependency);
        }
        Library res = new Library();
        res.folder = libFolder;
        res.srcFolder = srcFolder;
        res.archFolder = new File(libFolder, "arch");
        res.name = ((String)properties.get("name")).trim();
        res.author = ((String)properties.get("author")).trim();
        res.email = ((String)properties.get("email")).trim();
        res.sentence = ((String)properties.get("sentence")).trim();
        res.paragraph = ((String)properties.get("paragraph")).trim();
        res.url = ((String)properties.get("url")).trim();
        res.architectures = arrayList;
        res.coreDependencies = coreDeps;
        res.dependencies = dependencies;
        res.version = ((String)properties.get("version")).trim();
        res.pre15Lib = false;
        return res;
    }

    private static Library createPre15Library(File libFolder) {
        Library res = new Library();
        res.folder = libFolder;
        res.srcFolder = libFolder;
        res.name = libFolder.getName();
        res.architectures = Arrays.asList("*");
        res.pre15Lib = true;
        return res;
    }

    public List<File> getSrcFolders(String reqArch) {
        if (!this.supportsArchitecture(reqArch)) {
            return null;
        }
        ArrayList<File> res = new ArrayList<File>();
        res.add(this.srcFolder);
        File archSpecificFolder = new File(this.archFolder, reqArch);
        if (archSpecificFolder.exists() && archSpecificFolder.isDirectory()) {
            res.add(archSpecificFolder);
        } else {
            archSpecificFolder = new File(this.archFolder, "default");
            if (archSpecificFolder.exists() && archSpecificFolder.isDirectory()) {
                res.add(archSpecificFolder);
            }
        }
        return res;
    }

    public boolean supportsArchitecture(String reqArch) {
        for (String arch : this.architectures) {
            if (!StringMatchers.wildcardMatch(reqArch, arch)) continue;
            return true;
        }
        return false;
    }

    public File getSrcFolder() {
        return this.srcFolder;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPre15Lib() {
        return this.pre15Lib;
    }

    public File getFolder() {
        return this.folder;
    }

    public List<String> getArchitectures() {
        return this.architectures;
    }

    public String getAuthor() {
        return this.author;
    }

    public List<String> getCoreDependencies() {
        return this.coreDependencies;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public String getEmail() {
        return this.email;
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public String getSentence() {
        return this.sentence;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        String res = "Library:";
        res = res + " (name=" + this.name + ")";
        res = res + " (architectures=" + this.architectures + ")";
        res = res + " (author=" + this.author + ")";
        res = res + " (core-dependencies=" + this.coreDependencies + ")";
        res = res + " (dependencies=" + this.dependencies + ")";
        res = res + " (email=" + this.email + ")";
        res = res + " (paragraph=" + this.paragraph + ")";
        res = res + " (sentence=" + this.sentence + ")";
        res = res + " (url=" + this.url + ")";
        res = res + " (version=" + this.version + ")";
        return res;
    }
}

