/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.assembler;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.logging.Logger;
import com.sun.xml.internal.ws.assembler.DefaultServerTubelineAssemblyContext;
import com.sun.xml.internal.ws.assembler.MetroConfigLoader;
import com.sun.xml.internal.ws.assembler.MetroConfigName;
import com.sun.xml.internal.ws.assembler.TubeCreator;
import com.sun.xml.internal.ws.assembler.dev.ClientTubelineAssemblyContext;
import com.sun.xml.internal.ws.resources.TubelineassemblyMessages;
import com.sun.xml.internal.ws.runtime.config.TubeFactoryConfig;
import com.sun.xml.internal.ws.runtime.config.TubeFactoryList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.namespace.QName;

final class TubelineAssemblyController {
    private final MetroConfigName metroConfigName;

    TubelineAssemblyController(MetroConfigName metroConfigName) {
        this.metroConfigName = metroConfigName;
    }

    Collection<TubeCreator> getTubeCreators(ClientTubelineAssemblyContext clientTubelineAssemblyContext) {
        URI uRI = clientTubelineAssemblyContext.getPortInfo() != null ? this.createEndpointComponentUri(clientTubelineAssemblyContext.getPortInfo().getServiceName(), clientTubelineAssemblyContext.getPortInfo().getPortName()) : null;
        MetroConfigLoader metroConfigLoader = new MetroConfigLoader(clientTubelineAssemblyContext.getContainer(), this.metroConfigName);
        return this.initializeTubeCreators(metroConfigLoader.getClientSideTubeFactories(uRI));
    }

    Collection<TubeCreator> getTubeCreators(DefaultServerTubelineAssemblyContext defaultServerTubelineAssemblyContext) {
        URI uRI = defaultServerTubelineAssemblyContext.getEndpoint() != null ? this.createEndpointComponentUri(defaultServerTubelineAssemblyContext.getEndpoint().getServiceName(), defaultServerTubelineAssemblyContext.getEndpoint().getPortName()) : null;
        MetroConfigLoader metroConfigLoader = new MetroConfigLoader(defaultServerTubelineAssemblyContext.getEndpoint().getContainer(), this.metroConfigName);
        return this.initializeTubeCreators(metroConfigLoader.getEndpointSideTubeFactories(uRI));
    }

    private Collection<TubeCreator> initializeTubeCreators(TubeFactoryList tubeFactoryList) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LinkedList<TubeCreator> linkedList = new LinkedList<TubeCreator>();
        for (TubeFactoryConfig tubeFactoryConfig : tubeFactoryList.getTubeFactoryConfigs()) {
            linkedList.addFirst(new TubeCreator(tubeFactoryConfig, classLoader));
        }
        return linkedList;
    }

    private URI createEndpointComponentUri(@NotNull QName qName, @NotNull QName qName2) {
        StringBuilder stringBuilder = new StringBuilder(qName.getNamespaceURI()).append("#wsdl11.port(").append(qName.getLocalPart()).append('/').append(qName2.getLocalPart()).append(')');
        try {
            return new URI(stringBuilder.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.getLogger(TubelineAssemblyController.class).warning(TubelineassemblyMessages.MASM_0020_ERROR_CREATING_URI_FROM_GENERATED_STRING(stringBuilder.toString()), uRISyntaxException);
            return null;
        }
    }
}

