/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.spi.db;

import com.sun.xml.internal.ws.db.glassfish.JAXBRIContextFactory;
import com.sun.xml.internal.ws.spi.db.BindingContext;
import com.sun.xml.internal.ws.spi.db.BindingInfo;
import com.sun.xml.internal.ws.spi.db.DatabindingException;
import com.sun.xml.internal.ws.util.ServiceConfigurationError;
import com.sun.xml.internal.ws.util.ServiceFinder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public abstract class BindingContextFactory {
    public static final String DefaultDatabindingMode = "glassfish.jaxb";
    public static final String JAXB_CONTEXT_FACTORY_PROPERTY = BindingContextFactory.class.getName();
    public static final Logger LOGGER = Logger.getLogger(BindingContextFactory.class.getName());

    public static Iterator<BindingContextFactory> serviceIterator() {
        ServiceFinder<BindingContextFactory> serviceFinder = ServiceFinder.find(BindingContextFactory.class);
        final Iterator<BindingContextFactory> iterator = serviceFinder.iterator();
        return new Iterator<BindingContextFactory>(){
            private BindingContextFactory bcf;

            @Override
            public boolean hasNext() {
                while (true) {
                    try {
                        if (iterator.hasNext()) {
                            this.bcf = (BindingContextFactory)iterator.next();
                            return true;
                        }
                        return false;
                    }
                    catch (ServiceConfigurationError serviceConfigurationError) {
                        LOGGER.warning("skipping factory: ServiceConfigurationError: " + serviceConfigurationError.getMessage());
                        continue;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        LOGGER.fine("skipping factory: NoClassDefFoundError: " + noClassDefFoundError.getMessage());
                        continue;
                    }
                    break;
                }
            }

            @Override
            public BindingContextFactory next() {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("SPI found provider: " + this.bcf.getClass().getName());
                }
                return this.bcf;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static List<BindingContextFactory> factories() {
        ArrayList<BindingContextFactory> arrayList = new ArrayList<BindingContextFactory>();
        Iterator<BindingContextFactory> iterator = BindingContextFactory.serviceIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        if (arrayList.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "No SPI providers for BindingContextFactory found, adding: " + JAXBRIContextFactory.class.getName());
            }
            arrayList.add(new JAXBRIContextFactory());
        }
        return arrayList;
    }

    protected abstract BindingContext newContext(JAXBContext var1);

    protected abstract BindingContext newContext(BindingInfo var1);

    protected abstract boolean isFor(String var1);

    protected abstract BindingContext getContext(Marshaller var1);

    private static BindingContextFactory getFactory(String string) {
        for (BindingContextFactory bindingContextFactory : BindingContextFactory.factories()) {
            if (!bindingContextFactory.isFor(string)) continue;
            return bindingContextFactory;
        }
        return null;
    }

    public static BindingContext create(JAXBContext jAXBContext) throws DatabindingException {
        return BindingContextFactory.getJAXBFactory(jAXBContext).newContext(jAXBContext);
    }

    public static BindingContext create(BindingInfo bindingInfo) {
        BindingContextFactory bindingContextFactory;
        String string = bindingInfo.getDatabindingMode();
        if (string != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Using SEI-configured databindng mode: " + string);
            }
        } else {
            string = System.getProperty("BindingContextFactory");
            if (string != null) {
                bindingInfo.setDatabindingMode(string);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Using databindng: " + string + " based on 'BindingContextFactory' System property");
                }
            } else {
                string = System.getProperty(JAXB_CONTEXT_FACTORY_PROPERTY);
                if (string != null) {
                    bindingInfo.setDatabindingMode(string);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Using databindng: " + string + " based on '" + JAXB_CONTEXT_FACTORY_PROPERTY + "' System property");
                    }
                } else {
                    Iterator<BindingContextFactory> iterator = BindingContextFactory.factories().iterator();
                    if (iterator.hasNext()) {
                        BindingContextFactory bindingContextFactory2 = iterator.next();
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Using SPI-determined databindng mode: " + bindingContextFactory2.getClass().getName());
                        }
                        return bindingContextFactory2.newContext(bindingInfo);
                    }
                    LOGGER.log(Level.SEVERE, "No Binding Context Factories found.");
                    throw new DatabindingException("No Binding Context Factories found.");
                }
            }
        }
        if ((bindingContextFactory = BindingContextFactory.getFactory(string)) != null) {
            return bindingContextFactory.newContext(bindingInfo);
        }
        LOGGER.severe("Unknown Databinding mode: " + string);
        throw new DatabindingException("Unknown Databinding mode: " + string);
    }

    public static boolean isContextSupported(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.getClass().getPackage().getName();
        for (BindingContextFactory bindingContextFactory : BindingContextFactory.factories()) {
            if (!bindingContextFactory.isFor(string)) continue;
            return true;
        }
        return false;
    }

    static BindingContextFactory getJAXBFactory(Object object) {
        String string = object.getClass().getPackage().getName();
        BindingContextFactory bindingContextFactory = BindingContextFactory.getFactory(string);
        if (bindingContextFactory != null) {
            return bindingContextFactory;
        }
        throw new DatabindingException("Unknown JAXBContext implementation: " + object.getClass());
    }

    public static BindingContext getBindingContext(Marshaller marshaller) {
        return BindingContextFactory.getJAXBFactory(marshaller).getContext(marshaller);
    }
}

