/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.DiagnosticCommandMBean;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import sun.management.DiagnosticCommandArgumentInfo;
import sun.management.DiagnosticCommandInfo;
import sun.management.NotificationEmitterSupport;
import sun.management.VMManagement;

class DiagnosticCommandImpl
extends NotificationEmitterSupport
implements DiagnosticCommandMBean {
    private final VMManagement jvm;
    private volatile Map<String, Wrapper> wrappers = null;
    private static final String strClassName = "".getClass().getName();
    private static final String strArrayClassName = String[].class.getName();
    private final boolean isSupported;
    private static final String notifName = "javax.management.Notification";
    private static final String[] diagFramNotifTypes = new String[]{"jmx.mbean.info.changed"};
    private MBeanNotificationInfo[] notifInfo = null;
    private static long seqNumber = 0L;

    @Override
    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException(string);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException(attribute.getName());
    }

    @Override
    public AttributeList getAttributes(String[] stringArray) {
        return new AttributeList();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributeList) {
        return new AttributeList();
    }

    DiagnosticCommandImpl(VMManagement vMManagement) {
        this.jvm = vMManagement;
        this.isSupported = vMManagement.isRemoteDiagnosticCommandsSupported();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        Object object;
        Object object2;
        HashMap<String, Wrapper> hashMap;
        TreeSet<MBeanOperationInfo> treeSet = new TreeSet<MBeanOperationInfo>(new OperationInfoComparator());
        if (!this.isSupported) {
            hashMap = Collections.EMPTY_MAP;
        } else {
            try {
                object2 = this.getDiagnosticCommands();
                object = this.getDiagnosticCommandInfo((String[])object2);
                MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[]{new MBeanParameterInfo("arguments", strArrayClassName, "Array of Diagnostic Commands Arguments and Options")};
                hashMap = new HashMap<String, Wrapper>();
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    String string = DiagnosticCommandImpl.transform((String)object2[i]);
                    try {
                        Wrapper wrapper = new Wrapper(string, (String)object2[i], object[i]);
                        hashMap.put(string, wrapper);
                        treeSet.add(new MBeanOperationInfo(wrapper.name, wrapper.info.getDescription(), wrapper.info.getArgumentsInfo() == null || wrapper.info.getArgumentsInfo().isEmpty() ? null : mBeanParameterInfoArray, strClassName, 2, this.commandDescriptor(wrapper)));
                        continue;
                    }
                    catch (InstantiationException instantiationException) {
                        // empty catch block
                    }
                }
            }
            catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                hashMap = Collections.EMPTY_MAP;
            }
        }
        this.wrappers = Collections.unmodifiableMap(hashMap);
        object2 = new HashMap();
        ((HashMap)object2).put("immutableInfo", "false");
        ((HashMap)object2).put("interfaceClassName", "com.sun.management.DiagnosticCommandMBean");
        ((HashMap)object2).put("mxbean", "false");
        object = new ImmutableDescriptor((Map<String, ?>)object2);
        return new MBeanInfo(this.getClass().getName(), "Diagnostic Commands", null, null, treeSet.toArray(new MBeanOperationInfo[treeSet.size()]), this.getNotificationInfo(), (Descriptor)object);
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        Wrapper wrapper;
        if (!this.isSupported) {
            throw new UnsupportedOperationException();
        }
        if (this.wrappers == null) {
            this.getMBeanInfo();
        }
        if ((wrapper = this.wrappers.get(string)) != null) {
            if (!(!wrapper.info.getArgumentsInfo().isEmpty() || objectArray != null && objectArray.length != 0 || stringArray != null && stringArray.length != 0)) {
                return wrapper.execute(null);
            }
            if (objectArray != null && objectArray.length == 1 && stringArray != null && stringArray.length == 1 && stringArray[0] != null && stringArray[0].compareTo(strArrayClassName) == 0) {
                return wrapper.execute((String[])objectArray[0]);
            }
        }
        throw new ReflectionException(new NoSuchMethodException(string));
    }

    private static String transform(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.' || c == '_') {
                bl = false;
                bl2 = true;
                continue;
            }
            if (bl2) {
                bl2 = false;
                stringBuilder.append(Character.toUpperCase(c));
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toLowerCase(c));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private Descriptor commandDescriptor(Wrapper wrapper) throws IllegalArgumentException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dcmd.name", wrapper.info.getName());
        hashMap.put("dcmd.description", wrapper.info.getDescription());
        hashMap.put("dcmd.vmImpact", wrapper.info.getImpact());
        hashMap.put("dcmd.permissionClass", wrapper.info.getPermissionClass());
        hashMap.put("dcmd.permissionName", wrapper.info.getPermissionName());
        hashMap.put("dcmd.permissionAction", wrapper.info.getPermissionAction());
        hashMap.put("dcmd.enabled", wrapper.info.isEnabled());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("help ");
        stringBuilder.append(wrapper.info.getName());
        hashMap.put("dcmd.help", this.executeDiagnosticCommand(stringBuilder.toString()));
        if (wrapper.info.getArgumentsInfo() != null && !wrapper.info.getArgumentsInfo().isEmpty()) {
            HashMap<String, ImmutableDescriptor> hashMap2 = new HashMap<String, ImmutableDescriptor>();
            for (DiagnosticCommandArgumentInfo diagnosticCommandArgumentInfo : wrapper.info.getArgumentsInfo()) {
                HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
                hashMap3.put("dcmd.arg.name", diagnosticCommandArgumentInfo.getName());
                hashMap3.put("dcmd.arg.type", diagnosticCommandArgumentInfo.getType());
                hashMap3.put("dcmd.arg.description", diagnosticCommandArgumentInfo.getDescription());
                hashMap3.put("dcmd.arg.isMandatory", diagnosticCommandArgumentInfo.isMandatory());
                hashMap3.put("dcmd.arg.isMultiple", diagnosticCommandArgumentInfo.isMultiple());
                boolean bl = diagnosticCommandArgumentInfo.isOption();
                hashMap3.put("dcmd.arg.isOption", bl);
                if (!bl) {
                    hashMap3.put("dcmd.arg.position", diagnosticCommandArgumentInfo.getPosition());
                } else {
                    hashMap3.put("dcmd.arg.position", -1);
                }
                hashMap2.put(diagnosticCommandArgumentInfo.getName(), new ImmutableDescriptor(hashMap3));
            }
            hashMap.put("dcmd.arguments", new ImmutableDescriptor(hashMap2));
        }
        return new ImmutableDescriptor(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        DiagnosticCommandImpl diagnosticCommandImpl = this;
        synchronized (diagnosticCommandImpl) {
            if (this.notifInfo == null) {
                this.notifInfo = new MBeanNotificationInfo[1];
                this.notifInfo[0] = new MBeanNotificationInfo(diagFramNotifTypes, notifName, "Diagnostic Framework Notification");
            }
        }
        return this.notifInfo;
    }

    private static long getNextSeqNumber() {
        return ++seqNumber;
    }

    private void createDiagnosticFrameworkNotification() {
        if (!this.hasListeners()) {
            return;
        }
        ObjectName objectName = null;
        try {
            objectName = ObjectName.getInstance("com.sun.management:type=DiagnosticCommand");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        Notification notification = new Notification("jmx.mbean.info.changed", objectName, DiagnosticCommandImpl.getNextSeqNumber());
        notification.setUserData(this.getMBeanInfo());
        this.sendNotification(notification);
    }

    @Override
    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        boolean bl = this.hasListeners();
        super.addNotificationListener(notificationListener, notificationFilter, object);
        boolean bl2 = this.hasListeners();
        if (!bl && bl2) {
            this.setNotificationEnabled(true);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        boolean bl = this.hasListeners();
        super.removeNotificationListener(notificationListener);
        boolean bl2 = this.hasListeners();
        if (bl && !bl2) {
            this.setNotificationEnabled(false);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        boolean bl = this.hasListeners();
        super.removeNotificationListener(notificationListener, notificationFilter, object);
        boolean bl2 = this.hasListeners();
        if (bl && !bl2) {
            this.setNotificationEnabled(false);
        }
    }

    private native void setNotificationEnabled(boolean var1);

    private native String[] getDiagnosticCommands();

    private native DiagnosticCommandInfo[] getDiagnosticCommandInfo(String[] var1);

    private native String executeDiagnosticCommand(String var1);

    private static class OperationInfoComparator
    implements Comparator<MBeanOperationInfo> {
        private OperationInfoComparator() {
        }

        @Override
        public int compare(MBeanOperationInfo mBeanOperationInfo, MBeanOperationInfo mBeanOperationInfo2) {
            return mBeanOperationInfo.getName().compareTo(mBeanOperationInfo2.getName());
        }
    }

    private class Wrapper {
        String name;
        String cmd;
        DiagnosticCommandInfo info;
        Permission permission;

        Wrapper(String string, String string2, DiagnosticCommandInfo diagnosticCommandInfo) throws InstantiationException {
            this.name = string;
            this.cmd = string2;
            this.info = diagnosticCommandInfo;
            this.permission = null;
            Exception exception = null;
            if (diagnosticCommandInfo.getPermissionClass() != null) {
                Serializable serializable;
                try {
                    Constructor<Object> constructor;
                    serializable = Class.forName(diagnosticCommandInfo.getPermissionClass());
                    if (diagnosticCommandInfo.getPermissionAction() == null) {
                        try {
                            constructor = ((Class)serializable).getConstructor(String.class);
                            this.permission = (Permission)constructor.newInstance(diagnosticCommandInfo.getPermissionName());
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception2) {
                            exception = exception2;
                        }
                    }
                    if (this.permission == null) {
                        try {
                            constructor = ((Class)serializable).getConstructor(String.class, String.class);
                            this.permission = (Permission)constructor.newInstance(diagnosticCommandInfo.getPermissionName(), diagnosticCommandInfo.getPermissionAction());
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception3) {
                            exception = exception3;
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (this.permission == null) {
                    serializable = new InstantiationException("Unable to instantiate required permission");
                    ((Throwable)serializable).initCause(exception);
                }
            }
        }

        public String execute(String[] stringArray) {
            Object object;
            if (this.permission != null && (object = System.getSecurityManager()) != null) {
                ((SecurityManager)object).checkPermission(this.permission);
            }
            if (stringArray == null) {
                return DiagnosticCommandImpl.this.executeDiagnosticCommand(this.cmd);
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(this.cmd);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) {
                    throw new IllegalArgumentException("Invalid null argument");
                }
                ((StringBuilder)object).append(" ");
                ((StringBuilder)object).append(stringArray[i]);
            }
            return DiagnosticCommandImpl.this.executeDiagnosticCommand(((StringBuilder)object).toString());
        }
    }
}

