/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import processing.app.Base;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.SketchImportThread;
import processing.app.SketchImportUtility;

public class SketchImportDialog
extends JDialog {
    private static final String ERROR_TITLE_SKETCH_IMPORT = "Import error";
    private static final String PREFERENCES_KEY_WEB_COMPILER_API_KEY = "sketch.import.apikey";
    private Thread importThread;
    private JTextField apiKeyInputJTextField;
    private JLabel apiKeyInputTitleJLabel;
    private JButton cancelJButton;
    private JButton getSketchJButton;
    private JComboBox<String> importActionSelectJComboBox;
    private JLabel importDestinationTitleJLabel;
    private JList<String> importFileSelectJList;
    private JButton importJButton;
    private JLabel importTargetTitleLabelJLabel;
    private JScrollPane jScrollPane1;

    public SketchImportDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initialize();
    }

    private void initialize() {
        this.setTitle(I18n._("SketchImportDialogTitle"));
        this.apiKeyInputTitleJLabel.setText(I18n._("SketchImportApiKeyInputTitleLabel"));
        this.importTargetTitleLabelJLabel.setText(I18n._("SketchImportTargetSketchTitleLabel"));
        this.importDestinationTitleJLabel.setText(I18n._("SketchImportDestinationLabel"));
        this.getSketchJButton.setText(I18n._("SketchImportGetSketchButton"));
        this.importJButton.setText(I18n._("SketchImportImpotButton"));
        this.importActionSelectJComboBox.addItem(I18n._("SketchImportDestinationOpenTab"));
        this.importActionSelectJComboBox.addItem(I18n._("SketchImportDestinationNewTab"));
        try {
            Preferences.load(Base.getLibStream("preferences.txt"));
            this.apiKeyInputJTextField.setText(Preferences.table.get(PREFERENCES_KEY_WEB_COMPILER_API_KEY));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setDisplayEnable(Boolean enabled) {
        try {
            this.apiKeyInputJTextField.setEnabled(enabled);
            this.getSketchJButton.setEnabled(enabled);
            this.importFileSelectJList.setEnabled(enabled);
            this.importActionSelectJComboBox.setEnabled(enabled);
            this.cancelJButton.setEnabled(enabled);
            if (!enabled.booleanValue()) {
                this.importJButton.setEnabled(enabled);
            } else {
                String apiKey = this.apiKeyInputJTextField.getText();
                if (apiKey != null && 0 < apiKey.length() && 0 <= this.importFileSelectJList.getSelectedIndex()) {
                    this.importJButton.setEnabled(enabled);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Boolean isNullOrEmpty(String value) {
        Boolean result = true;
        if (value != null && 0 < value.length()) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCallback(SketchImportThread thread) {
        int code = thread.getCode();
        try {
            if (thread.getSuccess().booleanValue()) {
                if (code == 0) {
                    if (thread.getDisplayItems() != null) {
                        this.importFileSelectJList.setListData((String[])thread.getDisplayItems());
                        this.importFileSelectJList.setSelectedIndex(0);
                    } else {
                        JOptionPane.showMessageDialog(this, I18n._("Failed to acquire sketch information.\\nPlease check whether the Api key is correct."), "E001002", 0);
                    }
                } else if (code == 1) {
                    Editor editor = (Editor)this.getParent();
                    if (this.importActionSelectJComboBox.getSelectedIndex() == 1) {
                        editor.sketch.handleNewTab(thread.getFileName());
                        editor.sketch.setCurrentCode(thread.getFileName());
                    }
                    editor.overwriteTextArea(thread.getFile());
                    this.setVisible(false);
                }
            } else if (code == 0) {
                JOptionPane.showMessageDialog(this, I18n._("Failed to acquire sketch information.") + SketchImportUtility.getSeparator() + thread.getException().getMessage(), "E001001", 0);
            } else if (code == 1) {
                JOptionPane.showMessageDialog(this, I18n._("An attempt to acquire the import file has failed.") + SketchImportUtility.getSeparator() + thread.getException().getMessage(), "E001003", 0);
            }
        }
        finally {
            this.setDisplayEnable(true);
        }
    }

    private void initComponents() {
        this.apiKeyInputTitleJLabel = new JLabel();
        this.apiKeyInputJTextField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.importFileSelectJList = new JList();
        this.importTargetTitleLabelJLabel = new JLabel();
        this.getSketchJButton = new JButton();
        this.importActionSelectJComboBox = new JComboBox();
        this.importDestinationTitleJLabel = new JLabel();
        this.importJButton = new JButton();
        this.cancelJButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("processing/app/i18n/Resources_ja");
        this.setTitle(bundle.getString("SketchImportDialogTitle"));
        this.apiKeyInputTitleJLabel.setFont(new Font("Meiryo UI", 0, 12));
        this.apiKeyInputTitleJLabel.setText(bundle.getString("SketchImportApiKeyInputTitleLabel"));
        this.apiKeyInputTitleJLabel.setToolTipText("");
        this.apiKeyInputJTextField.setFont(new Font("Meiryo UI", 0, 14));
        this.apiKeyInputJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SketchImportDialog.this.apiKeyInputJTextFieldKeyReleased(evt);
            }
        });
        this.importFileSelectJList.setFont(new Font("Meiryo UI", 0, 14));
        this.importFileSelectJList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SketchImportDialog.this.importFileSelectJListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.importFileSelectJList);
        this.importTargetTitleLabelJLabel.setFont(new Font("Meiryo UI", 0, 14));
        this.importTargetTitleLabelJLabel.setText(bundle.getString("SketchImportTargetSketchTitleLabel"));
        this.getSketchJButton.setFont(new Font("Meiryo UI", 0, 14));
        this.getSketchJButton.setText(bundle.getString("SketchImportGetSketchButton"));
        this.getSketchJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SketchImportDialog.this.getSketchJButtonActionPerformed(evt);
            }
        });
        this.importActionSelectJComboBox.setFont(new Font("Meiryo UI", 0, 14));
        this.importDestinationTitleJLabel.setFont(new Font("Meiryo UI", 0, 14));
        this.importDestinationTitleJLabel.setText(bundle.getString("SketchImportDestinationLabel"));
        this.importJButton.setFont(new Font("Meiryo UI", 0, 14));
        this.importJButton.setText(bundle.getString("SketchImportImpotButton"));
        this.importJButton.setEnabled(false);
        this.importJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SketchImportDialog.this.importJButtonActionPerformed(evt);
            }
        });
        this.cancelJButton.setFont(new Font("Meiryo UI", 0, 14));
        this.cancelJButton.setText("Cancel");
        this.cancelJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SketchImportDialog.this.cancelJButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.apiKeyInputTitleJLabel).addGroup(layout.createSequentialGroup().addComponent(this.apiKeyInputJTextField, -2, 267, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getSketchJButton)).addComponent(this.importTargetTitleLabelJLabel).addComponent(this.jScrollPane1)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.importDestinationTitleJLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importActionSelectJComboBox, -2, 240, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.importJButton, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelJButton, -2, 87, -2))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.apiKeyInputTitleJLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.apiKeyInputJTextField, -2, -1, -2).addComponent(this.getSketchJButton, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.importTargetTitleLabelJLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.importActionSelectJComboBox, -2, -1, -2).addComponent(this.importDestinationTitleJLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.importJButton, -2, 24, -2).addComponent(this.cancelJButton, -2, 24, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.apiKeyInputTitleJLabel.getAccessibleContext().setAccessibleName("");
        this.getSketchJButton.getAccessibleContext().setAccessibleName("");
        this.pack();
    }

    private void apiKeyInputJTextFieldKeyReleased(KeyEvent evt) {
        if (0 <= this.importFileSelectJList.getSelectedIndex() && !this.isNullOrEmpty(this.apiKeyInputJTextField.getText()).booleanValue()) {
            this.importJButton.setEnabled(true);
        } else {
            this.importJButton.setEnabled(false);
        }
    }

    private void getSketchJButtonActionPerformed(ActionEvent evt) {
        String apiKey = this.apiKeyInputJTextField.getText();
        try {
            Preferences.table.put(PREFERENCES_KEY_WEB_COMPILER_API_KEY, apiKey);
            Preferences.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (apiKey != null && 0 < apiKey.length()) {
            this.setDisplayEnable(false);
            this.importFileSelectJList.setListData((String[])new String[0]);
            SketchImportThread thread = new SketchImportThread(0, this, this.apiKeyInputJTextField.getText(), null);
            thread.start();
        } else {
            JOptionPane.showMessageDialog(this, I18n._("Please enter Api key."), "E001000", 0);
        }
    }

    private void importFileSelectJListValueChanged(ListSelectionEvent evt) {
        if (0 <= this.importFileSelectJList.getSelectedIndex() && !this.isNullOrEmpty(this.apiKeyInputJTextField.getText()).booleanValue()) {
            this.importJButton.setEnabled(true);
        } else {
            this.importJButton.setEnabled(false);
        }
    }

    private void importJButtonActionPerformed(ActionEvent evt) {
        if (0 <= this.importFileSelectJList.getSelectedIndex()) {
            this.setDisplayEnable(false);
            this.importThread = new SketchImportThread(1, this, this.apiKeyInputJTextField.getText(), this.importFileSelectJList.getSelectedValue());
            this.importThread.start();
        }
    }

    private void cancelJButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SketchImportDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SketchImportDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SketchImportDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SketchImportDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SketchImportDialog dialog = new SketchImportDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

