/*
 * Decompiled with CFR 0.152.
 */
package processing.app.linux;

import java.io.File;
import processing.app.Preferences;
import processing.core.PConstants;

public class Platform
extends processing.app.Platform {
    @Override
    public void setLookAndFeel() throws Exception {
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        File home2 = new File(System.getProperty("user.home"));
        return new File(home2, "Arduino");
    }

    @Override
    public void openURL(String url) throws Exception {
        String launcher;
        if (this.openFolderAvailable() && (launcher = Preferences.get("launcher")) != null) {
            Runtime.getRuntime().exec(new String[]{launcher, url});
        }
    }

    @Override
    public boolean openFolderAvailable() {
        if (Preferences.get("launcher") != null) {
            return true;
        }
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"xdg-open"});
            p.waitFor();
            Preferences.set("launcher", "xdg-open");
            return true;
        }
        catch (Exception p) {
            try {
                Process p2 = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                p2.waitFor();
                Preferences.set("launcher", "gnome-open");
                return true;
            }
            catch (Exception p2) {
                try {
                    Process p3 = Runtime.getRuntime().exec(new String[]{"kde-open"});
                    p3.waitFor();
                    Preferences.set("launcher", "kde-open");
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
    }

    @Override
    public void openFolder(File file) throws Exception {
        if (this.openFolderAvailable()) {
            String launcher = Preferences.get("launcher");
            try {
                String[] params = new String[]{launcher, file.getAbsolutePath()};
                Runtime.getRuntime().exec(params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No launcher set, cannot open " + file.getAbsolutePath());
        }
    }

    @Override
    public String getName() {
        return PConstants.platformNames[3];
    }
}

