/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.Token;

public class SyntaxUtilities {
    private static Pattern urlPattern = Pattern.compile("((?:https?|ftp)://(?:(?:[\\w_\\-]+:)?[\\w_\\-]+@)?(?:[\\w_\\-]+\\.)+[\\w_\\-]+(?::[0-9]{1,5})?(?:/[\\w_\\-./?%&=+]*)?)(?:\\s|$)");

    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, String match) {
        int length = offset + match.length();
        char[] textArray = text.array;
        if (length > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length) {
            char c1 = textArray[i];
            char c2 = match.charAt(j);
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, char[] match) {
        int length = offset + match.length;
        char[] textArray = text.array;
        if (length > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length) {
            char c1 = textArray[i];
            char c2 = match[j];
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static SyntaxStyle[] getDefaultSyntaxStyles() {
        SyntaxStyle[] styles = new SyntaxStyle[12];
        styles[1] = new SyntaxStyle(Color.black, true, false, false);
        styles[2] = new SyntaxStyle(new Color(0x990033), true, false, false);
        styles[6] = new SyntaxStyle(Color.black, false, true, false);
        styles[7] = new SyntaxStyle(Color.magenta, false, false, false);
        styles[8] = new SyntaxStyle(new Color(38400), false, false, false);
        styles[3] = new SyntaxStyle(new Color(6619289), false, false, false);
        styles[4] = new SyntaxStyle(new Color(6619289), false, true, false);
        styles[5] = new SyntaxStyle(new Color(0x990033), false, true, false);
        styles[9] = new SyntaxStyle(Color.black, false, true, false);
        styles[10] = new SyntaxStyle(Color.blue, true, false, false);
        styles[11] = new SyntaxStyle(Color.red, false, true, false);
        return styles;
    }

    public static int paintSyntaxLine(Segment line, Token tokens, SyntaxStyle[] styles, TabExpander expander, Graphics gfx, int x, int y) {
        byte id;
        Font defaultFont = gfx.getFont();
        Color defaultColor = gfx.getColor();
        int offset = 0;
        while ((id = tokens.id) != 127) {
            int length = tokens.length;
            if (id == 0) {
                if (!defaultColor.equals(gfx.getColor())) {
                    gfx.setColor(defaultColor);
                }
                if (!defaultFont.equals(gfx.getFont())) {
                    gfx.setFont(defaultFont);
                }
            } else {
                styles[id].setGraphicsFlags(gfx, defaultFont);
            }
            line.count = length;
            x = id == 1 || id == 2 ? SyntaxUtilities.drawTabbedCommentsText(line, x, y, gfx, expander, styles, styles[id]) : Utilities.drawTabbedText(line, x, y, gfx, expander, 0);
            line.offset += length;
            offset += length;
            tokens = tokens.next;
        }
        return x;
    }

    public static String[] parseCommentUrls(String line) {
        Matcher m = urlPattern.matcher(line.toString());
        if (!m.find()) {
            return null;
        }
        String[] res = new String[]{line.substring(0, m.start(1)), line.substring(m.start(1), m.end(1)), line.substring(m.end(1))};
        return res;
    }

    public static Segment stringToSegment(String v) {
        return new Segment(v.toCharArray(), 0, v.length());
    }

    private static int drawTabbedCommentsText(Segment line, int x, int y, Graphics gfx, TabExpander expander, SyntaxStyle[] styles, SyntaxStyle commentStyle) {
        String[] parse = SyntaxUtilities.parseCommentUrls(line.toString());
        if (parse == null) {
            return Utilities.drawTabbedText(line, x, y, gfx, expander, 0);
        }
        Segment pre = SyntaxUtilities.stringToSegment(parse[0]);
        Segment tag = SyntaxUtilities.stringToSegment(parse[1]);
        Segment post = SyntaxUtilities.stringToSegment(parse[2]);
        if (pre.count > 0) {
            x = Utilities.drawTabbedText(pre, x, y, gfx, expander, 0);
        }
        Font f = gfx.getFont();
        styles[10].setGraphicsFlags(gfx, f);
        x = Utilities.drawTabbedText(tag, x, y, gfx, expander, 0);
        commentStyle.setGraphicsFlags(gfx, f);
        if (post.count > 0) {
            x = Utilities.drawTabbedText(post, x, y, gfx, expander, 0);
        }
        return x;
    }

    private SyntaxUtilities() {
    }
}

