// Flash Air Shared Memory example
// 
// Required hardware : Flash Air and List.htm stored in flashair/SD_WLAN
//  List.htm: http://gadget.renesas.com/software/lychee_flashair/List.htm
//
// Public Domain
// This sample is based on below example for Flash Air
// https://flashair-developers.com/en/documents/tutorials/users/3/

#include <SPI.h>
#include <SD.h>
#include <iSdio.h>
#include <utility/Sd2CardExt.h>
#include <Camera.h>
#include <RTC.h>

Camera camera(640, 480);
RTC rtc;

void dateTime(uint16_t* date, uint16_t* time) {
  int year, mon, day, hour, min, sec, week;
  rtc.getDateTime(year, mon, day, hour, min, sec, week);
  *date = FAT_DATE(year, mon, day);
  *time = FAT_TIME(hour, min, sec);
}

#define FLASHAIR_MEM_SIZE 512
#define FLASHAIR_MEM_USE 1
// In case of GR-LYCHEE, a dedicated CS pin is used.
const int chipSelectPin = 4;
Sd2CardExt card;
uint8_t buffer_sharedMem[FLASHAIR_MEM_SIZE];

boolean iSDIO_sharedMemRead(uint8_t* buf, int size) {
  if (!card.readExtMemory(1, 1, 0x1000, size, buf)) {
    return false;
  }
}

boolean iSDIO_sharedMemWrite(uint8_t* buf, int size) {
  if (!card.writeExtMemory(1, 1, 0x1000, size, buf)) {
    return false;
  }
}

void setup() {
  Serial.begin(9600);
  pinMode(PIN_LED_ORANGE, OUTPUT);
  pinMode(PIN_LED_RED, OUTPUT); // for error
  
  // Turn ESP32 off to stable Wi-Fi
  pinMode(PIN_ESP_EN, OUTPUT);
  digitalWrite(PIN_ESP_EN, LOW);

  // Initialize SD card.
  Serial.print(F("\nInitializing SD card..."));  
  if (card.init(SPI_FULL_SPEED, chipSelectPin)) {
    Serial.println(F("OK"));
  } else {
    Serial.println(F("NG"));
    digitalWrite(PIN_LED_RED, HIGH);
    abort();
  }

  camera.begin();
  rtc.begin();

  rtc.setDateTime(2017, 6, 17, 14, 1, 0);
  SdFile::dateTimeCallback(&dateTime);
  

  // Initializing memory to access with command.cgi op=130 from browser
  // Fill out memory to '0', because HTTP returns ASCII code
  Serial.print(F("\nInitializing shared memory in Flash Air..."));
  memset(buffer_sharedMem, '0', FLASHAIR_MEM_SIZE);
  if(true == iSDIO_sharedMemWrite(buffer_sharedMem, sizeof(buffer_sharedMem))){
    Serial.println(F("OK"));
  } 
  else {
    Serial.println(F("NG"));
    abort();
  }
}

void loop() {
  const char filename[13] = "LYCHEE.JPG";
  if(true == iSDIO_sharedMemRead(buffer_sharedMem, FLASHAIR_MEM_USE)){
  } else {
    digitalWrite(PIN_LED_RED, HIGH);
    Serial.println(F("NG"));
    abort();
  }
  if(buffer_sharedMem[0] == '1'){
    SD.begin();
    SD.remove(filename);
    File file = SD.open(filename, FILE_WRITE);
    if (file) {
      digitalWrite(PIN_LED_ORANGE, HIGH);
      size_t size = camera.createJpeg();
      uint8_t* adr = camera.getJpegAdr();
      for (size_t i = 0; i < size; i++) {
        file.write(*adr);
        adr++;
      }
      file.close();
      digitalWrite(PIN_LED_ORANGE, LOW);
    } else {
      digitalWrite(PIN_LED_RED, HIGH);
      abort();
    }
    card.init(SPI_FULL_SPEED, chipSelectPin);
    buffer_sharedMem[0] = '0';
    iSDIO_sharedMemWrite(buffer_sharedMem, 1);
  }
  delay(500);
}

