/***********************************************************************/
/*                                                                     */
/*  FILE        :LED_Sample.c                                          */
/*  DATE        :Thu, Nov 26, 2009                                     */
/*  DESCRIPTION :Main Program                                          */
/*  CPU TYPE    :RX610                                                 */
/*                                                                     */
/*  This file is generated by Renesas Project Generator (Ver.4.50).    */
/*  NOTE:THIS IS A TYPICAL EXAMPLE.                                    */
/*                                                                     */
/***********************************************************************/
//#include <machine.h>

//#include "iodefine_v1.01_gnu.h"
//#include "iodefine_v1.02_gnu.h"
#include "iodefine.h"
#include "tpu.h"
#include "lcd.h"

int main(void)
{
	unsigned long Delay;
	
	/* 	Reset the LCD module. */
	InitialiseDisplay();
	
	/*	Display the application name on LCD.	*/
	DisplayString(LCD_LINE1,"RX610");	
	DisplayString(LCD_LINE2,"GNU Demo");	
	
	InitTPU2();
	InitTPU1();
	InitTPU0();
	
	StartTPU2();
	StartTPU1();
	StartTPU0();
	
	while(1)
	{
		if(PORT1.PORT.BIT.B3 == 0)	// Switch 3
		{
			// S/W debounce
			for(Delay=0; Delay<5000000; Delay++);
			
			
			if(TPUA.TSTR.BIT.CST0 == 1)	
			{
				TPUA.TSTR.BIT.CST0 = 0;	
				DisplayString(LCD_LINE1,"TPU0    ");	
				DisplayString(LCD_LINE2,"Stopped ");	
			}
			else
			{
				TPUA.TSTR.BIT.CST0 = 1;	
				DisplayString(LCD_LINE1,"TPU0    ");	
				DisplayString(LCD_LINE2,"Running ");	
			}
		}
		
		if(PORT0.PORT.BIT.B1 == 0)	// Switch 2
		{
			// S/W debounce
			for(Delay=0; Delay<5000000; Delay++);
			
			
			if(TPUA.TSTR.BIT.CST1 == 1)	
			{
				TPUA.TSTR.BIT.CST1 = 0;	
				DisplayString(LCD_LINE1,"TPU1    ");	
				DisplayString(LCD_LINE2,"Stopped ");	
			}
			else
			{
				TPUA.TSTR.BIT.CST1 = 1;	
				DisplayString(LCD_LINE1,"TPU1    ");	
				DisplayString(LCD_LINE2,"Running ");	
			}
		}
		
		if(PORT0.PORT.BIT.B0 == 0)	// Switch 1
		{
			// S/W debounce
			for(Delay=0; Delay<5000000; Delay++);
			
			
			if(TPUA.TSTR.BIT.CST2 == 1)	
			{
				TPUA.TSTR.BIT.CST2 = 0;	
				DisplayString(LCD_LINE1,"TPU2    ");	
				DisplayString(LCD_LINE2,"Stopped ");	
			}
			else
			{
				TPUA.TSTR.BIT.CST2 = 1;	
				DisplayString(LCD_LINE1,"TPU2    ");	
				DisplayString(LCD_LINE2,"Running ");	
			}
		}
	}

	return 0;
}

