/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class TagInfoset {
    @NotNull
    public final String[] ns;
    @NotNull
    public final AttributesImpl atts;
    @Nullable
    public final String prefix;
    @Nullable
    public final String nsUri;
    @NotNull
    public final String localName;
    @Nullable
    private String qname;
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();

    public TagInfoset(String string, String string2, String string3, AttributesImpl attributesImpl, String ... stringArray) {
        this.nsUri = string;
        this.prefix = string3;
        this.localName = string2;
        this.atts = attributesImpl;
        this.ns = stringArray;
    }

    public TagInfoset(XMLStreamReader xMLStreamReader) {
        int n;
        this.prefix = xMLStreamReader.getPrefix();
        this.nsUri = xMLStreamReader.getNamespaceURI();
        this.localName = xMLStreamReader.getLocalName();
        int n2 = xMLStreamReader.getNamespaceCount();
        if (n2 > 0) {
            this.ns = new String[n2 * 2];
            for (n = 0; n < n2; ++n) {
                this.ns[n * 2] = TagInfoset.fixNull(xMLStreamReader.getNamespacePrefix(n));
                this.ns[n * 2 + 1] = TagInfoset.fixNull(xMLStreamReader.getNamespaceURI(n));
            }
        } else {
            this.ns = EMPTY_ARRAY;
        }
        if ((n = xMLStreamReader.getAttributeCount()) > 0) {
            this.atts = new AttributesImpl();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                String string;
                stringBuilder.setLength(0);
                String string2 = xMLStreamReader.getAttributePrefix(i);
                String string3 = xMLStreamReader.getAttributeLocalName(i);
                if (string2 != null && string2.length() != 0) {
                    stringBuilder.append(string2);
                    stringBuilder.append(":");
                    stringBuilder.append(string3);
                    string = stringBuilder.toString();
                } else {
                    string = string3;
                }
                this.atts.addAttribute(TagInfoset.fixNull(xMLStreamReader.getAttributeNamespace(i)), string3, string, xMLStreamReader.getAttributeType(i), xMLStreamReader.getAttributeValue(i));
            }
        } else {
            this.atts = EMPTY_ATTRIBUTES;
        }
    }

    public void writeStart(ContentHandler contentHandler) throws SAXException {
        for (int i = 0; i < this.ns.length; i += 2) {
            contentHandler.startPrefixMapping(TagInfoset.fixNull(this.ns[i]), TagInfoset.fixNull(this.ns[i + 1]));
        }
        contentHandler.startElement(TagInfoset.fixNull(this.nsUri), this.localName, this.getQName(), this.atts);
    }

    public void writeEnd(ContentHandler contentHandler) throws SAXException {
        contentHandler.endElement(TagInfoset.fixNull(this.nsUri), this.localName, this.getQName());
        for (int i = this.ns.length - 2; i >= 0; i -= 2) {
            contentHandler.endPrefixMapping(TagInfoset.fixNull(this.ns[i]));
        }
    }

    public void writeStart(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        int n;
        if (this.prefix == null) {
            if (this.nsUri == null) {
                xMLStreamWriter.writeStartElement(this.localName);
            } else {
                xMLStreamWriter.writeStartElement("", this.localName, this.nsUri);
            }
        } else {
            xMLStreamWriter.writeStartElement(this.prefix, this.localName, this.nsUri);
        }
        for (n = 0; n < this.ns.length; n += 2) {
            xMLStreamWriter.writeNamespace(this.ns[n], this.ns[n + 1]);
        }
        for (n = 0; n < this.atts.getLength(); ++n) {
            String string = this.atts.getURI(n);
            if (string == null || string.length() == 0) {
                xMLStreamWriter.writeAttribute(this.atts.getLocalName(n), this.atts.getValue(n));
                continue;
            }
            String string2 = this.atts.getQName(n);
            String string3 = string2.substring(0, string2.indexOf(58));
            xMLStreamWriter.writeAttribute(string3, string, this.atts.getLocalName(n), this.atts.getValue(n));
        }
    }

    private String getQName() {
        if (this.qname != null) {
            return this.qname;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.prefix != null) {
            stringBuilder.append(this.prefix);
            stringBuilder.append(':');
            stringBuilder.append(this.localName);
            this.qname = stringBuilder.toString();
        } else {
            this.qname = this.localName;
        }
        return this.qname;
    }

    private static String fixNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getNamespaceURI(String string) {
        int n = this.ns.length / 2;
        for (int i = 0; i < n; ++i) {
            String string2 = this.ns[i * 2];
            String string3 = this.ns[i * 2 + 1];
            if (!string.equals(string2)) continue;
            return string3;
        }
        return null;
    }

    public String getPrefix(String string) {
        int n = this.ns.length / 2;
        for (int i = 0; i < n; ++i) {
            String string2 = this.ns[i * 2];
            String string3 = this.ns[i * 2 + 1];
            if (!string.equals(string3)) continue;
            return string2;
        }
        return null;
    }

    public List<String> allPrefixes(String string) {
        int n = this.ns.length / 2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String string2 = this.ns[i * 2];
            String string3 = this.ns[i * 2 + 1];
            if (!string.equals(string3)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }
}

