/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import processing.app.Editor;
import processing.app.EditorConsole;
import processing.app.I18n;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.Theme;
import processing.app.UpdateManager;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.FileUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.filefilters.OnlyDirs;
import processing.app.helpers.filefilters.OnlyFilesWithExtension;
import processing.app.packages.Library;
import processing.app.packages.LibraryList;
import processing.app.tools.ZipDeflater;
import processing.core.PApplet;

public class Base {
    public static final int REVISION = 1100;
    static String VERSION_NAME = "1.01";
    public static boolean RELEASE = false;
    static Map<Integer, String> platformNames = new HashMap<Integer, String>();
    static HashMap<String, Integer> platformIndices;
    static Platform platform;
    private static boolean commandLine;
    Preferences preferencesFrame;
    boolean builtOnce;
    static File buildFolder;
    private static File examplesFolder;
    private static File toolsFolder;
    private static List<File> librariesFolders;
    private static LibraryList libraries;
    static Map<String, Library> importToLibraryTable;
    public static String librariesClassPath;
    public static Map<String, TargetPackage> packages;
    static File untitledFolder;
    List<Editor> editors = Collections.synchronizedList(new ArrayList());
    Editor activeEditor;
    static File portableFolder;
    static final String portableSketchbookFolder = "sketchbook";
    boolean breakTime = false;
    String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

    public static void main(String[] args) throws Exception {
        block6: {
            Base.initPlatform();
            portableFolder = Base.getContentFile("portable");
            if (!portableFolder.exists()) {
                portableFolder = null;
            }
            Preferences.init(null);
            try {
                String version;
                File versionFile = Base.getContentFile("lib/version.txt");
                if (versionFile.exists() && !(version = PApplet.loadStrings((File)versionFile)[0]).equals(VERSION_NAME) && !version.equals("${version}")) {
                    VERSION_NAME = version;
                    RELEASE = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Preferences.set("last.ide." + VERSION_NAME + ".hardwarepath", Base.getHardwarePath());
            Preferences.set("last.ide." + VERSION_NAME + ".daterun", "" + new Date().getTime() / 1000L);
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            Theme.init();
            try {
                platform.setLookAndFeel();
            }
            catch (Exception e) {
                String mess = e.getMessage();
                if (mess.indexOf("ch.randelshofer.quaqua.QuaquaLookAndFeel") != -1) break block6;
                System.err.println(I18n._("Non-fatal error while setting the Look & Feel."));
                System.err.println(I18n._("The error message follows, however Arduino should run fine."));
                System.err.println(mess);
            }
        }
        untitledFolder = Base.createTempFolder("untitled");
        untitledFolder.deleteOnExit();
        new Base(args);
    }

    protected static void setCommandLine() {
        commandLine = true;
    }

    protected static boolean isCommandLine() {
        return commandLine;
    }

    protected static void initPlatform() {
        try {
            Class<?> platformClass = Class.forName("processing.app.Platform");
            if (Base.isMacOS()) {
                platformClass = Class.forName("processing.app.macosx.Platform");
            } else if (Base.isWindows()) {
                platformClass = Class.forName("processing.app.windows.Platform");
            } else if (Base.isLinux()) {
                platformClass = Class.forName("processing.app.linux.Platform");
            }
            platform = (Platform)platformClass.newInstance();
        }
        catch (Exception e) {
            Base.showError(I18n._("Problem Setting the Platform"), I18n._("An unknown error occurred while trying to load\nplatform-specific code for your machine."), e);
        }
    }

    protected static void initRequirements() {
        try {
            Class.forName("com.sun.jdi.VirtualMachine");
        }
        catch (ClassNotFoundException cnfe) {
            Base.showPlatforms();
            Base.showError(I18n._("Please install JDK 1.5 or later"), I18n._("Arduino requires a full JDK (not just a JRE)\nto run. Please install JDK 1.5 or later.\nMore information can be found in the reference."), cnfe);
        }
    }

    public Base(String[] args) throws Exception {
        UpdateManager manager;
        File sketchbookFolder;
        platform.init(this);
        String sketchbookPath = Preferences.get("sketchbook.path");
        if (sketchbookPath != null && !(sketchbookFolder = portableFolder != null ? new File(portableFolder, sketchbookPath) : new File(sketchbookPath)).exists()) {
            Base.showWarning(I18n._("Sketchbook folder disappeared"), I18n._("The sketchbook folder no longer exists.\nArduino will switch to the default sketchbook\nlocation, and create a new sketchbook folder if\nnecessary. Arduino will then stop talking about\nhimself in the third person."), null);
            sketchbookPath = null;
        }
        if (sketchbookPath == null) {
            File defaultFolder = this.getDefaultSketchbookFolder();
            if (portableFolder != null) {
                Preferences.set("sketchbook.path", portableSketchbookFolder);
            } else {
                Preferences.set("sketchbook.path", defaultFolder.getAbsolutePath());
            }
            if (!defaultFolder.exists()) {
                defaultFolder.mkdirs();
            }
        }
        packages = new HashMap<String, TargetPackage>();
        this.loadHardware(Base.getHardwareFolder());
        this.loadHardware(Base.getSketchbookHardwareFolder());
        if (packages.size() == 0) {
            System.out.println(I18n._("No valid configured cores found! Exiting..."));
            System.exit(3);
        }
        this.onBoardOrPortChange();
        boolean opened = false;
        boolean doUpload = false;
        boolean doVerify = false;
        boolean doVerbose = false;
        String selectBoard = null;
        String selectPort = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--upload")) {
                doUpload = true;
                continue;
            }
            if (args[i].equals("--verify")) {
                doVerify = true;
                continue;
            }
            if (args[i].equals("--verbose") || args[i].equals("-v")) {
                doVerbose = true;
                continue;
            }
            if (args[i].equals("--board")) {
                if (++i >= args.length) continue;
                selectBoard = args[i];
                continue;
            }
            if (args[i].equals("--port")) {
                if (++i >= args.length) continue;
                selectPort = args[i];
                continue;
            }
            String path = args[i];
            if (Base.isWindows()) {
                try {
                    File file = new File(args[i]);
                    path = file.getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.handleOpen(path) == null) continue;
            opened = true;
        }
        if (doUpload || doVerify) {
            if (!opened) {
                System.out.println(I18n._("Can't open source sketch!"));
                System.exit(2);
            }
            Preferences.set("build.verbose", "" + doVerbose);
            Preferences.set("upload.verbose", "" + doVerbose);
            Editor editor = this.editors.get(0);
            while (!editor.status.isInitialized()) {
                Thread.sleep(10L);
            }
            if (selectBoard != null) {
                this.selectBoard(selectBoard, editor);
            }
            if (doUpload) {
                if (selectPort != null) {
                    editor.selectSerialPort(selectPort);
                }
                editor.exportHandler.run();
            } else {
                editor.runHandler.run();
            }
            int res = editor.status.mode;
            if (res == 1) {
                System.exit(1);
            }
            System.exit(0);
        }
        if (this.restoreSketches()) {
            opened = true;
        }
        if (!opened) {
            this.handleNew();
        }
        if ((manager = new UpdateManager(this.activeEditor)).checkUpdate(false).booleanValue() && manager.confirmUpdate() == 0) {
            manager.update();
        }
    }

    protected boolean restoreSketches() throws Exception {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        boolean windowPositionValid = true;
        if (Preferences.get("last.screen.height") != null) {
            int screenW = Preferences.getInteger("last.screen.width");
            int screenH = Preferences.getInteger("last.screen.height");
            if (screen.width != screenW || screen.height != screenH) {
                windowPositionValid = false;
            }
        } else {
            windowPositionValid = false;
        }
        int count = Preferences.getInteger("last.sketch.count");
        int opened = 0;
        for (int i = 0; i < count; ++i) {
            int[] location;
            String path = Preferences.get("last.sketch" + i + ".path");
            if (portableFolder != null) {
                File absolute = new File(portableFolder, path);
                try {
                    path = absolute.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (windowPositionValid) {
                String locationStr = Preferences.get("last.sketch" + i + ".location");
                location = PApplet.parseInt((String[])PApplet.split((String)locationStr, (char)','));
            } else {
                location = this.nextEditorLocation();
            }
            if (this.handleOpen(path, location) == null) continue;
            ++opened;
        }
        return opened > 0;
    }

    protected void storeSketches() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Preferences.setInteger("last.screen.width", screen.width);
        Preferences.setInteger("last.screen.height", screen.height);
        String untitledPath = untitledFolder.getAbsolutePath();
        int index = 0;
        for (Editor editor : this.editors) {
            String path = editor.getSketch().getMainFilePath();
            if (path.startsWith(untitledPath) && !editor.getSketch().isModified() || portableFolder != null && (path = FileUtils.relativePath(portableFolder.toString(), path)) == null) continue;
            Preferences.set("last.sketch" + index + ".path", path);
            int[] location = editor.getPlacement();
            String locationStr = PApplet.join((String[])PApplet.str((int[])location), (String)",");
            Preferences.set("last.sketch" + index + ".location", locationStr);
            ++index;
        }
        Preferences.setInteger("last.sketch.count", index);
    }

    protected void storeSketchPath(Editor editor, int index) {
        String untitledPath;
        String path = editor.getSketch().getMainFilePath();
        if (path.startsWith(untitledPath = untitledFolder.getAbsolutePath())) {
            path = "";
        } else if (portableFolder != null && (path = FileUtils.relativePath(portableFolder.toString(), path)) == null) {
            path = "";
        }
        Preferences.set("last.sketch" + index + ".path", path);
    }

    protected void handleActivated(Editor whichEditor) {
        this.activeEditor = whichEditor;
        EditorConsole.setEditor(this.activeEditor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] nextEditorLocation() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int defaultWidth = Preferences.getInteger("editor.window.width.default");
        int defaultHeight = Preferences.getInteger("editor.window.height.default");
        if (this.activeEditor == null) {
            return new int[]{(screen.width - defaultWidth) / 2, (screen.height - defaultHeight) / 2, defaultWidth, defaultHeight, 0};
        }
        List<Editor> list = this.editors;
        synchronized (list) {
            int OVER = 50;
            Editor lastOpened = this.editors.get(this.editors.size() - 1);
            int[] location = lastOpened.getPlacement();
            location[0] = location[0] + 50;
            location[1] = location[1] + 50;
            if (location[0] == 50 || location[2] == 50 || location[0] + location[2] > screen.width || location[1] + location[3] > screen.height) {
                return new int[]{(int)(Math.random() * (double)(screen.width - defaultWidth)), (int)(Math.random() * (double)(screen.height - defaultHeight)), defaultWidth, defaultHeight, 0};
            }
            return location;
        }
    }

    protected String createNewUntitled() throws IOException {
        File newbieDir = null;
        String newbieName = null;
        File sketchbookDir = Base.getSketchbookFolder();
        File newbieParentDir = untitledFolder;
        int index = 0;
        Calendar cal = Calendar.getInstance();
        int day = cal.get(5);
        int month = cal.get(2);
        String purty = this.months[month] + PApplet.nf((int)day, (int)2);
        do {
            if (index == 26) {
                if (!this.breakTime) {
                    Base.showWarning(I18n._("Time for a Break"), I18n._("You've reached the limit for auto naming of new sketches\nfor the day. How about going for a walk instead?"), null);
                    this.breakTime = true;
                } else {
                    Base.showWarning(I18n._("Sunshine"), I18n._("No really, time for some fresh air for you."), null);
                }
                return null;
            }
            newbieName = "sketch_" + purty + (char)(97 + index);
            newbieDir = new File(newbieParentDir, newbieName);
            ++index;
        } while (newbieDir.exists() || new File(sketchbookDir, newbieName).exists());
        newbieDir.mkdirs();
        File newbieFile = new File(newbieDir, newbieName + ".ino");
        if (!newbieFile.createNewFile()) {
            throw new IOException();
        }
        FileUtils.copyFile(new File(Base.getContentFile("examples"), "01.Basics" + File.separator + "BareMinimum" + File.separator + "BareMinimum.ino"), newbieFile);
        return newbieFile.getAbsolutePath();
    }

    public void handleNew() throws Exception {
        block3: {
            try {
                String path = this.createNewUntitled();
                if (path != null) {
                    Editor editor = this.handleOpen(path);
                    editor.untitled = true;
                }
            }
            catch (IOException e) {
                if (this.activeEditor == null) break block3;
                this.activeEditor.statusError(e);
            }
        }
    }

    public void handleNewReplace() {
        if (!this.activeEditor.checkModified()) {
            return;
        }
        this.activeEditor.internalCloseRunner();
        this.handleNewReplaceImpl();
    }

    protected void handleNewReplaceImpl() {
        try {
            String path = this.createNewUntitled();
            if (path != null) {
                this.activeEditor.handleOpenInternal(path);
                this.activeEditor.untitled = true;
            }
        }
        catch (IOException e) {
            this.activeEditor.statusError(e);
        }
    }

    public void handleOpenReplace(String path) {
        if (!this.activeEditor.checkModified()) {
            return;
        }
        this.activeEditor.internalCloseRunner();
        boolean loaded = this.activeEditor.handleOpenInternal(path);
        if (!loaded) {
            this.handleNewReplaceImpl();
        }
    }

    public void handleOpenPrompt() throws Exception {
        FileDialog fd = new FileDialog((Frame)this.activeEditor, I18n._("Open an Arduino sketch..."), 0);
        fd.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ino") || name.toLowerCase().endsWith(".pde");
            }
        });
        fd.setVisible(true);
        String directory = fd.getDirectory();
        String filename = fd.getFile();
        if (filename == null) {
            return;
        }
        File inputFile = new File(directory, filename);
        this.handleOpen(inputFile.getAbsolutePath());
    }

    public Editor handleOpen(String path) throws Exception {
        return this.handleOpen(path, this.nextEditorLocation());
    }

    protected Editor handleOpen(String path, int[] location) throws Exception {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        for (Editor editor : this.editors) {
            if (!editor.getSketch().getMainFilePath().equals(path)) continue;
            editor.toFront();
            return editor;
        }
        Editor editor = new Editor(this, path, location);
        if (editor.getSketch() == null) {
            return null;
        }
        this.editors.add(editor);
        editor.setVisible(true);
        return editor;
    }

    public boolean handleClose(Editor editor) {
        if (!editor.checkModified()) {
            return false;
        }
        editor.internalCloseRunner();
        if (this.editors.size() == 1) {
            if (Base.isMacOS()) {
                Object[] options = new Object[]{"OK", "Cancel"};
                String prompt = I18n._("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Are you sure you want to Quit?</b><p>Closing the last open sketch will quit Arduino.");
                int result = JOptionPane.showOptionDialog(editor, prompt, I18n._("Quit"), 0, 3, null, options, options[0]);
                if (result == 1 || result == -1) {
                    return false;
                }
            }
            this.editors.remove(editor);
            Editor.serialMonitor.closeSerialPort();
            this.storeSketches();
            Preferences.save();
            System.exit(0);
        } else {
            editor.setVisible(false);
            editor.dispose();
            this.editors.remove(editor);
        }
        return true;
    }

    public boolean handleQuit() {
        this.storeSketches();
        Editor.serialMonitor.closeSerialPort();
        if (this.handleQuitEach()) {
            for (Editor editor : this.editors) {
                editor.internalCloseRunner();
            }
            Preferences.save();
            if (!Base.isMacOS()) {
                System.exit(0);
            }
            return true;
        }
        return false;
    }

    protected boolean handleQuitEach() {
        int index = 0;
        for (Editor editor : this.editors) {
            if (editor.checkModified()) {
                this.storeSketchPath(editor, index);
                ++index;
                continue;
            }
            return false;
        }
        return true;
    }

    protected void rebuildSketchbookMenus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Base.this.rebuildSketchbookMenu(Editor.sketchbookMenu);
                Base.this.rebuildToolbarMenu(Editor.toolbarMenu);
            }
        });
    }

    protected void rebuildToolbarMenu(JMenu menu) {
        menu.removeAll();
        JMenuItem item = Editor.newJMenuItem(I18n._("Open..."), 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Base.this.handleOpenPrompt();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        menu.add(item);
        menu.addSeparator();
        try {
            boolean sketches = this.addSketches(menu, Base.getSketchbookFolder(), true);
            if (sketches) {
                menu.addSeparator();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            boolean found = this.addSketches(menu, examplesFolder, true);
            if (found) {
                menu.addSeparator();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void rebuildSketchbookMenu(JMenu menu) {
        try {
            menu.removeAll();
            this.addSketches(menu, Base.getSketchbookFolder(), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LibraryList getIDELibs() {
        if (libraries == null) {
            return new LibraryList();
        }
        LibraryList res = new LibraryList(libraries);
        res.removeAll(this.getUserLibs());
        return res;
    }

    public LibraryList getUserLibs() {
        if (libraries == null) {
            return new LibraryList();
        }
        return libraries.filterLibrariesInSubfolder(Base.getSketchbookFolder());
    }

    public void rebuildImportMenu(JMenu importMenu, final Editor editor) {
        importMenu.removeAll();
        JMenuItem addLibraryMenuItem = new JMenuItem(I18n._("Add Library..."));
        addLibraryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Base.this.handleAddLibrary(editor);
                Base.this.onBoardOrPortChange();
                Base.this.rebuildImportMenu(Editor.importMenu, editor);
                Base.this.rebuildExamplesMenu(Editor.examplesMenu);
            }
        });
        importMenu.add(addLibraryMenuItem);
        importMenu.addSeparator();
        TargetPlatform targetPlatform = Base.getTargetPlatform();
        if (targetPlatform != null) {
            LibraryList ideLibs = this.getIDELibs();
            LibraryList userLibs = this.getUserLibs();
            try {
                String platformName;
                PreferencesMap prefs = targetPlatform.getPreferences();
                if (prefs != null && (platformName = (String)prefs.get("name")) != null) {
                    JMenuItem platformItem = new JMenuItem(I18n._(platformName));
                    platformItem.setEnabled(false);
                    importMenu.add(platformItem);
                }
                if (ideLibs.size() > 0) {
                    importMenu.addSeparator();
                    this.addLibraries(importMenu, ideLibs);
                }
                if (userLibs.size() > 0) {
                    importMenu.addSeparator();
                    this.addLibraries(importMenu, userLibs);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void rebuildExamplesMenu(JMenu menu) {
        try {
            menu.removeAll();
            boolean found = this.addSketches(menu, examplesFolder, false);
            if (found) {
                menu.addSeparator();
            }
            LibraryList ideLibs = this.getIDELibs();
            ideLibs.sort();
            for (Library lib : ideLibs) {
                this.addSketchesSubmenu(menu, lib, false);
            }
            LibraryList userLibs = this.getUserLibs();
            if (userLibs.size() > 0) {
                menu.addSeparator();
                userLibs.sort();
                for (Library lib : userLibs) {
                    this.addSketchesSubmenu(menu, lib, false);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LibraryList scanLibraries(List<File> folders) throws IOException {
        LibraryList res = new LibraryList();
        for (File folder : folders) {
            res.addOrReplaceAll(this.scanLibraries(folder));
        }
        return res;
    }

    public LibraryList scanLibraries(File folder) throws IOException {
        LibraryList res = new LibraryList();
        String[] list = folder.list(new OnlyDirs());
        if (list == null) {
            return res;
        }
        for (String libName : list) {
            File subfolder = new File(folder, libName);
            if (!Sketch.isSanitaryName(libName)) {
                String mess = I18n.format(I18n._("The library \"{0}\" cannot be used.\nLibrary names must contain only basic letters and numbers.\n(ASCII only and no spaces, and it cannot start with a number)"), libName);
                Base.showMessage(I18n._("Ignoring bad library name"), mess);
                continue;
            }
            try {
                Library lib = Library.create(subfolder);
                if (lib == null) continue;
                res.addOrReplace(lib);
            }
            catch (IOException e) {
                System.out.println(I18n.format(I18n._("Invalid library found in {0}: {1}"), subfolder, e.getMessage()));
            }
        }
        return res;
    }

    public void onBoardOrPortChange() {
        TargetPlatform targetPlatform = Base.getTargetPlatform();
        if (targetPlatform == null) {
            return;
        }
        examplesFolder = Base.getContentFile("examples");
        toolsFolder = Base.getContentFile("tools");
        File platformFolder = targetPlatform.getFolder();
        librariesFolders = new ArrayList<File>();
        librariesFolders.add(Base.getContentFile("libraries"));
        librariesFolders.add(new File(platformFolder, "libraries"));
        librariesFolders.add(Base.getSketchbookLibrariesFolder());
        try {
            libraries = this.scanLibraries(librariesFolders);
        }
        catch (IOException e) {
            Base.showWarning(I18n._("Error"), I18n._("Error loading libraries"), e);
        }
        String currentArch = Base.getTargetPlatform().getId();
        libraries = libraries.filterByArchitecture(currentArch);
        importToLibraryTable = new HashMap<String, Library>();
        for (Library lib : libraries) {
            try {
                String[] headers;
                for (String header : headers = Base.headerListFromIncludePath(lib.getSrcFolder())) {
                    importToLibraryTable.put(header, lib);
                }
            }
            catch (IOException e) {
                Base.showWarning(I18n._("Error"), I18n.format("Unable to list header files in {0}", lib.getSrcFolder()), e);
            }
        }
        for (Editor editor : this.editors) {
            editor.onBoardOrPortChange();
        }
    }

    public void rebuildBoardsMenu(JMenu toolsMenu, Editor editor) throws Exception {
        JMenu boardsMenu = this.getBoardCustomMenu();
        boolean first = true;
        LinkedList<JMenuItem> menuItemsToClickAfterStartup = new LinkedList<JMenuItem>();
        ButtonGroup boardsButtonGroup = new ButtonGroup();
        HashMap<String, ButtonGroup> buttonGroupsMap = new HashMap<String, ButtonGroup>();
        HashSet titles = new HashSet();
        for (TargetPackage targetPackage : packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.platforms()) {
                titles.addAll(targetPlatform.getCustomMenus().values());
            }
        }
        for (String title : titles) {
            this.makeBoardCustomMenu(toolsMenu, I18n._(title));
        }
        for (TargetPackage targetPackage : packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.platforms()) {
                if (!first) {
                    boardsMenu.add(new JSeparator());
                }
                first = false;
                String platformLabel = (String)targetPlatform.getPreferences().get("name");
                if (platformLabel != null && !targetPlatform.getBoards().isEmpty()) {
                    JMenuItem menuLabel = new JMenuItem(I18n._(platformLabel));
                    menuLabel.setEnabled(false);
                    boardsMenu.add(menuLabel);
                }
                for (TargetBoard board : targetPlatform.getBoards().values()) {
                    JRadioButtonMenuItem item = this.createBoardMenusAndCustomMenus(editor, menuItemsToClickAfterStartup, buttonGroupsMap, board, targetPlatform, targetPackage);
                    boardsMenu.add(item);
                    boardsButtonGroup.add(item);
                }
            }
        }
        if (menuItemsToClickAfterStartup.isEmpty()) {
            menuItemsToClickAfterStartup.add(Base.selectFirstEnabledMenuItem(boardsMenu));
        }
        for (JMenuItem menuItemToClick : menuItemsToClickAfterStartup) {
            menuItemToClick.setSelected(true);
            menuItemToClick.getAction().actionPerformed(new ActionEvent(this, -1, ""));
        }
    }

    private JRadioButtonMenuItem createBoardMenusAndCustomMenus(final Editor editor, List<JMenuItem> menuItemsToClickAfterStartup, Map<String, ButtonGroup> buttonGroupsMap, TargetBoard board, TargetPlatform targetPlatform, TargetPackage targetPackage) throws Exception {
        String selPackage = Preferences.get("target_package");
        String selPlatform = Preferences.get("target_platform");
        String selBoard = Preferences.get("board");
        String boardId = board.getId();
        String packageName = targetPackage.getId();
        String platformName = targetPlatform.getId();
        AbstractAction action = new AbstractAction(board.getName()){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                Base.this.selectBoard((String)this.getValue("b"), editor);
            }
        };
        action.putValue("b", packageName + ":" + platformName + ":" + boardId);
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
        if (selBoard.equals(boardId) && selPackage.equals(packageName) && selPlatform.equals(platformName)) {
            menuItemsToClickAfterStartup.add(item);
        }
        int i = 0;
        PreferencesMap customMenus = targetPlatform.getCustomMenus();
        for (final String menuId : customMenus.keySet()) {
            String title = (String)customMenus.get(menuId);
            JMenu menu = this.getBoardCustomMenu(I18n._(title));
            if (!board.hasMenu(menuId)) continue;
            PreferencesMap boardCustomMenu = board.getMenuLabels(menuId);
            final int currentIndex = i + 1 + 1;
            ++i;
            for (String customMenuOption : boardCustomMenu.keySet()) {
                AbstractAction subAction = new AbstractAction(I18n._((String)boardCustomMenu.get(customMenuOption))){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Preferences.set("target_package", (String)this.getValue("package"));
                        Preferences.set("target_platform", (String)this.getValue("platform"));
                        Preferences.set("board", (String)this.getValue("board"));
                        Preferences.set("custom_" + menuId, (String)this.getValue("board") + "_" + (String)this.getValue("custom_menu_option"));
                        Base.filterVisibilityOfSubsequentBoardMenus((String)this.getValue("board"), currentIndex);
                        Base.this.onBoardOrPortChange();
                        Sketch.buildSettingChanged();
                        Base.this.rebuildImportMenu(Editor.importMenu, editor);
                        Base.this.rebuildExamplesMenu(Editor.examplesMenu);
                    }
                };
                subAction.putValue("board", boardId);
                subAction.putValue("custom_menu_option", customMenuOption);
                subAction.putValue("package", packageName);
                subAction.putValue("platform", platformName);
                if (!buttonGroupsMap.containsKey(menuId)) {
                    buttonGroupsMap.put(menuId, new ButtonGroup());
                }
                JRadioButtonMenuItem subItem = new JRadioButtonMenuItem(subAction);
                menu.add(subItem);
                buttonGroupsMap.get(menuId).add(subItem);
                String selectedCustomMenuEntry = Preferences.get("custom_" + menuId);
                if (!selBoard.equals(boardId) || !(boardId + "_" + customMenuOption).equals(selectedCustomMenuEntry)) continue;
                menuItemsToClickAfterStartup.add(subItem);
            }
        }
        return item;
    }

    private static void filterVisibilityOfSubsequentBoardMenus(String boardID, int fromIndex) {
        for (int i = fromIndex; i < Editor.boardsMenus.size(); ++i) {
            JMenuItem visibleSelectedOrFirstMenuItem;
            JMenu menu = Editor.boardsMenus.get(i);
            for (int m = 0; m < menu.getItemCount(); ++m) {
                JMenuItem menuItem = menu.getItem(m);
                menuItem.setVisible(menuItem.getAction().getValue("board").equals(boardID));
            }
            menu.setVisible(Base.ifThereAreVisibleItemsOn(menu));
            if (!menu.isVisible() || (visibleSelectedOrFirstMenuItem = Base.selectVisibleSelectedOrFirstMenuItem(menu)).isSelected()) continue;
            visibleSelectedOrFirstMenuItem.setSelected(true);
            visibleSelectedOrFirstMenuItem.getAction().actionPerformed(null);
        }
    }

    private static boolean ifThereAreVisibleItemsOn(JMenu menu) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            if (!menu.getItem(i).isVisible()) continue;
            return true;
        }
        return false;
    }

    private JMenu makeBoardCustomMenu(JMenu toolsMenu, String label) {
        JMenu menu = new JMenu(label);
        Editor.boardsMenus.add(menu);
        toolsMenu.add(menu);
        return menu;
    }

    private JMenu getBoardCustomMenu() throws Exception {
        return this.getBoardCustomMenu(I18n._("Board"));
    }

    private JMenu getBoardCustomMenu(String label) throws Exception {
        for (JMenu menu : Editor.boardsMenus) {
            if (!label.equals(menu.getText())) continue;
            return menu;
        }
        throw new Exception("Custom menu not found!");
    }

    private static JMenuItem selectVisibleSelectedOrFirstMenuItem(JMenu menu) {
        JMenuItem firstVisible = null;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null || !item.isVisible()) continue;
            if (item.isSelected()) {
                return item;
            }
            if (firstVisible != null) continue;
            firstVisible = item;
        }
        if (firstVisible != null) {
            return firstVisible;
        }
        throw new IllegalStateException("Menu has no enabled items");
    }

    private static JMenuItem selectFirstEnabledMenuItem(JMenu menu) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null || !item.isEnabled()) continue;
            return item;
        }
        throw new IllegalStateException("Menu has no enabled items");
    }

    private void selectBoard(String selectBoard, Editor editor) {
        String[] split = selectBoard.split(":");
        Preferences.set("target_package", split[0]);
        Preferences.set("target_platform", split[1]);
        Preferences.set("board", split[2]);
        Base.filterVisibilityOfSubsequentBoardMenus(split[2], 1);
        this.onBoardOrPortChange();
        Sketch.buildSettingChanged();
        this.rebuildImportMenu(Editor.importMenu, editor);
        this.rebuildExamplesMenu(Editor.examplesMenu);
    }

    public void rebuildProgrammerMenu(JMenu menu) {
        menu.removeAll();
        ButtonGroup group = new ButtonGroup();
        for (TargetPackage targetPackage : packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.platforms()) {
                for (String programmer : targetPlatform.getProgrammers().keySet()) {
                    String id = targetPackage.getId() + ":" + programmer;
                    AbstractAction action = new AbstractAction((String)targetPlatform.getProgrammer(programmer).get("name")){

                        @Override
                        public void actionPerformed(ActionEvent actionevent) {
                            Preferences.set("programmer", "" + this.getValue("id"));
                        }
                    };
                    action.putValue("id", id);
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
                    if (Preferences.get("programmer").equals(id)) {
                        item.setSelected(true);
                    }
                    group.add(item);
                    menu.add(item);
                }
            }
        }
    }

    protected boolean addSketches(JMenu menu, File folder, boolean replaceExisting) throws IOException {
        if (folder == null) {
            return false;
        }
        if (!folder.isDirectory()) {
            return false;
        }
        String[] list = folder.list();
        if (list == null) {
            return false;
        }
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        boolean ifound = false;
        for (String name : list) {
            File subfolder;
            if (name.charAt(0) == '.' || name.equals("CVS") || !(subfolder = new File(folder, name)).isDirectory() || !this.addSketchesSubmenu(menu, name, subfolder, replaceExisting)) continue;
            ifound = true;
        }
        return ifound;
    }

    private boolean addSketchesSubmenu(JMenu menu, Library lib, boolean replaceExisting) throws IOException {
        return this.addSketchesSubmenu(menu, lib.getName(), lib.getFolder(), replaceExisting);
    }

    private boolean addSketchesSubmenu(JMenu menu, String name, File folder, final boolean replaceExisting) throws IOException {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = e.getActionCommand();
                if (new File(path).exists()) {
                    boolean replace = replaceExisting;
                    if ((e.getModifiers() & 1) != 0) {
                        boolean bl = replace = !replace;
                    }
                    if (replace) {
                        Base.this.handleOpenReplace(path);
                    } else {
                        try {
                            Base.this.handleOpen(path);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    Base.showWarning(I18n._("Sketch Does Not Exist"), I18n._("The selected sketch no longer exists.\nYou may need to restart Arduino to update\nthe sketchbook menu."), null);
                }
            }
        };
        File entry = new File(folder, name + ".ino");
        if (!entry.exists() && new File(folder, name + ".pde").exists()) {
            entry = new File(folder, name + ".pde");
        }
        if (entry.exists()) {
            if (!Sketch.isSanitaryName(name)) {
                if (!this.builtOnce) {
                    String complaining = I18n.format(I18n._("The sketch \"{0}\" cannot be used.\nSketch names must contain only basic letters and numbers\n(ASCII-only with no spaces, and it cannot start with a number).\nTo get rid of this message, remove the sketch from\n{1}"), name, entry.getAbsolutePath());
                    Base.showMessage(I18n._("Ignoring sketch with bad name"), complaining);
                }
                return false;
            }
            JMenuItem item = new JMenuItem(name);
            item.addActionListener(listener);
            item.setActionCommand(entry.getAbsolutePath());
            menu.add(item);
            return true;
        }
        if (folder.getName().equals("examples")) {
            return this.addSketches(menu, folder, replaceExisting);
        }
        JMenu submenu = new JMenu(name);
        boolean found = this.addSketches(submenu, folder, replaceExisting);
        if (found) {
            menu.add(submenu);
        }
        return found;
    }

    protected void addLibraries(JMenu menu, LibraryList libs) throws IOException {
        LibraryList list = new LibraryList(libs);
        list.sort();
        for (Library lib : list) {
            AbstractAction action = new AbstractAction(lib.getName()){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Library l = (Library)this.getValue("library");
                    try {
                        Base.this.activeEditor.getSketch().importLibrary(l);
                    }
                    catch (IOException e) {
                        Base.showWarning(I18n._("Error"), I18n.format("Unable to list header files in {0}", l.getSrcFolder()), e);
                    }
                }
            };
            action.putValue("library", lib);
            JMenuItem item = new JMenuItem(action);
            item.putClientProperty("library", lib);
            menu.add(item);
        }
    }

    public static String[] headerListFromIncludePath(File path) throws IOException {
        String[] list = path.list(new OnlyFilesWithExtension(".h"));
        if (list == null) {
            throw new IOException();
        }
        return list;
    }

    protected void loadHardware(File folder) {
        if (!folder.isDirectory()) {
            return;
        }
        String[] list = folder.list(new OnlyDirs());
        if (list == null) {
            return;
        }
        Arrays.sort(list, String.CASE_INSENSITIVE_ORDER);
        for (String target : list) {
            if (target.equals("tools")) continue;
            File subfolder = new File(folder, target);
            try {
                packages.put(target, new TargetPackage(target, subfolder));
            }
            catch (TargetPlatformException e) {
                System.out.println("WARNING: Error loading hardware folder " + target);
                System.out.println("  " + e.getMessage());
            }
        }
    }

    public void handleAbout() {
        final Image image = Base.getLibImage("about.jpg", this.activeEditor);
        final Window window = new Window(this.activeEditor){

            @Override
            public void paint(Graphics g) {
                g.drawImage(image, 0, 0, null);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                g.setFont(new Font("SansSerif", 0, 11));
                g.setColor(Color.white);
                g.drawString(VERSION_NAME, 50, 30);
            }
        };
        window.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                window.dispose();
            }
        });
        int w = image.getWidth(this.activeEditor);
        int h = image.getHeight(this.activeEditor);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        window.setBounds((screen.width - w) / 2, (screen.height - h) / 2, w, h);
        window.setVisible(true);
    }

    public void handlePrefs() {
        if (this.preferencesFrame == null) {
            this.preferencesFrame = new Preferences();
        }
        this.preferencesFrame.showFrame(this.activeEditor);
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static String getPlatformName() {
        String osname = System.getProperty("os.name");
        if (osname.indexOf("Mac") != -1) {
            return "macosx";
        }
        if (osname.indexOf("Windows") != -1) {
            return "windows";
        }
        if (osname.equals("Linux")) {
            return "linux";
        }
        return "other";
    }

    public static String getPlatformName(int which) {
        return platformNames.get(which);
    }

    public static int getPlatformIndex(String what) {
        Integer entry = platformIndices.get(what);
        return entry == null ? -1 : entry;
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").indexOf("Mac") != -1;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").indexOf("Linux") != -1;
    }

    public static File getSettingsFolder() {
        if (portableFolder != null) {
            return portableFolder;
        }
        File settingsFolder = null;
        String preferencesPath = Preferences.get("settings.path");
        if (preferencesPath != null) {
            settingsFolder = new File(preferencesPath);
        } else {
            try {
                settingsFolder = platform.getSettingsFolder();
            }
            catch (Exception e) {
                Base.showError(I18n._("Problem getting data folder"), I18n._("Error getting the Arduino data folder."), e);
            }
        }
        if (!settingsFolder.exists() && !settingsFolder.mkdirs()) {
            Base.showError(I18n._("Settings issues"), I18n._("Arduino cannot run because it could not\ncreate a folder to store your settings."), null);
        }
        return settingsFolder;
    }

    public static File getSettingsFile(String filename) {
        return new File(Base.getSettingsFolder(), filename);
    }

    public static File getBuildFolder() {
        if (buildFolder == null) {
            String buildPath = Preferences.get("build.path");
            if (buildPath != null) {
                buildFolder = new File(buildPath);
            } else {
                buildFolder = Base.createTempFolder("build");
                buildFolder.deleteOnExit();
            }
        }
        return buildFolder;
    }

    public static File createTempFolder(String name) {
        try {
            File folder = File.createTempFile(name, null);
            folder.delete();
            folder.mkdirs();
            return folder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LibraryList getLibraries() {
        return libraries;
    }

    public static String getExamplesPath() {
        return examplesFolder.getAbsolutePath();
    }

    public static List<File> getLibrariesPath() {
        return librariesFolders;
    }

    public static File getToolsFolder() {
        return toolsFolder;
    }

    public static String getToolsPath() {
        return toolsFolder.getAbsolutePath();
    }

    public static File getHardwareFolder() {
        return Base.getContentFile("hardware");
    }

    public static File getCoreLibraries(String path) {
        return Base.getContentFile(path);
    }

    public static String getHardwarePath() {
        return Base.getHardwareFolder().getAbsolutePath();
    }

    public static String getAvrBasePath() {
        String path = Base.getHardwarePath() + File.separator + "tools" + File.separator + "avr" + File.separator + "bin" + File.separator;
        if (Base.isLinux() && !new File(path).exists()) {
            return "";
        }
        return path;
    }

    public static TargetPlatform getTargetPlatform() {
        String packageName = Preferences.get("target_package");
        String platformName = Preferences.get("target_platform");
        return Base.getTargetPlatform(packageName, platformName);
    }

    public static TargetPlatform getTargetPlatform(String packageName, String platformName) {
        TargetPackage p = packages.get(packageName);
        if (p == null) {
            return null;
        }
        return p.get(platformName);
    }

    public static TargetPlatform getCurrentTargetPlatformFromPackage(String pack) {
        return Base.getTargetPlatform(pack, Preferences.get("target_platform"));
    }

    public static PreferencesMap getBoardPreferences() {
        TargetBoard board = Base.getTargetBoard();
        PreferencesMap prefs = new PreferencesMap(board.getPreferences());
        for (String menuId : board.getMenuIds()) {
            String entry = Preferences.get("custom_" + menuId);
            if (!board.hasMenu(menuId) || entry == null || !entry.startsWith(board.getId())) continue;
            String selectionId = entry.substring(entry.indexOf("_") + 1);
            prefs.putAll(board.getMenuPreferences(menuId, selectionId));
            prefs.put("name", (String)prefs.get("name") + ", " + board.getMenuLabel(menuId, selectionId));
        }
        return prefs;
    }

    public static TargetBoard getTargetBoard() {
        String boardId = Preferences.get("board");
        return Base.getTargetPlatform().getBoard(boardId);
    }

    public static File getPortableFolder() {
        return portableFolder;
    }

    public static String getPortableSketchbookFolder() {
        return portableSketchbookFolder;
    }

    public static File getSketchbookFolder() {
        if (portableFolder != null) {
            return new File(portableFolder, Preferences.get("sketchbook.path"));
        }
        return new File(Preferences.get("sketchbook.path"));
    }

    public static File getSketchbookLibrariesFolder() {
        File libdir = new File(Base.getSketchbookFolder(), "libraries");
        if (!libdir.exists()) {
            try {
                libdir.mkdirs();
                File readme = new File(libdir, "readme.txt");
                FileWriter freadme = new FileWriter(readme);
                freadme.write(I18n._("For information on installing libraries, see: http://arduino.cc/en/Guide/Libraries\n"));
                freadme.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return libdir;
    }

    public static String getSketchbookLibrariesPath() {
        return Base.getSketchbookLibrariesFolder().getAbsolutePath();
    }

    public static File getSketchbookHardwareFolder() {
        return new File(Base.getSketchbookFolder(), "hardware");
    }

    protected File getDefaultSketchbookFolder() {
        if (portableFolder != null) {
            return new File(portableFolder, portableSketchbookFolder);
        }
        File sketchbookFolder = null;
        try {
            sketchbookFolder = platform.getDefaultSketchbookFolder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sketchbookFolder == null) {
            sketchbookFolder = Base.promptSketchbookLocation();
        }
        boolean result = true;
        if (!sketchbookFolder.exists()) {
            result = sketchbookFolder.mkdirs();
        }
        if (!result) {
            Base.showError(I18n._("You forgot your sketchbook"), I18n._("Arduino cannot run because it could not\ncreate a folder to store your sketchbook."), null);
        }
        return sketchbookFolder;
    }

    protected static File promptSketchbookLocation() {
        File folder = null;
        folder = new File(System.getProperty("user.home"), portableSketchbookFolder);
        if (!folder.exists()) {
            folder.mkdirs();
            return folder;
        }
        String prompt = I18n._("Select (or create new) folder for sketches...");
        folder = Base.selectFolder(prompt, null, null);
        if (folder == null) {
            System.exit(0);
        }
        return folder;
    }

    public static void openURL(String url) {
        try {
            platform.openURL(url);
        }
        catch (Exception e) {
            Base.showWarning(I18n._("Problem Opening URL"), I18n.format(I18n._("Could not open the URL\n{0}"), url), e);
        }
    }

    protected static boolean openFolderAvailable() {
        return platform.openFolderAvailable();
    }

    public static void openFolder(File file) {
        try {
            platform.openFolder(file);
        }
        catch (Exception e) {
            Base.showWarning(I18n._("Problem Opening Folder"), I18n.format(I18n._("Could not open the folder\n{0}"), file.getAbsolutePath()), e);
        }
    }

    public static File selectFolder(String prompt, File folder, Frame frame) {
        if (Base.isMacOS()) {
            if (frame == null) {
                frame = new Frame();
            }
            FileDialog fd = new FileDialog(frame, prompt, 0);
            if (folder != null) {
                fd.setDirectory(folder.getParent());
            }
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fd.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            if (fd.getFile() == null) {
                return null;
            }
            return new File(fd.getDirectory(), fd.getFile());
        }
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(prompt);
        if (folder != null) {
            fc.setSelectedFile(folder);
        }
        fc.setFileSelectionMode(1);
        int returned = fc.showOpenDialog(new JDialog());
        if (returned == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static void setIcon(Frame frame) {
        if (Base.isMacOS()) {
            return;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(PApplet.ICON_IMAGE);
        frame.setIconImage(image);
    }

    public static void registerWindowCloseKeys(JRootPane root, ActionListener disposer) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        root.registerKeyboardAction(disposer, stroke, 2);
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        stroke = KeyStroke.getKeyStroke(87, modifiers);
        root.registerKeyboardAction(disposer, stroke, 2);
    }

    public static void showReference(String filename) {
        File referenceFolder = Base.getContentFile("reference");
        File referenceFile = new File(referenceFolder, filename);
        Base.openURL(referenceFile.getAbsolutePath());
    }

    public static void showGettingStarted() {
        if (Base.isMacOS()) {
            Base.showReference(I18n._("Guide_MacOSX.html"));
        } else if (Base.isWindows()) {
            Base.showReference(I18n._("Guide_Windows.html"));
        } else {
            Base.openURL(I18n._("http://www.arduino.cc/playground/Learning/Linux"));
        }
    }

    public static void showReference() {
        Base.showReference(I18n._("index.html"));
    }

    public static void showEnvironment() {
        Base.showReference(I18n._("Guide_Environment.html"));
    }

    public static void showPlatforms() {
        Base.showReference(I18n._("environment") + File.separator + I18n._("platforms.html"));
    }

    public static void showTroubleshooting() {
        Base.showReference(I18n._("Guide_Troubleshooting.html"));
    }

    public static void showFAQ() {
        Base.showReference(I18n._("FAQ.html"));
    }

    public static void showMessage(String title, String message) {
        if (title == null) {
            title = I18n._("Message");
        }
        if (commandLine) {
            System.out.println(title + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 1);
        }
    }

    public static void showWarning(String title, String message, Exception e) {
        if (title == null) {
            title = I18n._("Warning");
        }
        if (commandLine) {
            System.out.println(title + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 2);
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void showError(String title, String message, Throwable e) {
        if (title == null) {
            title = I18n._("Error");
        }
        if (commandLine) {
            System.err.println(title + ": " + message);
        } else {
            JOptionPane.showMessageDialog(new Frame(), message, title, 0);
        }
        if (e != null) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    public static int showYesNoCancelQuestion(Editor editor, String title, String primary, String secondary) {
        if (!Base.isMacOS()) {
            int result = JOptionPane.showConfirmDialog(null, primary + "\n" + secondary, title, 1, 3);
            return result;
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost.", 3);
        Object[] options = new String[]{"Save", "Cancel", "Don't Save"};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        pane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
        JDialog dialog = pane.createDialog(editor, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return 0;
        }
        if (result == options[1]) {
            return 2;
        }
        if (result == options[2]) {
            return 1;
        }
        return -1;
    }

    public static int showYesNoQuestion(Frame editor, String title, String primary, String secondary) {
        if (!Base.isMacOS()) {
            return JOptionPane.showConfirmDialog(editor, "<html><body><b>" + primary + "</b><br>" + secondary, title, 0, 3);
        }
        JOptionPane pane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>" + primary + "</b><p>" + secondary + "</p>", 3);
        Object[] options = new String[]{"Yes", "No"};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        JDialog dialog = pane.createDialog(editor, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return 0;
        }
        if (result == options[1]) {
            return 1;
        }
        return -1;
    }

    public static File getContentFile(String name) {
        String javaroot;
        String path = System.getProperty("user.dir");
        if (Base.isMacOS() && (javaroot = System.getProperty("javaroot")) != null) {
            path = javaroot;
        }
        File working = new File(path);
        return new File(working, name);
    }

    public static Image getThemeImage(String name, Component who) {
        return Base.getLibImage("theme/" + name, who);
    }

    public static Image getLibImage(String name, Component who) {
        Image image = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        File imageLocation = new File(Base.getContentFile("lib"), name);
        image = tk.getImage(imageLocation.getAbsolutePath());
        MediaTracker tracker = new MediaTracker(who);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image;
    }

    public static InputStream getLibStream(String filename) throws IOException {
        return new FileInputStream(new File(Base.getContentFile("lib"), filename));
    }

    public static int countLines(String what) {
        int count = 1;
        for (char c : what.toCharArray()) {
            if (c != '\n') continue;
            ++count;
        }
        return count;
    }

    public static byte[] loadBytesRaw(File file) throws IOException {
        int bytesRead;
        int size = (int)file.length();
        FileInputStream input = new FileInputStream(file);
        byte[] buffer = new byte[size];
        int offset = 0;
        while ((bytesRead = input.read(buffer, offset, size - offset)) != -1) {
            offset += bytesRead;
            if (bytesRead != 0) continue;
        }
        input.close();
        input = null;
        return buffer;
    }

    public static HashMap<String, String> readSettings(File inputFile) {
        HashMap<String, String> outgoing = new HashMap<String, String>();
        if (!inputFile.exists()) {
            return outgoing;
        }
        String[] lines = PApplet.loadStrings((File)inputFile);
        for (int i = 0; i < lines.length; ++i) {
            String line;
            int hash = lines[i].indexOf(35);
            String string = line = hash == -1 ? lines[i].trim() : lines[i].substring(0, hash).trim();
            if (line.length() == 0) continue;
            int equals = line.indexOf(61);
            if (equals == -1) {
                System.err.println("ignoring illegal line in " + inputFile);
                System.err.println("  " + line);
                continue;
            }
            String attr = line.substring(0, equals).trim();
            String valu = line.substring(equals + 1).trim();
            outgoing.put(attr, valu);
        }
        return outgoing;
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        int bytesRead;
        BufferedInputStream from = new BufferedInputStream(new FileInputStream(sourceFile));
        BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(targetFile));
        byte[] buffer = new byte[16384];
        while ((bytesRead = ((InputStream)from).read(buffer)) != -1) {
            ((OutputStream)to).write(buffer, 0, bytesRead);
        }
        ((OutputStream)to).flush();
        ((InputStream)from).close();
        from = null;
        ((OutputStream)to).close();
        to = null;
        targetFile.setLastModified(sourceFile.lastModified());
    }

    public static String loadFile(File file) throws IOException {
        String[] contents = PApplet.loadStrings((File)file);
        if (contents == null) {
            return null;
        }
        return PApplet.join((String[])contents, (String)"\n");
    }

    public static void saveFile(String str, File file) throws IOException {
        boolean result;
        File temp = File.createTempFile(file.getName(), null, file.getParentFile());
        PApplet.saveStrings((File)temp, (String[])new String[]{str});
        if (file.exists() && !(result = file.delete())) {
            throw new IOException(I18n.format(I18n._("Could not remove old version of {0}"), file.getAbsolutePath()));
        }
        result = temp.renameTo(file);
        if (!result) {
            throw new IOException(I18n.format(I18n._("Could not replace {0}"), file.getAbsolutePath()));
        }
    }

    public static void copyDir(File sourceDir, File targetDir) throws IOException {
        targetDir.mkdirs();
        String[] files = sourceDir.list();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].charAt(0) == '.') continue;
            File source = new File(sourceDir, files[i]);
            File target = new File(targetDir, files[i]);
            if (source.isDirectory()) {
                Base.copyDir(source, target);
                target.setLastModified(source.lastModified());
                continue;
            }
            Base.copyFile(source, target);
        }
    }

    public static void removeDir(File dir) {
        if (dir.exists()) {
            Base.removeDescendants(dir);
            if (!dir.delete()) {
                System.err.println(I18n.format(I18n._("Could not delete {0}"), dir));
            }
        }
    }

    public static void removeDescendants(File dir) {
        if (!dir.exists()) {
            return;
        }
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(".") || files[i].equals("..")) continue;
            File dead = new File(dir, files[i]);
            if (!dead.isDirectory()) {
                if (Preferences.getBoolean("compiler.save_build_files") || dead.delete()) continue;
                System.err.println(I18n.format(I18n._("Could not delete {0}"), dead));
                continue;
            }
            Base.removeDir(dead);
        }
    }

    public static int calcFolderSize(File folder) {
        int size = 0;
        String[] files = folder.list();
        if (files == null) {
            return -1;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equals(".") || files[i].equals("..") || files[i].equals(".DS_Store")) continue;
            File fella = new File(folder, files[i]);
            if (fella.isDirectory()) {
                size += Base.calcFolderSize(fella);
                continue;
            }
            size += (int)fella.length();
        }
        return size;
    }

    public static String[] listFiles(String path, boolean relative) {
        return Base.listFiles(new File(path), relative);
    }

    public static String[] listFiles(File folder, boolean relative) {
        String path = folder.getAbsolutePath();
        Vector<String> vector = new Vector<String>();
        Base.listFiles(relative ? path + File.separator : "", path, vector);
        Object[] outgoing = new String[vector.size()];
        vector.copyInto(outgoing);
        return outgoing;
    }

    protected static void listFiles(String basePath, String path, Vector<String> vector) {
        File folder = new File(path);
        String[] list = folder.list();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i].charAt(0) == '.') continue;
            File file = new File(path, list[i]);
            String newPath = file.getAbsolutePath();
            if (newPath.startsWith(basePath)) {
                newPath = newPath.substring(basePath.length());
            }
            vector.add(newPath);
            if (!file.isDirectory()) continue;
            Base.listFiles(basePath, newPath, vector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAddLibrary(Editor editor) {
        File destinationFolder;
        File tmpFolder;
        File sourceFile;
        block14: {
            block13: {
                block12: {
                    JFileChooser fileChooser = new JFileChooser(System.getProperty("user.home"));
                    fileChooser.setDialogTitle(I18n._("Select a zip file or a folder containing the library you'd like to add"));
                    fileChooser.setFileSelectionMode(2);
                    fileChooser.setFileFilter(new FileNameExtensionFilter(I18n._("ZIP files or folders"), "zip"));
                    Dimension preferredSize = fileChooser.getPreferredSize();
                    fileChooser.setPreferredSize(new Dimension(preferredSize.width + 200, preferredSize.height + 200));
                    int returnVal = fileChooser.showOpenDialog(editor);
                    if (returnVal != 0) {
                        return;
                    }
                    sourceFile = fileChooser.getSelectedFile();
                    tmpFolder = null;
                    try {
                        if (sourceFile.isDirectory()) break block12;
                        try {
                            tmpFolder = FileUtils.createTempFolder();
                            ZipDeflater zipDeflater = new ZipDeflater(sourceFile, tmpFolder);
                            zipDeflater.deflate();
                            File[] foldersInTmpFolder = tmpFolder.listFiles(new OnlyDirs());
                            if (foldersInTmpFolder.length != 1) {
                                throw new IOException(I18n._("Zip doesn't contain a library"));
                            }
                            sourceFile = foldersInTmpFolder[0];
                        }
                        catch (IOException e) {
                            editor.statusError(e);
                            FileUtils.recursiveDelete(tmpFolder);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.recursiveDelete(tmpFolder);
                        throw throwable;
                    }
                }
                File libFolder = sourceFile;
                String libName = libFolder.getName();
                if (Sketch.isSanitaryName(libName)) break block13;
                String mess = I18n.format(I18n._("The library \"{0}\" cannot be used.\nLibrary names must contain only basic letters and numbers.\n(ASCII only and no spaces, and it cannot start with a number)"), libName);
                editor.statusError(mess);
                FileUtils.recursiveDelete(tmpFolder);
                return;
            }
            destinationFolder = new File(Base.getSketchbookLibrariesFolder(), sourceFile.getName());
            if (destinationFolder.mkdir()) break block14;
            editor.statusError(I18n.format(I18n._("A library named {0} already exists"), sourceFile.getName()));
            FileUtils.recursiveDelete(tmpFolder);
            return;
        }
        try {
            FileUtils.copy(sourceFile, destinationFolder);
        }
        catch (IOException e) {
            editor.statusError(e);
            FileUtils.recursiveDelete(tmpFolder);
            return;
        }
        editor.statusNotice(I18n._("Library added to your libraries. Check \"Import library\" menu"));
        FileUtils.recursiveDelete(tmpFolder);
    }

    public static String getVersionName() {
        return VERSION_NAME;
    }

    static {
        platformNames.put(1, "windows");
        platformNames.put(2, "macosx");
        platformNames.put(3, "linux");
        platformIndices = new HashMap();
        platformIndices.put("windows", 1);
        platformIndices.put("macosx", 2);
        platformIndices.put("linux", 3);
        portableFolder = null;
    }
}

