/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import processing.app.UpdateProgressDialog;
import processing.app.UpdateUtility;

public class UpdateThread
extends Thread {
    private final UpdateProgressDialog dialog;
    private int updateStage;
    private Boolean isSuccess = false;
    private Boolean cancelRequest = false;
    private Exception exception;
    private Path current;
    private String currentName;
    private String tempDirectory;
    private String tempParentdirectory;
    private String backupDirectory;
    private LocalDateTime localTime;
    private HashMap<String, String> updateFileMap;

    public int getUpdateStage() {
        return this.updateStage;
    }

    public Boolean getSuccess() {
        return this.isSuccess;
    }

    public Boolean getCancelRequest() {
        return this.cancelRequest;
    }

    public Exception getException() {
        return this.exception;
    }

    public UpdateThread(UpdateProgressDialog dialog) {
        this.dialog = dialog;
        this.updateStage = 0;
        this.isSuccess = false;
        this.cancelRequest = false;
    }

    public void SetCancel() {
        this.cancelRequest = true;
    }

    @Override
    public void run() {
        try {
            this.updateStage = 0;
            this.preparationUpdate();
            if (!this.cancelRequest.booleanValue()) {
                this.updateStage = 1;
                this.confirmUpdateInfo();
            }
            if (!this.cancelRequest.booleanValue()) {
                this.updateStage = 2;
                this.downloadUpdateFile();
                UpdateUtility.downloadUpdateBat(Paths.get(this.tempParentdirectory, "update.bat").toString());
            }
            if (!this.cancelRequest.booleanValue()) {
                this.updateStage = 3;
                this.backupFile();
                this.isSuccess = true;
            }
            if (!this.cancelRequest.booleanValue()) {
                this.updateStage = 4;
                ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", "start", Paths.get(this.tempParentdirectory, "update.bat").toString(), ManagementFactory.getRuntimeMXBean().getName().split("@")[0], this.tempDirectory, this.current.toString(), this.backupDirectory, this.tempParentdirectory);
                builder.start();
            } else {
                this.updateStage = 5;
                this.delete(new File(this.tempParentdirectory));
            }
        }
        catch (IOException ex) {
            this.exception = ex;
            this.delete(new File(this.tempParentdirectory));
        }
        finally {
            this.dialog.updateCallback();
        }
    }

    private void preparationUpdate() {
        this.current = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.currentName = new File(this.current.toString()).getName();
        this.tempParentdirectory = Paths.get(System.getProperty("java.io.tmpdir"), "Renesas").toString();
        this.tempDirectory = Paths.get(System.getProperty("java.io.tmpdir"), "Renesas", this.currentName).toString();
        this.backupDirectory = Paths.get(System.getProperty("java.io.tmpdir"), "Renesas", this.currentName + "_Backup").toString();
        this.delete(new File(this.tempParentdirectory));
    }

    private void delete(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files;
                for (File value : files = file.listFiles()) {
                    this.delete(value);
                }
                file.delete();
            }
        }
    }

    private void confirmUpdateInfo() throws FileNotFoundException, IOException {
        this.localTime = UpdateUtility.getVersionInfo("1.0.0");
        this.updateFileMap = UpdateUtility.getUpdateFileInfo(this.localTime);
    }

    private void downloadUpdateFile() throws IOException {
        for (Map.Entry<String, String> map : this.updateFileMap.entrySet()) {
            File download = Paths.get(this.tempDirectory, map.getKey()).toFile();
            if (map.getValue().equals("1")) {
                download.mkdirs();
            } else {
                download.getParentFile().mkdirs();
                UpdateUtility.downloadFile(download.getPath(), map.getKey());
            }
            if (!this.cancelRequest.booleanValue()) continue;
            break;
        }
    }

    private void backupFile() throws IOException {
        for (Map.Entry<String, String> map : this.updateFileMap.entrySet()) {
            File backupSource = Paths.get(this.current.toString(), map.getKey()).toFile();
            if (backupSource.exists()) {
                File backupDestination = Paths.get(this.backupDirectory, map.getKey()).toFile();
                if (!backupDestination.getParentFile().exists()) {
                    backupDestination.getParentFile().mkdirs();
                }
                if (backupSource.isFile()) {
                    try (FileChannel input = new FileInputStream(backupSource.getPath()).getChannel();
                         FileChannel output = new FileOutputStream(backupDestination.getPath()).getChannel();){
                        input.transferTo(0L, input.size(), output);
                        output.close();
                        input.close();
                    }
                }
            }
            if (!this.cancelRequest.booleanValue()) continue;
            break;
        }
    }
}

