/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Frame;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import processing.app.I18n;
import processing.app.UpdateProgressDialog;
import processing.app.UpdateThread;
import processing.app.UpdateUtility;

public class UpdateManager {
    private JFrame parent;

    public UpdateManager(JFrame frame) {
        this.parent = frame;
    }

    public Boolean checkUpdate(Boolean isDisplay) {
        Boolean result;
        block3: {
            result = false;
            try {
                result = UpdateUtility.checkUpdate();
                if (!result.booleanValue() && isDisplay.booleanValue()) {
                    JOptionPane.showMessageDialog(this.parent, I18n._("Your IDE for GR is the latest version."), "M002003", 1);
                }
            }
            catch (IOException ex) {
                if (!isDisplay.booleanValue()) break block3;
                JOptionPane.showMessageDialog(this.parent, I18n._("Connection failed. Please update in an environment where communication is good.\nPlease note that you can not update from proxy-configured PC.") + UpdateUtility.getSeparator() + ex.getMessage(), "E002001", 0);
            }
        }
        return result;
    }

    public int confirmUpdate() {
        String message = I18n._("There is a new version of IDE for GR.\nWhen you start updating, unsaved sketches are discarded.\nAre you sure you want to start the update?");
        Object[] options = new Object[]{"Yes", "No"};
        return JOptionPane.showOptionDialog(this.parent, message, I18n._("Check Update"), 0, 3, null, options, options[0]);
    }

    public void update() {
        UpdateProgressDialog dialog = new UpdateProgressDialog((Frame)this.parent, true);
        dialog.setUpdateThread(new UpdateThread(dialog));
        dialog.setLocationRelativeTo(this.parent);
        dialog.runUpdate();
        dialog.setVisible(true);
    }
}

