/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import processing.app.HttpConstants;
import processing.app.WebServerWorker;

public class WebServer
implements HttpConstants {
    static Vector threads = new Vector();
    static int timeout = 10000;
    static int workers = 5;

    protected static void log(String s) {
    }

    public static int launch(String zipPath) throws IOException {
        final ZipFile zip = new ZipFile(zipPath);
        final HashMap<String, ZipEntry> entries = new HashMap<String, ZipEntry>();
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            entries.put(entry.getName(), entry);
        }
        for (int i = 0; i < workers; ++i) {
            WebServerWorker w = new WebServerWorker(zip, entries);
            Thread t = new Thread((Runnable)w, "Web Server Worker #" + i);
            t.start();
            threads.addElement(w);
        }
        int port = 8080;
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    ServerSocket ss = new ServerSocket(8080);
                    while (true) {
                        Socket s = ss.accept();
                        WebServerWorker w = null;
                        Vector vector = threads;
                        synchronized (vector) {
                            if (threads.isEmpty()) {
                                WebServerWorker ws = new WebServerWorker(zip, entries);
                                ws.setSocket(s);
                                new Thread((Runnable)ws, "additional worker").start();
                            } else {
                                w = (WebServerWorker)threads.elementAt(0);
                                threads.removeElementAt(0);
                                w.setSocket(s);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        };
        new Thread(r).start();
        return 8080;
    }
}

