/*
 * Decompiled with CFR 0.152.
 */
package processing.app.packages;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import processing.app.helpers.FileUtils;
import processing.app.packages.Library;

public class LibraryList
extends ArrayList<Library> {
    public LibraryList(LibraryList libs) {
        super(libs);
    }

    public LibraryList() {
    }

    public Library getByName(String name) {
        for (Library l : this) {
            if (!l.getName().equals(name)) continue;
            return l;
        }
        return null;
    }

    public void addOrReplace(Library lib) {
        Library l = this.getByName(lib.getName());
        if (l != null) {
            this.remove(l);
        }
        this.add(lib);
    }

    public void addOrReplaceAll(Collection<? extends Library> c) {
        for (Library library : c) {
            this.addOrReplace(library);
        }
    }

    public void sort() {
        Collections.sort(this, Library.CASE_INSENSITIVE_ORDER);
    }

    public Library search(String name, String arch) {
        for (Library lib : this) {
            if (!lib.getName().equals(name) || !lib.supportsArchitecture(arch)) continue;
            return lib;
        }
        return null;
    }

    public LibraryList filterByArchitecture(String reqArch) {
        LibraryList res = new LibraryList();
        for (Library lib : this) {
            if (!lib.supportsArchitecture(reqArch)) continue;
            res.add(lib);
        }
        return res;
    }

    public LibraryList filterLibrariesInSubfolder(File subFolder) {
        LibraryList res = new LibraryList();
        for (Library lib : this) {
            if (!FileUtils.isSubDirectory(subFolder, lib.getFolder())) continue;
            res.add(lib);
        }
        return res;
    }
}

