/*
<html>
<head>
<title>camera</title>
<script type="text/javascript" charset="utf-8">//<![CDATA[
  var imageNr = 0;
  var finished = new Array();

  function createImageLayer() {
    var canvas = document.getElementById('stroke');
    if (canvas.getContext){
      var pos = post("pos/" + (imageNr));
      var s_pos = pos.split(",");
      ChangeTxt(pos);

      var ctx = canvas.getContext('2d');
      ctx.clearRect(0, 0, 320, 240);
      ctx.lineWidth = 2;
      ctx.strokeStyle = "rgb(0, 176, 240)";
      ctx.strokeRect(parseInt(s_pos[0]),parseInt(s_pos[1]),parseInt(s_pos[2]),parseInt(s_pos[3]));
    }

    if (image_on_off.value=='On') {
      var image = new Image();

      image.src = "camera/" + (++imageNr);
      image.style.position = "absolute";
      image.style.zIndex = 0;
      image.onload = imageOnload;
      image.onerror = createImageLayer;

      var webcam = document.getElementById("webcam");
      webcam.insertBefore(image, webcam.firstChild);
    } else {
      while (0 < finished.length) {
        var del = finished.shift();
        del.parentNode.removeChild(del);
      }

      timerID = setTimeout(function(){ createImageLayer() }, document.F1.waittime.value);
    }
  }

  function post(url) {
    http = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject("Microsoft.XMLHTTP");
    if(!http) return false;
    http.open("GET", url, false);
    http.send(null);
    return http.responseText;
  }

  function imageOnload() {
    while (0 < finished.length) {
      var del = finished.shift();
      del.parentNode.removeChild(del);
    }
    finished.push(this);

    timerID = setTimeout(function(){ createImageLayer() }, document.F1.waittime.value);
  }

  function image_toggle(){
    if (image_on_off.value=='On') {
      image_on_off.value='Off';
    } else {
      image_on_off.value='On';
    }
  }

  function HQ_toggle(){
    var ret;
    if (HQ_LQ.value=='HQ') {
      ret = post("quality/25");
      if (parseInt(ret)==25) {
        HQ_LQ.value='LQ';
      }
    } else {
      ret = post("quality/75");
      if (parseInt(ret)==75) {
        HQ_LQ.value='HQ';
      }
    }
  }

  function ChangeTxt(txt) {
    document.getElementById("text").innerHTML=txt;
  }

//]]></script>
<style type="text/css">
  #webcam img{left:0;right:0;max-width:640px;width:100%;height:auto}
  #webcam canvas{left:0;right:0;max-width:640px;width:100%;height:auto}
  </style>
</head>
<body>
  <body onload="createImageLayer();">
  <form action="#" name="F1">
  Wait time <input type="range" name="waittime" value="500" max="1000" step="50"> [ms]  
  <input type="button" ID="image_on_off" onClick="image_toggle()" value="On">  
  <input type="button" ID="HQ_LQ" onClick="HQ_toggle()" value="HQ">  
  <div id="text"></div>
  </form>
  <div id="webcam">
    <canvas id="stroke" width="320" height="240" style="position: absolute; z-index: 1"></canvas>
  </div>
</body>
</html>
*/

static const char index_htm_tbl[] = {
 0x3C,0x68,0x74,0x6D,0x6C,0x3E,0x0D,0x0A,0x3C,0x68,0x65,0x61,0x64,0x3E,0x0D,0x0A
,0x3C,0x74,0x69,0x74,0x6C,0x65,0x3E,0x63,0x61,0x6D,0x65,0x72,0x61,0x3C,0x2F,0x74
,0x69,0x74,0x6C,0x65,0x3E,0x0D,0x0A,0x3C,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74
,0x79,0x70,0x65,0x3D,0x22,0x74,0x65,0x78,0x74,0x2F,0x6A,0x61,0x76,0x61,0x73,0x63
,0x72,0x69,0x70,0x74,0x22,0x20,0x63,0x68,0x61,0x72,0x73,0x65,0x74,0x3D,0x22,0x75
,0x74,0x66,0x2D,0x38,0x22,0x3E,0x2F,0x2F,0x3C,0x21,0x5B,0x43,0x44,0x41,0x54,0x41
,0x5B,0x0D,0x0A,0x20,0x20,0x76,0x61,0x72,0x20,0x69,0x6D,0x61,0x67,0x65,0x4E,0x72
,0x20,0x3D,0x20,0x30,0x3B,0x0D,0x0A,0x20,0x20,0x76,0x61,0x72,0x20,0x66,0x69,0x6E
,0x69,0x73,0x68,0x65,0x64,0x20,0x3D,0x20,0x6E,0x65,0x77,0x20,0x41,0x72,0x72,0x61
,0x79,0x28,0x29,0x3B,0x0D,0x0A,0x0D,0x0A,0x20,0x20,0x66,0x75,0x6E,0x63,0x74,0x69
,0x6F,0x6E,0x20,0x63,0x72,0x65,0x61,0x74,0x65,0x49,0x6D,0x61,0x67,0x65,0x4C,0x61
,0x79,0x65,0x72,0x28,0x29,0x20,0x7B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x76,0x61,0x72
,0x20,0x63,0x61,0x6E,0x76,0x61,0x73,0x20,0x3D,0x20,0x64,0x6F,0x63,0x75,0x6D,0x65
,0x6E,0x74,0x2E,0x67,0x65,0x74,0x45,0x6C,0x65,0x6D,0x65,0x6E,0x74,0x42,0x79,0x49
,0x64,0x28,0x27,0x73,0x74,0x72,0x6F,0x6B,0x65,0x27,0x29,0x3B,0x0D,0x0A,0x20,0x20
,0x20,0x20,0x69,0x66,0x20,0x28,0x63,0x61,0x6E,0x76,0x61,0x73,0x2E,0x67,0x65,0x74
,0x43,0x6F,0x6E,0x74,0x65,0x78,0x74,0x29,0x7B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20
,0x20,0x76,0x61,0x72,0x20,0x70,0x6F,0x73,0x20,0x3D,0x20,0x70,0x6F,0x73,0x74,0x28
,0x22,0x70,0x6F,0x73,0x2F,0x22,0x20,0x2B,0x20,0x28,0x69,0x6D,0x61,0x67,0x65,0x4E
,0x72,0x29,0x29,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x76,0x61,0x72,0x20
,0x73,0x5F,0x70,0x6F,0x73,0x20,0x3D,0x20,0x70,0x6F,0x73,0x2E,0x73,0x70,0x6C,0x69
,0x74,0x28,0x22,0x2C,0x22,0x29,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x43
,0x68,0x61,0x6E,0x67,0x65,0x54,0x78,0x74,0x28,0x70,0x6F,0x73,0x29,0x3B,0x0D,0x0A
,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x76,0x61,0x72,0x20,0x63,0x74,0x78,0x20
,0x3D,0x20,0x63,0x61,0x6E,0x76,0x61,0x73,0x2E,0x67,0x65,0x74,0x43,0x6F,0x6E,0x74
,0x65,0x78,0x74,0x28,0x27,0x32,0x64,0x27,0x29,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20
,0x20,0x20,0x63,0x74,0x78,0x2E,0x63,0x6C,0x65,0x61,0x72,0x52,0x65,0x63,0x74,0x28
,0x30,0x2C,0x20,0x30,0x2C,0x20,0x33,0x32,0x30,0x2C,0x20,0x32,0x34,0x30,0x29,0x3B
,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x63,0x74,0x78,0x2E,0x6C,0x69,0x6E,0x65
,0x57,0x69,0x64,0x74,0x68,0x20,0x3D,0x20,0x32,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20
,0x20,0x20,0x63,0x74,0x78,0x2E,0x73,0x74,0x72,0x6F,0x6B,0x65,0x53,0x74,0x79,0x6C
,0x65,0x20,0x3D,0x20,0x22,0x72,0x67,0x62,0x28,0x30,0x2C,0x20,0x31,0x37,0x36,0x2C
,0x20,0x32,0x34,0x30,0x29,0x22,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x63
,0x74,0x78,0x2E,0x73,0x74,0x72,0x6F,0x6B,0x65,0x52,0x65,0x63,0x74,0x28,0x70,0x61
,0x72,0x73,0x65,0x49,0x6E,0x74,0x28,0x73,0x5F,0x70,0x6F,0x73,0x5B,0x30,0x5D,0x29
,0x2C,0x70,0x61,0x72,0x73,0x65,0x49,0x6E,0x74,0x28,0x73,0x5F,0x70,0x6F,0x73,0x5B
,0x31,0x5D,0x29,0x2C,0x70,0x61,0x72,0x73,0x65,0x49,0x6E,0x74,0x28,0x73,0x5F,0x70
,0x6F,0x73,0x5B,0x32,0x5D,0x29,0x2C,0x70,0x61,0x72,0x73,0x65,0x49,0x6E,0x74,0x28
,0x73,0x5F,0x70,0x6F,0x73,0x5B,0x33,0x5D,0x29,0x29,0x3B,0x0D,0x0A,0x20,0x20,0x20
,0x20,0x7D,0x0D,0x0A,0x0D,0x0A,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x69,0x6D
,0x61,0x67,0x65,0x5F,0x6F,0x6E,0x5F,0x6F,0x66,0x66,0x2E,0x76,0x61,0x6C,0x75,0x65
,0x3D,0x3D,0x27,0x4F,0x6E,0x27,0x29,0x20,0x7B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20
,0x20,0x76,0x61,0x72,0x20,0x69,0x6D,0x61,0x67,0x65,0x20,0x3D,0x20,0x6E,0x65,0x77
,0x20,0x49,0x6D,0x61,0x67,0x65,0x28,0x29,0x3B,0x0D,0x0A,0x0D,0x0A,0x20,0x20,0x20
,0x20,0x20,0x20,0x69,0x6D,0x61,0x67,0x65,0x2E,0x73,0x72,0x63,0x20,0x3D,0x20,0x22
,0x63,0x61,0x6D,0x65,0x72,0x61,0x2F,0x22,0x20,0x2B,0x20,0x28,0x2B,0x2B,0x69,0x6D
,0x61,0x67,0x65,0x4E,0x72,0x29,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x69
,0x6D,0x61,0x67,0x65,0x2E,0x73,0x74,0x79,0x6C,0x65,0x2E,0x70,0x6F,0x73,0x69,0x74
,0x69,0x6F,0x6E,0x20,0x3D,0x20,0x22,0x61,0x62,0x73,0x6F,0x6C,0x75,0x74,0x65,0x22
,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x6D,0x61,0x67,0x65,0x2E,0x73
,0x74,0x79,0x6C,0x65,0x2E,0x7A,0x49,0x6E,0x64,0x65,0x78,0x20,0x3D,0x20,0x30,0x3B
,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x6D,0x61,0x67,0x65,0x2E,0x6F,0x6E
,0x6C,0x6F,0x61,0x64,0x20,0x3D,0x20,0x69,0x6D,0x61,0x67,0x65,0x4F,0x6E,0x6C,0x6F
,0x61,0x64,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x6D,0x61,0x67,0x65
,0x2E,0x6F,0x6E,0x65,0x72,0x72,0x6F,0x72,0x20,0x3D,0x20,0x63,0x72,0x65,0x61,0x74
,0x65,0x49,0x6D,0x61,0x67,0x65,0x4C,0x61,0x79,0x65,0x72,0x3B,0x0D,0x0A,0x0D,0x0A
,0x20,0x20,0x20,0x20,0x20,0x20,0x76,0x61,0x72,0x20,0x77,0x65,0x62,0x63,0x61,0x6D
,0x20,0x3D,0x20,0x64,0x6F,0x63,0x75,0x6D,0x65,0x6E,0x74,0x2E,0x67,0x65,0x74,0x45
,0x6C,0x65,0x6D,0x65,0x6E,0x74,0x42,0x79,0x49,0x64,0x28,0x22,0x77,0x65,0x62,0x63
,0x61,0x6D,0x22,0x29,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x77,0x65,0x62
,0x63,0x61,0x6D,0x2E,0x69,0x6E,0x73,0x65,0x72,0x74,0x42,0x65,0x66,0x6F,0x72,0x65
,0x28,0x69,0x6D,0x61,0x67,0x65,0x2C,0x20,0x77,0x65,0x62,0x63,0x61,0x6D,0x2E,0x66
,0x69,0x72,0x73,0x74,0x43,0x68,0x69,0x6C,0x64,0x29,0x3B,0x0D,0x0A,0x20,0x20,0x20
,0x20,0x7D,0x20,0x65,0x6C,0x73,0x65,0x20,0x7B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20
,0x20,0x77,0x68,0x69,0x6C,0x65,0x20,0x28,0x30,0x20,0x3C,0x20,0x66,0x69,0x6E,0x69
,0x73,0x68,0x65,0x64,0x2E,0x6C,0x65,0x6E,0x67,0x74,0x68,0x29,0x20,0x7B,0x0D,0x0A
,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x76,0x61,0x72,0x20,0x64,0x65,0x6C,0x20
,0x3D,0x20,0x66,0x69,0x6E,0x69,0x73,0x68,0x65,0x64,0x2E,0x73,0x68,0x69,0x66,0x74
,0x28,0x29,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x64,0x65,0x6C
,0x2E,0x70,0x61,0x72,0x65,0x6E,0x74,0x4E,0x6F,0x64,0x65,0x2E,0x72,0x65,0x6D,0x6F
,0x76,0x65,0x43,0x68,0x69,0x6C,0x64,0x28,0x64,0x65,0x6C,0x29,0x3B,0x0D,0x0A,0x20
,0x20,0x20,0x20,0x20,0x20,0x7D,0x0D,0x0A,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20
,0x74,0x69,0x6D,0x65,0x72,0x49,0x44,0x20,0x3D,0x20,0x73,0x65,0x74,0x54,0x69,0x6D
,0x65,0x6F,0x75,0x74,0x28,0x66,0x75,0x6E,0x63,0x74,0x69,0x6F,0x6E,0x28,0x29,0x7B
,0x20,0x63,0x72,0x65,0x61,0x74,0x65,0x49,0x6D,0x61,0x67,0x65,0x4C,0x61,0x79,0x65
,0x72,0x28,0x29,0x20,0x7D,0x2C,0x20,0x64,0x6F,0x63,0x75,0x6D,0x65,0x6E,0x74,0x2E
,0x46,0x31,0x2E,0x77,0x61,0x69,0x74,0x74,0x69,0x6D,0x65,0x2E,0x76,0x61,0x6C,0x75
,0x65,0x29,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x7D,0x0D,0x0A,0x20,0x20,0x7D,0x0D
,0x0A,0x0D,0x0A,0x20,0x20,0x66,0x75,0x6E,0x63,0x74,0x69,0x6F,0x6E,0x20,0x70,0x6F
,0x73,0x74,0x28,0x75,0x72,0x6C,0x29,0x20,0x7B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x68
,0x74,0x74,0x70,0x20,0x3D,0x20,0x28,0x77,0x69,0x6E,0x64,0x6F,0x77,0x2E,0x58,0x4D
,0x4C,0x48,0x74,0x74,0x70,0x52,0x65,0x71,0x75,0x65,0x73,0x74,0x29,0x20,0x3F,0x20
,0x6E,0x65,0x77,0x20,0x58,0x4D,0x4C,0x48,0x74,0x74,0x70,0x52,0x65,0x71,0x75,0x65
,0x73,0x74,0x28,0x29,0x20,0x3A,0x20,0x6E,0x65,0x77,0x20,0x41,0x63,0x74,0x69,0x76
,0x65,0x58,0x4F,0x62,0x6A,0x65,0x63,0x74,0x28,0x22,0x4D,0x69,0x63,0x72,0x6F,0x73
,0x6F,0x66,0x74,0x2E,0x58,0x4D,0x4C,0x48,0x54,0x54,0x50,0x22,0x29,0x3B,0x0D,0x0A
,0x20,0x20,0x20,0x20,0x69,0x66,0x28,0x21,0x68,0x74,0x74,0x70,0x29,0x20,0x72,0x65
,0x74,0x75,0x72,0x6E,0x20,0x66,0x61,0x6C,0x73,0x65,0x3B,0x0D,0x0A,0x20,0x20,0x20
,0x20,0x68,0x74,0x74,0x70,0x2E,0x6F,0x70,0x65,0x6E,0x28,0x22,0x47,0x45,0x54,0x22
,0x2C,0x20,0x75,0x72,0x6C,0x2C,0x20,0x66,0x61,0x6C,0x73,0x65,0x29,0x3B,0x0D,0x0A
,0x20,0x20,0x20,0x20,0x68,0x74,0x74,0x70,0x2E,0x73,0x65,0x6E,0x64,0x28,0x6E,0x75
,0x6C,0x6C,0x29,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6E
,0x20,0x68,0x74,0x74,0x70,0x2E,0x72,0x65,0x73,0x70,0x6F,0x6E,0x73,0x65,0x54,0x65
,0x78,0x74,0x3B,0x0D,0x0A,0x20,0x20,0x7D,0x0D,0x0A,0x0D,0x0A,0x20,0x20,0x66,0x75
,0x6E,0x63,0x74,0x69,0x6F,0x6E,0x20,0x69,0x6D,0x61,0x67,0x65,0x4F,0x6E,0x6C,0x6F
,0x61,0x64,0x28,0x29,0x20,0x7B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x77,0x68,0x69,0x6C
,0x65,0x20,0x28,0x30,0x20,0x3C,0x20,0x66,0x69,0x6E,0x69,0x73,0x68,0x65,0x64,0x2E
,0x6C,0x65,0x6E,0x67,0x74,0x68,0x29,0x20,0x7B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20
,0x20,0x76,0x61,0x72,0x20,0x64,0x65,0x6C,0x20,0x3D,0x20,0x66,0x69,0x6E,0x69,0x73
,0x68,0x65,0x64,0x2E,0x73,0x68,0x69,0x66,0x74,0x28,0x29,0x3B,0x0D,0x0A,0x20,0x20
,0x20,0x20,0x20,0x20,0x64,0x65,0x6C,0x2E,0x70,0x61,0x72,0x65,0x6E,0x74,0x4E,0x6F
,0x64,0x65,0x2E,0x72,0x65,0x6D,0x6F,0x76,0x65,0x43,0x68,0x69,0x6C,0x64,0x28,0x64
,0x65,0x6C,0x29,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x7D,0x0D,0x0A,0x20,0x20,0x20
,0x20,0x66,0x69,0x6E,0x69,0x73,0x68,0x65,0x64,0x2E,0x70,0x75,0x73,0x68,0x28,0x74
,0x68,0x69,0x73,0x29,0x3B,0x0D,0x0A,0x0D,0x0A,0x20,0x20,0x20,0x20,0x74,0x69,0x6D
,0x65,0x72,0x49,0x44,0x20,0x3D,0x20,0x73,0x65,0x74,0x54,0x69,0x6D,0x65,0x6F,0x75
,0x74,0x28,0x66,0x75,0x6E,0x63,0x74,0x69,0x6F,0x6E,0x28,0x29,0x7B,0x20,0x63,0x72
,0x65,0x61,0x74,0x65,0x49,0x6D,0x61,0x67,0x65,0x4C,0x61,0x79,0x65,0x72,0x28,0x29
,0x20,0x7D,0x2C,0x20,0x64,0x6F,0x63,0x75,0x6D,0x65,0x6E,0x74,0x2E,0x46,0x31,0x2E
,0x77,0x61,0x69,0x74,0x74,0x69,0x6D,0x65,0x2E,0x76,0x61,0x6C,0x75,0x65,0x29,0x3B
,0x0D,0x0A,0x20,0x20,0x7D,0x0D,0x0A,0x0D,0x0A,0x20,0x20,0x66,0x75,0x6E,0x63,0x74
,0x69,0x6F,0x6E,0x20,0x69,0x6D,0x61,0x67,0x65,0x5F,0x74,0x6F,0x67,0x67,0x6C,0x65
,0x28,0x29,0x7B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x69,0x6D,0x61
,0x67,0x65,0x5F,0x6F,0x6E,0x5F,0x6F,0x66,0x66,0x2E,0x76,0x61,0x6C,0x75,0x65,0x3D
,0x3D,0x27,0x4F,0x6E,0x27,0x29,0x20,0x7B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20
,0x69,0x6D,0x61,0x67,0x65,0x5F,0x6F,0x6E,0x5F,0x6F,0x66,0x66,0x2E,0x76,0x61,0x6C
,0x75,0x65,0x3D,0x27,0x4F,0x66,0x66,0x27,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x7D
,0x20,0x65,0x6C,0x73,0x65,0x20,0x7B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x69
,0x6D,0x61,0x67,0x65,0x5F,0x6F,0x6E,0x5F,0x6F,0x66,0x66,0x2E,0x76,0x61,0x6C,0x75
,0x65,0x3D,0x27,0x4F,0x6E,0x27,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x7D,0x0D,0x0A
,0x20,0x20,0x7D,0x0D,0x0A,0x0D,0x0A,0x20,0x20,0x66,0x75,0x6E,0x63,0x74,0x69,0x6F
,0x6E,0x20,0x48,0x51,0x5F,0x74,0x6F,0x67,0x67,0x6C,0x65,0x28,0x29,0x7B,0x0D,0x0A
,0x20,0x20,0x20,0x20,0x76,0x61,0x72,0x20,0x72,0x65,0x74,0x3B,0x0D,0x0A,0x20,0x20
,0x20,0x20,0x69,0x66,0x20,0x28,0x48,0x51,0x5F,0x4C,0x51,0x2E,0x76,0x61,0x6C,0x75
,0x65,0x3D,0x3D,0x27,0x48,0x51,0x27,0x29,0x20,0x7B,0x0D,0x0A,0x20,0x20,0x20,0x20
,0x20,0x20,0x72,0x65,0x74,0x20,0x3D,0x20,0x70,0x6F,0x73,0x74,0x28,0x22,0x71,0x75
,0x61,0x6C,0x69,0x74,0x79,0x2F,0x32,0x35,0x22,0x29,0x3B,0x0D,0x0A,0x20,0x20,0x20
,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x70,0x61,0x72,0x73,0x65,0x49,0x6E,0x74,0x28
,0x72,0x65,0x74,0x29,0x3D,0x3D,0x32,0x35,0x29,0x20,0x7B,0x0D,0x0A,0x20,0x20,0x20
,0x20,0x20,0x20,0x20,0x20,0x48,0x51,0x5F,0x4C,0x51,0x2E,0x76,0x61,0x6C,0x75,0x65
,0x3D,0x27,0x4C,0x51,0x27,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x7D,0x0D
,0x0A,0x20,0x20,0x20,0x20,0x7D,0x20,0x65,0x6C,0x73,0x65,0x20,0x7B,0x0D,0x0A,0x20
,0x20,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x20,0x3D,0x20,0x70,0x6F,0x73,0x74,0x28
,0x22,0x71,0x75,0x61,0x6C,0x69,0x74,0x79,0x2F,0x37,0x35,0x22,0x29,0x3B,0x0D,0x0A
,0x20,0x20,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x70,0x61,0x72,0x73,0x65,0x49
,0x6E,0x74,0x28,0x72,0x65,0x74,0x29,0x3D,0x3D,0x37,0x35,0x29,0x20,0x7B,0x0D,0x0A
,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x48,0x51,0x5F,0x4C,0x51,0x2E,0x76,0x61
,0x6C,0x75,0x65,0x3D,0x27,0x48,0x51,0x27,0x3B,0x0D,0x0A,0x20,0x20,0x20,0x20,0x20
,0x20,0x7D,0x0D,0x0A,0x20,0x20,0x20,0x20,0x7D,0x0D,0x0A,0x20,0x20,0x7D,0x0D,0x0A
,0x0D,0x0A,0x20,0x20,0x66,0x75,0x6E,0x63,0x74,0x69,0x6F,0x6E,0x20,0x43,0x68,0x61
,0x6E,0x67,0x65,0x54,0x78,0x74,0x28,0x74,0x78,0x74,0x29,0x20,0x7B,0x0D,0x0A,0x20
,0x20,0x20,0x20,0x64,0x6F,0x63,0x75,0x6D,0x65,0x6E,0x74,0x2E,0x67,0x65,0x74,0x45
,0x6C,0x65,0x6D,0x65,0x6E,0x74,0x42,0x79,0x49,0x64,0x28,0x22,0x74,0x65,0x78,0x74
,0x22,0x29,0x2E,0x69,0x6E,0x6E,0x65,0x72,0x48,0x54,0x4D,0x4C,0x3D,0x74,0x78,0x74
,0x3B,0x0D,0x0A,0x20,0x20,0x7D,0x0D,0x0A,0x0D,0x0A,0x2F,0x2F,0x5D,0x5D,0x3E,0x3C
,0x2F,0x73,0x63,0x72,0x69,0x70,0x74,0x3E,0x0D,0x0A,0x3C,0x73,0x74,0x79,0x6C,0x65
,0x20,0x74,0x79,0x70,0x65,0x3D,0x22,0x74,0x65,0x78,0x74,0x2F,0x63,0x73,0x73,0x22
,0x3E,0x0D,0x0A,0x20,0x20,0x23,0x77,0x65,0x62,0x63,0x61,0x6D,0x20,0x69,0x6D,0x67
,0x7B,0x6C,0x65,0x66,0x74,0x3A,0x30,0x3B,0x72,0x69,0x67,0x68,0x74,0x3A,0x30,0x3B
,0x6D,0x61,0x78,0x2D,0x77,0x69,0x64,0x74,0x68,0x3A,0x36,0x34,0x30,0x70,0x78,0x3B
,0x77,0x69,0x64,0x74,0x68,0x3A,0x31,0x30,0x30,0x25,0x3B,0x68,0x65,0x69,0x67,0x68
,0x74,0x3A,0x61,0x75,0x74,0x6F,0x7D,0x0D,0x0A,0x20,0x20,0x23,0x77,0x65,0x62,0x63
,0x61,0x6D,0x20,0x63,0x61,0x6E,0x76,0x61,0x73,0x7B,0x6C,0x65,0x66,0x74,0x3A,0x30
,0x3B,0x72,0x69,0x67,0x68,0x74,0x3A,0x30,0x3B,0x6D,0x61,0x78,0x2D,0x77,0x69,0x64
,0x74,0x68,0x3A,0x36,0x34,0x30,0x70,0x78,0x3B,0x77,0x69,0x64,0x74,0x68,0x3A,0x31
,0x30,0x30,0x25,0x3B,0x68,0x65,0x69,0x67,0x68,0x74,0x3A,0x61,0x75,0x74,0x6F,0x7D
,0x0D,0x0A,0x20,0x20,0x3C,0x2F,0x73,0x74,0x79,0x6C,0x65,0x3E,0x0D,0x0A,0x3C,0x2F
,0x68,0x65,0x61,0x64,0x3E,0x0D,0x0A,0x3C,0x62,0x6F,0x64,0x79,0x3E,0x0D,0x0A,0x20
,0x20,0x3C,0x62,0x6F,0x64,0x79,0x20,0x6F,0x6E,0x6C,0x6F,0x61,0x64,0x3D,0x22,0x63
,0x72,0x65,0x61,0x74,0x65,0x49,0x6D,0x61,0x67,0x65,0x4C,0x61,0x79,0x65,0x72,0x28
,0x29,0x3B,0x22,0x3E,0x0D,0x0A,0x20,0x20,0x3C,0x66,0x6F,0x72,0x6D,0x20,0x61,0x63
,0x74,0x69,0x6F,0x6E,0x3D,0x22,0x23,0x22,0x20,0x6E,0x61,0x6D,0x65,0x3D,0x22,0x46
,0x31,0x22,0x3E,0x0D,0x0A,0x20,0x20,0x57,0x61,0x69,0x74,0x20,0x74,0x69,0x6D,0x65
,0x20,0x3C,0x69,0x6E,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3D,0x22,0x72,0x61
,0x6E,0x67,0x65,0x22,0x20,0x6E,0x61,0x6D,0x65,0x3D,0x22,0x77,0x61,0x69,0x74,0x74
,0x69,0x6D,0x65,0x22,0x20,0x76,0x61,0x6C,0x75,0x65,0x3D,0x22,0x35,0x30,0x30,0x22
,0x20,0x6D,0x61,0x78,0x3D,0x22,0x31,0x30,0x30,0x30,0x22,0x20,0x73,0x74,0x65,0x70
,0x3D,0x22,0x35,0x30,0x22,0x3E,0x20,0x5B,0x6D,0x73,0x5D,0x20,0x20,0x0D,0x0A,0x20
,0x20,0x3C,0x69,0x6E,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3D,0x22,0x62,0x75
,0x74,0x74,0x6F,0x6E,0x22,0x20,0x49,0x44,0x3D,0x22,0x69,0x6D,0x61,0x67,0x65,0x5F
,0x6F,0x6E,0x5F,0x6F,0x66,0x66,0x22,0x20,0x6F,0x6E,0x43,0x6C,0x69,0x63,0x6B,0x3D
,0x22,0x69,0x6D,0x61,0x67,0x65,0x5F,0x74,0x6F,0x67,0x67,0x6C,0x65,0x28,0x29,0x22
,0x20,0x76,0x61,0x6C,0x75,0x65,0x3D,0x22,0x4F,0x6E,0x22,0x3E,0x20,0x20,0x0D,0x0A
,0x20,0x20,0x3C,0x69,0x6E,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3D,0x22,0x62
,0x75,0x74,0x74,0x6F,0x6E,0x22,0x20,0x49,0x44,0x3D,0x22,0x48,0x51,0x5F,0x4C,0x51
,0x22,0x20,0x6F,0x6E,0x43,0x6C,0x69,0x63,0x6B,0x3D,0x22,0x48,0x51,0x5F,0x74,0x6F
,0x67,0x67,0x6C,0x65,0x28,0x29,0x22,0x20,0x76,0x61,0x6C,0x75,0x65,0x3D,0x22,0x48
,0x51,0x22,0x3E,0x20,0x20,0x0D,0x0A,0x20,0x20,0x3C,0x64,0x69,0x76,0x20,0x69,0x64
,0x3D,0x22,0x74,0x65,0x78,0x74,0x22,0x3E,0x3C,0x2F,0x64,0x69,0x76,0x3E,0x0D,0x0A
,0x20,0x20,0x3C,0x2F,0x66,0x6F,0x72,0x6D,0x3E,0x0D,0x0A,0x20,0x20,0x3C,0x64,0x69
,0x76,0x20,0x69,0x64,0x3D,0x22,0x77,0x65,0x62,0x63,0x61,0x6D,0x22,0x3E,0x0D,0x0A
,0x20,0x20,0x20,0x20,0x3C,0x63,0x61,0x6E,0x76,0x61,0x73,0x20,0x69,0x64,0x3D,0x22
,0x73,0x74,0x72,0x6F,0x6B,0x65,0x22,0x20,0x77,0x69,0x64,0x74,0x68,0x3D,0x22,0x33
,0x32,0x30,0x22,0x20,0x68,0x65,0x69,0x67,0x68,0x74,0x3D,0x22,0x32,0x34,0x30,0x22
,0x20,0x73,0x74,0x79,0x6C,0x65,0x3D,0x22,0x70,0x6F,0x73,0x69,0x74,0x69,0x6F,0x6E
,0x3A,0x20,0x61,0x62,0x73,0x6F,0x6C,0x75,0x74,0x65,0x3B,0x20,0x7A,0x2D,0x69,0x6E
,0x64,0x65,0x78,0x3A,0x20,0x31,0x22,0x3E,0x3C,0x2F,0x63,0x61,0x6E,0x76,0x61,0x73
,0x3E,0x0D,0x0A,0x20,0x20,0x3C,0x2F,0x64,0x69,0x76,0x3E,0x0D,0x0A,0x3C,0x2F,0x62
,0x6F,0x64,0x79,0x3E,0x0D,0x0A,0x3C,0x2F,0x68,0x74,0x6D,0x6C,0x3E,0x0D,0x0A
};

