// Sample for GR-PEACH
//
// Required hardware: Ethernet, following files stored in SD
//  index.htm : http://gadget.renesas.com/software/peach/index.htm
//  mbedrpc.js : http://gadget.renesas.com/software/peach/mbedrpc.js
//
// Public Domain

#include <Arduino.h>
#include "SPI.h"
#include "SD.h"
#include "HTTPServer.h"
#include "mbed_rpc.h"
#include "EthernetInterface.h"
#include "FATFileSystem.h"
#include "RomRamBlockDevice.h"

FATFileSystem fs("storage");
RomRamBlockDevice romram_bd(512000, 512);
#define NUM_WEBFILES 2
const char mount_files[NUM_WEBFILES][13] = { //name should be 8.3 format
        "index.htm", "mbedrpc.js" };

/** Network setting **/
// #define IP_ADDRESS           ("192.168.11.2")     /* IP address      */
// #define SUBNET_MASK          ("255.255.255.0")   /* Subnet mask     */
// #define DEFAULT_GATEWAY      ("192.168.11.3")     /* Default gateway */

EthernetInterface network;
File myFile;

static void mount_romramfs(void) {
  FILE * fp;

  romram_bd.SetRomAddr(0x18000000, 0x1FFFFFFF);
  fs.format(&romram_bd, 512);
  fs.mount(&romram_bd);

  char write_path[20];

  for (int i = 0; i < NUM_WEBFILES; i++) {
    myFile = SD.open(mount_files[i], FILE_READ);
    if (myFile) {
      sprintf(write_path, "/storage/%s", mount_files[i]);
      fp = fopen(write_path, "w");
      // read from the file until there's nothing else in it:
      while (myFile.available()) {
        putc(myFile.read(), fp);
      }
      // close the file:
      myFile.close();
      fclose(fp);
    }
  }
}

int char_to_int(char* c, int len){
    int r = 0;
    for (int i = 0; i < len; i++) {
        if (c[i] == 0) break;
        r = r * 10 + c[i] - '0';
    }
    return r;
}
 
void analogwrite(Arguments* arg, Reply* r) {
    if (arg != NULL) {
        /* command analysis and execute */
        analogWrite(char_to_int(arg->argv[0], 2), char_to_int(arg->argv[1], 3));
    }
}

void setup(void) {

  Serial.begin(9600);
  Serial.print("********* PROGRAM START ***********\r\n");

  if (!SD.begin()) {
    return;
  }

  mount_romramfs();   //RomRamFileSystem Mount
  
  RPCFunction rpc_analogwrite(&analogwrite, "analogWrite");

  if (network.connect() != 0) {
    return;
  }

  Serial.print("MAC Address is ");
  Serial.println(network.get_mac_address());
  Serial.print("IP Address is ");
  Serial.println(network.get_ip_address());
  Serial.print("NetMask is ");
  Serial.println(network.get_netmask());
  Serial.print("Gateway Address is ");
  Serial.println(network.get_gateway());
  Serial.println("Network Setup OK\r\n");

  FSHandler::mount("/storage", "/");
  HTTPServerAddHandler<FSHandler>("/");
  HTTPServerAddHandler<RPCHandler>("/rpc");
  HTTPServerStart(&network, 80);

}

void loop() {
}