// Flash Air Shared Memory example
// 
// Required hardware : Flash Air
//
// Public Domain
// This sample is based on below example for Flash Air
// https://flashair-developers.com/en/documents/tutorials/users/3/

#include <SPI.h>
#include <iSdio.h>
#include <utility/Sd2CardExt.h>

#define FLASHAIR_MEM_SIZE 512
#define FLASHAIR_MEM_USE 10
// In case of GR-LYCHEE, a dedicated CS pin is used.
const int chipSelectPin = 4;
Sd2CardExt card;
uint8_t buffer_sharedMem[FLASHAIR_MEM_SIZE];

boolean iSDIO_sharedMemRead(uint8_t* buf, int size) {
  if (!card.readExtMemory(1, 1, 0x1000, size, buf)) {
    return false;
  }
}

boolean iSDIO_sharedMemWrite(uint8_t* buf, int size) {
  if (!card.writeExtMemory(1, 1, 0x1000, size, buf)) {
    return false;
  }
}

void setup() {
  Serial.begin(9600);
  
  // Turn ESP32 off to stable Wi-Fi
  pinMode(PIN_ESP_EN, OUTPUT);
  digitalWrite(PIN_ESP_EN, LOW);

  // Initialize SD card.
  Serial.print(F("\nInitializing SD card..."));  
  if (card.init(SPI_FULL_SPEED, chipSelectPin)) {
    Serial.println(F("OK"));
  } 
  else {
    Serial.println(F("NG"));
    abort();
  }

  // Initializing memory to access with command.cgi op=130 from browser
  // Fill out memory to '0', because HTTP returns ASCII code
  Serial.print(F("\nInitializing shared memory in Flash Air..."));
  memset(buffer_sharedMem, '0', FLASHAIR_MEM_SIZE);
  if(true == iSDIO_sharedMemWrite(buffer_sharedMem, sizeof(buffer_sharedMem))){
    Serial.println(F("OK"));
  } 
  else {
    Serial.println(F("NG"));
    abort();
  }
}

void loop() {
  Serial.print(F("\nAccessing shared memory in Flash Air..."));  
  if(true == iSDIO_sharedMemRead(buffer_sharedMem, sizeof(buffer_sharedMem))){
    Serial.println(F("OK"));
  } 
  else {
    Serial.println(F("NG"));
    abort();
  }
  for(int i = 0; i < FLASHAIR_MEM_USE; i++){
    Serial.print(i);
    Serial.print(":");
    Serial.println(buffer_sharedMem[i] - '0');
  }
  delay(500);
}