/***********************************************************************/
/*                                                                     */
/*  FILE        :hwinit.c                                              */
/*  DATE        :Fri, Nov 27, 2009                                     */
/*  DESCRIPTION :Hardware Setup file                                   */
/*  CPU TYPE    :RX610                                                 */
/*                                                                     */
/*  This file is generated by KPIT GNU Project Generator.              */
/*                                                                     */
/***********************************************************************/
                    
//#include "iodefine_v1.01_gnu.h"
//#include "iodefine_v1.02_gnu.h"
#include "iodefine.h"
#include "hwinit.h"

#ifdef __cplusplus
extern "C" {
#endif
extern void hw_initialise(void);
#ifdef __cplusplus
}
#endif

/***********************************************************************/
/*  Function : Set up RX610 hardware                                   */
/***********************************************************************/
void hw_initialise(void)
{
	/* SCKCR setting */
	SYSTEM.SCKCR.LONG = 0x00020100;	// Iphi=100MHz, Bphi=25MHz, Pphi=50MHz

	/* LED PORT setting */
	led_0_port = LED_OFF;		// LED0 OFF
	led_1_port = LED_OFF;		// LED1 OFF
	led_2_port = LED_OFF;		// LED2 OFF
	led_3_port = LED_OFF;		// LED3 OFF

	led_0_port_dir	= 1;		// LED0
	led_1_port_dir	= 1;		// LED1
	led_2_port_dir	= 1;		// LED2
	led_3_port_dir	= 1;		// LED3

	/* MSTPCRA, MSTPCRB and MSTPCRC setting */
	SYSTEM.MSTPCRA.LONG = 0x67FFDFFF;	// Only TPU UNIT0 in MSTPCRA acts.
	SYSTEM.MSTPCRB.LONG = 0xFFFFFFFF;	// All modules in MSTPCRB stop. 
	SYSTEM.MSTPCRC.LONG = 0xFFFF0000;	// All modules in MSTPCRC stop.
	
	/* I/O pins for LCD module */
	
	/* Note DDR registers are write only; assign these registers */
	/* Data Direction Register for LCD Lower 3 bits of data bus. */
	PORT9.DDR.BYTE = 0xf0;

	/* Note DDR registers are write only; assign these registers */
	/* Data Direction Register for LCD EN & RS outputs */
	PORT8.DDR.BYTE = 0xff;
}
