/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import processing.app.Base;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.ProcessUtils;
import processing.app.helpers.StringReplacer;
import processing.app.helpers.filefilters.OnlyDirs;
import processing.app.packages.Library;
import processing.core.PApplet;

public class Compiler
implements MessageConsumer {
    static final String BUGS_URL = I18n._("http://github.com/arduino/Arduino/issues");
    static final String SUPER_BADNESS = I18n.format(I18n._("Compiler error, please submit this code to {0}"), BUGS_URL);
    private Sketch sketch;
    private List<File> objectFiles;
    private PreferencesMap prefs;
    private boolean verbose;
    private boolean sketchIsCompiled;
    private String targetArch;
    private RunnerException exception;
    boolean firstErrorFound;
    boolean secondErrorFound;

    public boolean compile(Sketch _sketch, String _buildPath, String _primaryClassName, boolean _verbose) throws RunnerException {
        this.sketch = _sketch;
        this.verbose = _verbose;
        this.sketchIsCompiled = false;
        this.objectFiles = new ArrayList<File>();
        this.prefs = this.createBuildPreferences(_buildPath, _primaryClassName);
        this.sketch.setCompilingProgress(20);
        ArrayList<String> includePaths = new ArrayList<String>();
        includePaths.add((String)this.prefs.get("build.core.path"));
        if (((String)this.prefs.get("build.variant.path")).length() != 0) {
            includePaths.add((String)this.prefs.get("build.variant.path"));
        }
        for (Library lib : this.sketch.getImportedLibraries()) {
            for (File folder : lib.getSrcFolders(this.targetArch)) {
                includePaths.add(folder.getPath());
            }
        }
        this.sketch.setCompilingProgress(30);
        this.compileSketch(includePaths);
        this.sketchIsCompiled = true;
        this.sketch.setCompilingProgress(40);
        this.compileLibraries(includePaths);
        this.sketch.setCompilingProgress(50);
        this.compileCore();
        this.sketch.setCompilingProgress(60);
        this.compileLink(includePaths);
        this.sketch.setCompilingProgress(70);
        this.compileEep(includePaths);
        this.sketch.setCompilingProgress(80);
        this.compileHex(includePaths);
        this.sketch.setCompilingProgress(90);
        return true;
    }

    private PreferencesMap createBuildPreferences(String _buildPath, String _primaryClassName) throws RunnerException {
        TargetPlatform tp;
        if (Base.getBoardPreferences() == null) {
            RunnerException re = new RunnerException(I18n._("No board selected; please choose a board from the Tools > Board menu."));
            re.hideStackTrace();
            throw re;
        }
        TargetPlatform targetPlatform = Base.getTargetPlatform();
        TargetPlatform corePlatform = null;
        PreferencesMap boardPreferences = Base.getBoardPreferences();
        String core = (String)boardPreferences.get("build.core");
        if (core.contains(":")) {
            String[] split = core.split(":");
            core = split[1];
            corePlatform = Base.getTargetPlatform(split[0], targetPlatform.getId());
            if (corePlatform == null) {
                RunnerException re = new RunnerException(I18n.format(I18n._("Selected board depends on '{0}' core (not installed)."), split[0]));
                re.hideStackTrace();
                throw re;
            }
        }
        PreferencesMap p = new PreferencesMap();
        p.putAll(Preferences.getMap());
        if (corePlatform != null) {
            p.putAll(corePlatform.getPreferences());
        }
        p.putAll(targetPlatform.getPreferences());
        p.putAll(Base.getBoardPreferences());
        for (String k : p.keySet()) {
            if (p.get(k) != null) continue;
            p.put(k, "");
        }
        p.put("build.path", _buildPath);
        p.put("build.project_name", _primaryClassName);
        this.targetArch = targetPlatform.getId();
        p.put("build.arch", this.targetArch.toUpperCase());
        if (!p.containsKey("compiler.path")) {
            p.put("compiler.path", Base.getAvrBasePath());
        }
        if ((tp = corePlatform) == null) {
            tp = targetPlatform;
        }
        File coreFolder = new File(tp.getFolder(), "cores");
        coreFolder = new File(coreFolder, core);
        p.put("build.core", core);
        p.put("build.core.path", coreFolder.getAbsolutePath());
        File systemFolder = tp.getFolder();
        systemFolder = new File(systemFolder, "system");
        p.put("build.system.path", systemFolder.getAbsolutePath());
        String variant = (String)p.get("build.variant");
        if (variant != null) {
            TargetPlatform t;
            if (!variant.contains(":")) {
                t = targetPlatform;
            } else {
                String[] split = variant.split(":", 2);
                t = Base.getTargetPlatform(split[0], targetPlatform.getId());
                variant = split[1];
            }
            File variantFolder = new File(t.getFolder(), "variants");
            variantFolder = new File(variantFolder, variant);
            p.put("build.variant.path", variantFolder.getAbsolutePath());
        } else {
            p.put("build.variant.path", "");
        }
        return p;
    }

    private List<File> compileFiles(String outputPath, File sourcePath, boolean recurse, List<String> includePaths) throws RunnerException {
        String[] cmd;
        File dependFile;
        File objectFile;
        String dependPath;
        String objectPath;
        List<File> sSources = Compiler.findFilesInFolder(sourcePath, "S", recurse);
        List<File> cSources = Compiler.findFilesInFolder(sourcePath, "c", recurse);
        List<File> cppSources = Compiler.findFilesInFolder(sourcePath, "cpp", recurse);
        ArrayList<File> objectPaths = new ArrayList<File>();
        for (File file : sSources) {
            objectPath = outputPath + File.separator + file.getName() + ".o";
            objectPaths.add(new File(objectPath));
            String[] cmd2 = this.getCommandCompilerS(includePaths, file.getAbsolutePath(), objectPath);
            this.execAsynchronously(cmd2);
        }
        for (File file : cSources) {
            objectPath = outputPath + File.separator + file.getName() + ".o";
            dependPath = outputPath + File.separator + file.getName() + ".d";
            objectFile = new File(objectPath);
            dependFile = new File(dependPath);
            objectPaths.add(objectFile);
            if (this.is_already_compiled(file, objectFile, dependFile, this.prefs)) continue;
            cmd = this.getCommandCompilerC(includePaths, file.getAbsolutePath(), objectPath);
            this.execAsynchronously(cmd);
        }
        for (File file : cppSources) {
            objectPath = outputPath + File.separator + file.getName() + ".o";
            dependPath = outputPath + File.separator + file.getName() + ".d";
            objectFile = new File(objectPath);
            dependFile = new File(dependPath);
            objectPaths.add(objectFile);
            if (this.is_already_compiled(file, objectFile, dependFile, this.prefs)) continue;
            cmd = this.getCommandCompilerCPP(includePaths, file.getAbsolutePath(), objectPath);
            this.execAsynchronously(cmd);
        }
        return objectPaths;
    }

    private boolean is_already_compiled(File src, File obj, File dep, Map<String, String> prefs) {
        boolean ret = true;
        try {
            String line;
            long obj_modified;
            if (!obj.exists()) {
                return false;
            }
            if (!dep.exists()) {
                return false;
            }
            long src_modified = src.lastModified();
            if (src_modified >= (obj_modified = obj.lastModified())) {
                return false;
            }
            if (src_modified >= dep.lastModified()) {
                return false;
            }
            BufferedReader reader = new BufferedReader(new FileReader(dep.getPath()));
            boolean need_obj_parse = true;
            while ((line = reader.readLine()) != null) {
                if (line.endsWith("\\")) {
                    line = line.substring(0, line.length() - 1);
                }
                if ((line = line.trim()).length() == 0) continue;
                if (need_obj_parse) {
                    if (line.endsWith(":")) {
                        File linefile;
                        String linepath;
                        line = line.substring(0, line.length() - 1);
                        String objpath = obj.getCanonicalPath();
                        if (objpath.compareTo(linepath = (linefile = new File(line)).getCanonicalPath()) == 0) {
                            need_obj_parse = false;
                            continue;
                        }
                        ret = false;
                        break;
                    }
                    ret = false;
                    break;
                }
                File prereq = new File(line);
                if (!prereq.exists()) {
                    ret = false;
                    break;
                }
                if (prereq.lastModified() < obj_modified) continue;
                ret = false;
                break;
            }
            reader.close();
        }
        catch (Exception e) {
            return false;
        }
        if (ret && (this.verbose || Preferences.getBoolean("build.verbose"))) {
            System.out.println("  Using previously compiled: " + obj.getPath());
        }
        return ret;
    }

    private void execAsynchronously(String[] command) throws RunnerException {
        Process process;
        ArrayList<String> stringList = new ArrayList<String>();
        for (String string : command) {
            if ((string = string.trim()).length() == 0) continue;
            stringList.add(string);
        }
        command = stringList.toArray(new String[stringList.size()]);
        if (command.length == 0) {
            return;
        }
        int result = 0;
        if (this.verbose || Preferences.getBoolean("build.verbose")) {
            for (String c : command) {
                System.out.print(c + " ");
            }
            System.out.println();
        }
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        try {
            process = ProcessUtils.exec(command);
        }
        catch (IOException e) {
            RunnerException re = new RunnerException(e.getMessage());
            re.hideStackTrace();
            throw re;
        }
        MessageSiphon in = new MessageSiphon(process.getInputStream(), this);
        MessageSiphon err = new MessageSiphon(process.getErrorStream(), this);
        boolean compiling = true;
        while (compiling) {
            try {
                in.join();
                err.join();
                result = process.waitFor();
                compiling = false;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (result > 1) {
            System.err.println(I18n.format(I18n._("{0} returned {1}"), command[0], result));
        }
        if (result != 0) {
            RunnerException re = new RunnerException(I18n._("Error compiling."));
            re.hideStackTrace();
            throw re;
        }
    }

    @Override
    public void message(String s) {
        String errorFormat;
        String[] pieces;
        if (!this.verbose) {
            int i;
            String buildPath = (String)this.prefs.get("build.path");
            while ((i = s.indexOf(buildPath + File.separator)) != -1) {
                s = s.substring(0, i) + s.substring(i + (buildPath + File.separator).length());
            }
        }
        if ((pieces = PApplet.match(s, errorFormat = "([\\w\\d_]+.\\w+):(\\d+):\\s*error:\\s*(.*)\\s*")) != null) {
            String error = pieces[3];
            String msg = "";
            if (pieces[3].trim().equals("SPI.h: No such file or directory")) {
                error = I18n._("Please import the SPI library from the Sketch > Import Library menu.");
                msg = I18n._("\nAs of Arduino 0019, the Ethernet library depends on the SPI library.\nYou appear to be using it or another library that depends on the SPI library.\n\n");
            }
            if (pieces[3].trim().equals("'BYTE' was not declared in this scope")) {
                error = I18n._("The 'BYTE' keyword is no longer supported.");
                msg = I18n._("\nAs of Arduino 1.0, the 'BYTE' keyword is no longer supported.\nPlease use Serial.write() instead.\n\n");
            }
            if (pieces[3].trim().equals("no matching function for call to 'Server::Server(int)'")) {
                error = I18n._("The Server class has been renamed EthernetServer.");
                msg = I18n._("\nAs of Arduino 1.0, the Server class in the Ethernet library has been renamed to EthernetServer.\n\n");
            }
            if (pieces[3].trim().equals("no matching function for call to 'Client::Client(byte [4], int)'")) {
                error = I18n._("The Client class has been renamed EthernetClient.");
                msg = I18n._("\nAs of Arduino 1.0, the Client class in the Ethernet library has been renamed to EthernetClient.\n\n");
            }
            if (pieces[3].trim().equals("'Udp' was not declared in this scope")) {
                error = I18n._("The Udp class has been renamed EthernetUdp.");
                msg = I18n._("\nAs of Arduino 1.0, the Udp class in the Ethernet library has been renamed to EthernetUdp.\n\n");
            }
            if (pieces[3].trim().equals("'class TwoWire' has no member named 'send'")) {
                error = I18n._("Wire.send() has been renamed Wire.write().");
                msg = I18n._("\nAs of Arduino 1.0, the Wire.send() function was renamed to Wire.write() for consistency with other libraries.\n\n");
            }
            if (pieces[3].trim().equals("'class TwoWire' has no member named 'receive'")) {
                error = I18n._("Wire.receive() has been renamed Wire.read().");
                msg = I18n._("\nAs of Arduino 1.0, the Wire.receive() function was renamed to Wire.read() for consistency with other libraries.\n\n");
            }
            if (pieces[3].trim().equals("'Mouse' was not declared in this scope")) {
                error = I18n._("'Mouse' only supported on the Arduino Leonardo");
            }
            if (pieces[3].trim().equals("'Keyboard' was not declared in this scope")) {
                error = I18n._("'Keyboard' only supported on the Arduino Leonardo");
            }
            RunnerException e = null;
            if (!this.sketchIsCompiled) {
                e = this.sketch.placeException(error, pieces[1], PApplet.parseInt(pieces[2]) - 1);
            }
            if (e != null && !this.verbose) {
                SketchCode code = this.sketch.getCode(e.getCodeIndex());
                String fileName = code.isExtension("ino") || code.isExtension("pde") ? code.getPrettyName() : code.getFileName();
                int lineNum = e.getCodeLine() + 1;
                s = fileName + ":" + lineNum + ": error: " + pieces[3] + msg;
            }
            if (this.exception == null && e != null) {
                this.exception = e;
                this.exception.hideStackTrace();
            }
        }
        System.err.print(s);
    }

    private String[] getCommandCompilerS(List<String> includePaths, String sourceName, String objectName) throws RunnerException {
        String includes = Compiler.preparePaths(includePaths);
        PreferencesMap dict = new PreferencesMap(this.prefs);
        dict.put("ide_version", "1100");
        dict.put("includes", includes);
        dict.put("source_file", sourceName);
        dict.put("object_file", objectName);
        try {
            String cmd = (String)this.prefs.get("recipe.S.o.pattern");
            return StringReplacer.formatAndSplit(cmd, dict, true);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
    }

    private String[] getCommandCompilerC(List<String> includePaths, String sourceName, String objectName) throws RunnerException {
        String includes = Compiler.preparePaths(includePaths);
        PreferencesMap dict = new PreferencesMap(this.prefs);
        dict.put("ide_version", "1100");
        dict.put("includes", includes);
        dict.put("source_file", sourceName);
        dict.put("object_file", objectName);
        String cmd = (String)this.prefs.get("recipe.c.o.pattern");
        try {
            return StringReplacer.formatAndSplit(cmd, dict, true);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
    }

    private String[] getCommandCompilerCPP(List<String> includePaths, String sourceName, String objectName) throws RunnerException {
        String includes = Compiler.preparePaths(includePaths);
        PreferencesMap dict = new PreferencesMap(this.prefs);
        dict.put("ide_version", "1100");
        dict.put("includes", includes);
        dict.put("source_file", sourceName);
        dict.put("object_file", objectName);
        String cmd = (String)this.prefs.get("recipe.cpp.o.pattern");
        try {
            return StringReplacer.formatAndSplit(cmd, dict, true);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
    }

    private void createFolder(File folder) throws RunnerException {
        if (folder.isDirectory()) {
            return;
        }
        if (!folder.mkdir()) {
            throw new RunnerException("Couldn't create: " + folder);
        }
    }

    public static List<File> findFilesInFolder(File folder, String extension, boolean recurse) {
        ArrayList<File> files = new ArrayList<File>();
        if (folder.listFiles() == null) {
            return files;
        }
        for (File file : folder.listFiles()) {
            if (file.getName().startsWith(".")) continue;
            if (file.getName().endsWith("." + extension)) {
                files.add(file);
            }
            if (!recurse || !file.isDirectory()) continue;
            files.addAll(Compiler.findFilesInFolder(file, extension, true));
        }
        return files;
    }

    void compileSketch(List<String> includePaths) throws RunnerException {
        String buildPath = (String)this.prefs.get("build.path");
        this.objectFiles.addAll(this.compileFiles(buildPath, new File(buildPath), false, includePaths));
    }

    void compileLibraries(List<String> includePaths) throws RunnerException {
        File outputPath = new File((String)this.prefs.get("build.path"));
        for (Library lib : this.sketch.getImportedLibraries()) {
            for (File folder : lib.getSrcFolders(this.targetArch)) {
                if (lib.isPre15Lib()) {
                    this.compileLibrary(outputPath, folder, includePaths);
                    continue;
                }
                this.recursiveCompileLibrary(outputPath, folder, includePaths);
            }
        }
    }

    private void recursiveCompileLibrary(File outputPath, File libraryFolder, List<String> includePaths) throws RunnerException {
        File newOutputPath = this.compileFilesInFolder(outputPath, libraryFolder, includePaths);
        for (File subFolder : libraryFolder.listFiles(new OnlyDirs())) {
            this.recursiveCompileLibrary(newOutputPath, subFolder, includePaths);
        }
    }

    private File compileFilesInFolder(File outputPath, File libraryFolder, List<String> includePaths) throws RunnerException {
        File outputFolder = new File(outputPath, libraryFolder.getName());
        this.createFolder(outputFolder);
        this.objectFiles.addAll(this.compileFiles(outputFolder.getAbsolutePath(), libraryFolder, false, includePaths));
        return outputFolder;
    }

    private void compileLibrary(File outputPath, File libraryFolder, List<String> includePaths) throws RunnerException {
        File outputFolder = new File(outputPath, libraryFolder.getName());
        File utilityFolder = new File(libraryFolder, "utility");
        this.createFolder(outputFolder);
        includePaths.add(utilityFolder.getAbsolutePath());
        this.objectFiles.addAll(this.compileFiles(outputFolder.getAbsolutePath(), libraryFolder, false, includePaths));
        outputFolder = new File(outputFolder, "utility");
        this.createFolder(outputFolder);
        this.objectFiles.addAll(this.compileFiles(outputFolder.getAbsolutePath(), utilityFolder, false, includePaths));
        includePaths.remove(includePaths.size() - 1);
    }

    void compileCore() throws RunnerException {
        String corePath = (String)this.prefs.get("build.core.path");
        String variantPath = (String)this.prefs.get("build.variant.path");
        String buildPath = (String)this.prefs.get("build.path");
        ArrayList<String> includePaths = new ArrayList<String>();
        includePaths.add(corePath);
        if (variantPath.length() != 0) {
            includePaths.add(variantPath);
        }
        List<File> coreObjectFiles = this.compileFiles(buildPath, new File(corePath), true, includePaths);
        if (variantPath.length() != 0) {
            coreObjectFiles.addAll(this.compileFiles(buildPath, new File(variantPath), true, includePaths));
        }
        for (File file : coreObjectFiles) {
            String[] cmdArray;
            PreferencesMap dict = new PreferencesMap(this.prefs);
            dict.put("ide_version", "1100");
            dict.put("archive_file", "core.a");
            dict.put("object_file", file.getAbsolutePath());
            try {
                String cmd = (String)this.prefs.get("recipe.ar.pattern");
                cmdArray = StringReplacer.formatAndSplit(cmd, dict, true);
            }
            catch (Exception e) {
                throw new RunnerException(e);
            }
            this.execAsynchronously(cmdArray);
        }
    }

    void compileLink(List<String> includePaths) throws RunnerException {
        String[] cmdArray;
        String optRelax = "";
        if (((String)this.prefs.get("build.mcu")).equals("atmega2560")) {
            optRelax = ",--relax";
        }
        String objectFileList = "";
        for (File file : this.objectFiles) {
            objectFileList = objectFileList + " \"" + file.getAbsolutePath() + '\"';
        }
        objectFileList = objectFileList.substring(1);
        PreferencesMap dict = new PreferencesMap(this.prefs);
        String flags = (String)dict.get("compiler.c.elf.flags") + optRelax;
        dict.put("compiler.c.elf.flags", flags);
        dict.put("archive_file", "core.a");
        dict.put("object_files", objectFileList);
        dict.put("ide_version", "1100");
        try {
            String cmd = (String)this.prefs.get("recipe.c.combine.pattern");
            cmdArray = StringReplacer.formatAndSplit(cmd, dict, true);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
        this.execAsynchronously(cmdArray);
    }

    void compileEep(List<String> includePaths) throws RunnerException {
        String[] cmdArray;
        PreferencesMap dict = new PreferencesMap(this.prefs);
        dict.put("ide_version", "1100");
        try {
            String cmd = (String)this.prefs.get("recipe.objcopy.eep.pattern");
            cmdArray = StringReplacer.formatAndSplit(cmd, dict, true);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
        this.execAsynchronously(cmdArray);
    }

    void compileHex(List<String> includePaths) throws RunnerException {
        String[] cmdArray;
        PreferencesMap dict = new PreferencesMap(this.prefs);
        dict.put("ide_version", "1100");
        try {
            String cmd = (String)this.prefs.get("recipe.objcopy.hex.pattern");
            cmdArray = StringReplacer.formatAndSplit(cmd, dict, true);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
        this.execAsynchronously(cmdArray);
    }

    private static String preparePaths(List<String> includePaths) {
        String res = "";
        for (String p : includePaths) {
            res = res + " \"-I" + p + '\"';
        }
        return res.substring(1);
    }

    public PreferencesMap getBuildPreferences() {
        return this.prefs;
    }
}

