/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.models;

import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.dtd.models.CMNode;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMBinOp;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMLeaf;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMRepeatingLeaf;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMUniOp;
import com.sun.org.apache.xerces.internal.utils.XMLSecurityManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;

public class CMNodeFactory {
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private static final boolean DEBUG = false;
    private static final int MULTIPLICITY = 1;
    private int nodeCount = 0;
    private int maxNodeLimit;
    private XMLErrorReporter fErrorReporter;
    private XMLSecurityManager fSecurityManager = null;

    public void reset(XMLComponentManager xMLComponentManager) {
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        try {
            this.fSecurityManager = (XMLSecurityManager)xMLComponentManager.getProperty(SECURITY_MANAGER);
            if (this.fSecurityManager != null) {
                this.maxNodeLimit = this.fSecurityManager.getLimit(XMLSecurityManager.Limit.MAX_OCCUR_NODE_LIMIT) * 1;
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fSecurityManager = null;
        }
    }

    public CMNode getCMLeafNode(int n, Object object, int n2, int n3) {
        return new XSCMLeaf(n, object, n2, n3);
    }

    public CMNode getCMRepeatingLeafNode(int n, Object object, int n2, int n3, int n4, int n5) {
        this.nodeCountCheck();
        return new XSCMRepeatingLeaf(n, object, n2, n3, n4, n5);
    }

    public CMNode getCMUniOpNode(int n, CMNode cMNode) {
        this.nodeCountCheck();
        return new XSCMUniOp(n, cMNode);
    }

    public CMNode getCMBinOpNode(int n, CMNode cMNode, CMNode cMNode2) {
        return new XSCMBinOp(n, cMNode, cMNode2);
    }

    public void nodeCountCheck() {
        if (this.fSecurityManager != null && !this.fSecurityManager.isNoLimit(this.maxNodeLimit) && this.nodeCount++ > this.maxNodeLimit) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "MaxOccurLimit", new Object[]{new Integer(this.maxNodeLimit)}, (short)2);
            this.nodeCount = 0;
        }
    }

    public void resetNodeCount() {
        this.nodeCount = 0;
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.startsWith("http://apache.org/xml/properties/")) {
            int n = string.length() - "http://apache.org/xml/properties/".length();
            if (n == "security-manager".length() && string.endsWith("security-manager")) {
                this.fSecurityManager = (XMLSecurityManager)object;
                this.maxNodeLimit = this.fSecurityManager != null ? this.fSecurityManager.getLimit(XMLSecurityManager.Limit.MAX_OCCUR_NODE_LIMIT) * 1 : 0;
                return;
            }
            if (n == "internal/error-reporter".length() && string.endsWith("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)object;
                return;
            }
        }
    }
}

