#!/bin/bash
#                 Build Script For Linux and Mingw Builds
#  Modified: 31.01.2003 Created
#  Modified: 28.02.2003 Download through wget, build native gcc, mingw gcc
#  Modified: 25.03.2003 version modification, proto
#  Modified: 08.06.2003 Shifted mingw native compiler logic after linux compiler
#                       Added logic to check whether the native gcc is present
#  			Added the variable for COFF PATCH
  
# Please read the README file before using this build script

# Requirements: The script requires a timed_read, native-version, remove_cygwin_includes and 
# assign_version script in the same directory

#Please install GMP, MPFR and MPC before building the toolchain using this script.
#This is the prerequisite for building GCC 4.5.0
#Please refer to the following link for details,
#http://gcc.gnu.org/install/prerequisites.html

export CFLAGS=-O2
export CXXFLAGS=-O2
export TIMELIMIT=6

#set the path where wget is present 
PREFIX_WGET_DIR_PATH=/usr/bin
export PATH=$PATH:$PREFIX_WGET_DIR_PATH

# Only change the following variables if required. The other variables will be
# generated automatically.
export CPU=rl78
export OBJ_FORMAT=elf
export TOOLCHAIN_VERSION=v14.03
export ENABLE_TARGET=rl78-elf

export GMP_MPFR_MPC_PATH=/home/naveenh/utilites/gmp-mpfr-mpc/prefix_linux/
export GMP_MPFR_MPC_MINGW_PATH=/home/kpit/pre-requisite/gcc-4.5.x/mingw/prefix/
#export GMP_MPFR_MPC_MINGW_PATH=/home/naveenh/utilites/gmp-mpfr-mpc/prefix_mingw/
#export GMP_MPFR_MPC_MINGW_PATH=/home/naveenh/utilites/gmp-mpfr-mpc/prefix_Mingw/

# Do not use leading \ for the directories below
SOURCE_DIR_PATH=/home/kpit/fsfsrc/elf-v14.03-src-rl78
BUILD_DIR_PATH=/home/kpit
PREFIX_DIR_PATH=/usr/share
#PREFIX_DIR_PATH_ORIG=/usr/share

BINUTILS_VERSION=2.23-20140402
BINUTILS_MINGW_NATIVE_VERSION=2.22
GCC_VERSION=4.8.1-20140402
GCC_MINGW_NATIVE_VERSION=4.7.0
NEWLIB_VERSION=2.0.0-20140402
MINGW_RUNTIME_VERSION=3.20
W32API_VERSION=3.17-2

# for sh-elf linux native compiler
BINUTILS_SH_ELF_NATIVE_VERSION=2.15
GCC_SH_ELF_NATIVE_VERSION=3.3-20031215

export GCC_VERSION_INTERNAL=4.8-GNURL78_v14.03
export BINUTILS_VERSION_INTERNAL=2.23-GNURL78_v14.03
##***************************************************************************

BUILD=i686-pc-linux-gnu
HOST=i386-pc-mingw32msvc
TARGET=$CPU-$OBJ_FORMAT

GCCSRCDIR=$SOURCE_DIR_PATH/"gcc-"$GCC_VERSION
GCCSRCDIR_MINGW_NATIVE=$SOURCE_DIR_PATH/"gcc-"$GCC_MINGW_NATIVE_VERSION

BINUTILSSRCDIR=$SOURCE_DIR_PATH/"binutils-"$BINUTILS_VERSION
BINUTILSSRCDIR_MINGW_NATIVE=$SOURCE_DIR_PATH/"binutils-"$BINUTILS_MINGW_NATIVE_VERSION

NEWLIBSRCDIR=$SOURCE_DIR_PATH/"newlib-"$NEWLIB_VERSION

MINGWSRCDIR=$SOURCE_DIR_PATH/"mingw-runtime-"$MINGW_RUNTIME_VERSION
W32APISRCDIR=$SOURCE_DIR_PATH/"w32api-"$W32API_VERSION

BUILD_X_HOST_DIR=$BUILD_DIR_PATH/"mingw"-$GCC_MINGW_NATIVE_VERSION
BUILD_X_TARGET_DIR=$BUILD_DIR_PATH/$CPU-$OBJ_FORMAT"bld"$GCC_VERSION
HOST_X_TARGET_DIR=$BUILD_DIR_PATH/"mingw"$CPU-$OBJ_FORMAT"bld"$GCC_VERSION
PREFIX_BUILD_X_HOST=/home/ext-dev/naveen/mingw-4.8.1/prefix/
PREFIX_BUILD_X_TARGET=$PREFIX_DIR_PATH/gnu$CPU"_"$TOOLCHAIN_VERSION"_"$OBJ_FORMAT-1
PREFIX_HOST_X_TARGET=$PREFIX_DIR_PATH/mingwgnu$CPU"_"$TOOLCHAIN_VERSION"_"$OBJ_FORMAT-1

# Variables for assign_version script
export GCC_VERSION_INTERNAL_QUOTES='"'$GCC_VERSION_INTERNAL'"'
export KPITGNUTOOLS_URL='"'"<"URL:http:"\/\/"www.kpitgnutools.com">"'"'

#Variables for remove_cygwin_includes script
export DIR_TO_SEARCH=newlib/libc/include

##************************************************************************
if [ -d $BINUTILSSRCDIR ]; then 
	echo
else
	if [ ! -e $BINUTILSSRCDIR.tar.gz ]; then
	echo
	echo "Please download binutils-"$BINUTILS_VERSION".tar.gz by logging in KPIT Cummins Support Request System into "$SOURCE_DIR_PATH
	exit 1
	else
		echo "Extracting "$BINUTILSSRCDIR".tar.gz"
		cd $SOURCE_DIR_PATH
		tar -zxvf $BINUTILSSRCDIR".tar.gz"
		if [ $? -ne 0 ]; then
		echo "Error in extracting "$BINUTILSSRCDIR".tar.gz"
		rm -fr $BINUTILSSRCDIR
		exit 1
		fi
		cd $BUILD_DIR_PATH
	fi
fi
if [  -d $GCCSRCDIR ]; then
	echo
else
	if [ ! -e $GCCSRCDIR.tar.gz ]; then
	echo
	echo "Please download gcc-"$GCC_VERSION".tar.gz by logging in KPIT Cummins Support Request System into "$SOURCE_DIR_PATH
	exit 1
	else
		echo "Extracting "$GCCSRCDIR".tar.gz"
		cd $SOURCE_DIR_PATH
		tar -zxvf $GCCSRCDIR".tar.gz"
		if [ $? -ne 0 ]; then
		echo "Error in extracting "$GCCSRCDIR".tar.gz"
		rm -fr $GCCSRCDIR
		exit 1
		fi
		cd $BUILD_DIR_PATH
	fi
fi
if [  -d $NEWLIBSRCDIR ]; then
	echo
else
	if [ ! -e $NEWLIBSRCDIR.tar.gz ]; then
	echo
	echo "Please download newlib-"$NEWLIB_VERSION".tar.gz by logging in KPIT Cummins Support Request System into "$SOURCE_DIR_PATH
	exit 1
	else
		echo "Extracting "$NEWLIBSRCDIR".tar.gz"
		cd $SOURCE_DIR_PATH
		tar -zxvf $NEWLIBSRCDIR".tar.gz"
		if [ $? -ne 0 ]; then
		echo "Error in extracting "$NEWLIBSRCDIR".tar.gz"
		rm -fr $NEWLIBSRCDIR
		exit 1
		fi
		cd $BUILD_DIR_PATH
	fi
fi

function download_and_extract
{
	if [ ! -d $1 ]; then
		echo "Downloading "$2".tar.gz for target : "$3
		echo "Status in wget"$2".out"
		local_url=$4$2".tar.gz"
		rm -f wget$2.out
		ret_val=`wget -v  --proxy=off --progress=dot -P $SOURCE_DIR_PATH -c -o wget$2.out $local_url`
		cd $SOURCE_DIR_PATH
		tar -zxvf $2".tar.gz"
		if [ $? -ne 0 ]; then
			echo "Error in extracting "$2".tar.gz"
			exit 1
		fi
		cd $BUILD_DIR_PATH
		unset local_url ret_val
	fi
}


GCCSRCDIR_SH_ELF_NATIVE=$SOURCE_DIR_PATH/"gcc-"$GCC_SH_ELF_NATIVE_VERSION
BINUTILSSRCDIR_SH_ELF_NATIVE=$SOURCE_DIR_PATH/"binutils-"$BINUTILS_SH_ELF_NATIVE_VERSION
BUILD_NATIVE_GCC_FOR_SH_ELF=$BUILD_DIR_PATH/i686-pc-linux$GCC_SH_ELF_NATIVE_VERSION
PREFIX_NATIVE_GCC_FOR_SH_ELF=$PREFIX_DIR_PATH/i686-pc-linux$GCC_SH_ELF_NATIVE_VERSION

CONTD="y"

if [ $CPU-$OBJ_FORMAT = sh-elf ]; then
	if [ -e $PREFIX_NATIVE_GCC_FOR_SH_ELF/bin/$HOST-gcc ]; then
		build_native_gcc_flag=0
	else 
		build_native_gcc_flag=1
	fi
# For sh-elf native gcc (>2.95.3) build 
# This compiler is required for sh-elf (>gcc-3.1) builds if the native
# gcc version is less than 2.95.3. sh-elf (>gcc-3.1) requires the native gcc 
# (ver >= 2.95.3) as the gcc (ver < 2.95.3) has buggy 64-bit support. 

	. ./native-version
	if [ $build_native_gcc -eq 1 ] && [ $build_native_gcc_flag -eq 1 ]; then
		echo "Native compiler version should be >= 2.95.3."
		echo "Do you want to Build (y/n) ?: "
#		#read CONTD
		if [ $CONTD = "y" ] || [ $CONTD = "Y" ]; then

		build_native_gcc_confirm=1
		url="ftp://gcc.gnu.org/pub/gcc/releases/gcc-"$GCC_SH_ELF_NATIVE_VERSION"/"
		download_and_extract $GCCSRCDIR_SH_ELF_NATIVE "gcc-"$GCC_SH_ELF_NATIVE_VERSION  $BUILD $url
		unset url

		url="ftp://sources.redhat.com/pub/binutils/releases/"
		download_and_extract $BINUTILSSRCDIR_SH_ELF_NATIVE "binutils-"$BINUTILS_SH_ELF_NATIVE_VERSION $BUILD $url
		unset url
		else
		build_native_gcc_confirm=0
		fi
	fi
fi

#clear

#*****************************************************************
# Code for release version of library LIBGCC 
CURRENT_DIR=`pwd`
cd $GCCSRCDIR/gcc
echo "Setting LIBGCC2_DEBUG_CFLAGS for release build..."
echo 
sed 's/LIBGCC2_DEBUG_CFLAGS\ =\ -g/LIBGCC2_DEBUG_CFLAGS\ =/' Makefile.in > Makefile.in.tmp
mv -f Makefile.in Makefile.in.copy
mv -f Makefile.in.tmp Makefile.in 
cd $CURRENT_DIR 

#*****************************************************************
echo "********************************************************"
echo "* Source Directories should be under "$SOURCE_DIR_PATH" *"               
echo "********************************************************"
echo "Main Sources:"
echo "  Binutils: "$BINUTILSSRCDIR
echo "  Gcc: "$GCCSRCDIR
echo "  Newlib: "$NEWLIBSRCDIR
echo "Sources for Mingw native GCC:"
echo "  Binutils: "$BINUTILSSRCDIR_MINGW_NATIVE
echo "  Gcc: "$GCCSRCDIR_MINGW_NATIVE
echo "  Mingw-runtime: "$MINGWSRCDIR
echo "  W32api: "$W32APISRCDIR

if [ $CPU-$OBJ_FORMAT = sh-elf ]; then
echo "Sources for sh-elf native GCC:"
echo "  Binutils: "$BINUTILSSRCDIR_SH_ELF_NATIVE
echo "  Gcc: "$GCCSRCDIR_SH_ELF_NATIVE
fi

echo 
echo "Building for target : " $CPU-$OBJ_FORMAT

echo 
echo "******************************************************************"
echo "* Please make sure to execute this script through different shell*"
echo "* For example: $ sh <script name>                                  "
echo "******************************************************************" 

echo
echo "Continue Build (y/n) ?: "
##read CONTD 
#if [ $CONTD = "n" ] || [ $CONTD = "N" ]; then
#	echo "Exiting..."
#	exit 1	
#fi

export CPU OBJ_FORMAT
export SOURCE_DIR_PATH BUILD_DIR_PATH PREFIX_DIR_PATH
export BINUTILS_VERSION BINUTILS_MINGW_NATIVE_VERSION GCC_VERSION GCC_MINGW_NATIVE_VERSION NEWLIB_VERSION MINGW_RUNTIME_VERSION W32API_VERSION
export BUILD HOST TARGET 
export GCCSRCDIR GCCSRCDIR_MINGW_NATIVE BINUTILSSRCDIR BINUTILSSRCDIR_MINGW_NATIVE NEWLIBSRCDIR MINGWSRCDIR W32APISRCDIR
export BUILD_X_HOST_DIR BUILD_X_TARGET_DIR HOST_X_TARGET_DIR
export PREFIX_BUILD_X_HOST PREFIX_BUILD_X_TARGET PREFIX_HOST_X_TARGET

export ORIG_PATH=$PATH

#**********************************0*************************************
# Building the native compiler for sh-elf target.
# This is required only if the native gcc version is less than 2.95.3
#************************************************************************
#clear
if [ $CPU-$OBJ_FORMAT =  sh-elf ] && [ "$build_native_gcc_confirm" = "1" ]; then
if [ ! -e $PREFIX_NATIVE_GCC_FOR_SH_ELF/bin/gcc ]; then
echo
echo "Native Compiler version should be >= 2.95.3"
echo "Building Native Gcc for : " $BUILD" (sh-elf)"

export BINUTILS_SH_ELF_NATIVE_VERSION GCC_SH_ELF_NATIVE_VERSION
export GCCSRCDIR_SH_ELF_NATIVE BINUTILSSRCDIR_SH_ELF_NATIVE
export BUILD_NATIVE_GCC_FOR_SH_ELF PREFIX_NATIVE_GCC_FOR_SH_ELF
if [ ! -d $BUILD_NATIVE_GCC_FOR_SH_ELF ]; then 
	mkdir $BUILD_NATIVE_GCC_FOR_SH_ELF
fi
cd $BUILD_NATIVE_GCC_FOR_SH_ELF
if [ ! -d build-binutils-$BINUTILS_SH_ELF_NATIVE_VERSION ]; then
	mkdir build-binutils-$BINUTILS_SH_ELF_NATIVE_VERSION
fi
if [ ! -d build-gcc-$GCC_SH_ELF_NATIVE_VERSION ]; then
        mkdir build-gcc-$GCC_SH_ELF_NATIVE_VERSION
fi

echo
echo "The build and prefix directories:"
echo "Main build directory: " $BUILD_NATIVE_GCC_FOR_SH_ELF
echo "Subdirectories      : " build-binutils-$BINUTILS_SH_ELF_NATIVE_VERSION
echo "                    : " build-gcc-$GCC_SH_ELF_NATIVE_VERSION
echo "Prefix Directory    : " $PREFIX_NATIVE_GCC_FOR_SH_ELF
echo
echo "Continue Build (y/n) ?: "
##read CONTD
#if [ $CONTD = "n" ] || [ $CONTD = "N" ]; then
#        echo "Exiting..."
#        exit 1
#fi

echo 
echo "Building Binutils...(0)"
cd build-binutils-$BINUTILS_SH_ELF_NATIVE_VERSION 
echo "Configuring...(0)"
if ! $BINUTILSSRCDIR_SH_ELF_NATIVE/configure --target=$BUILD --prefix=$PREFIX_NATIVE_GCC_FOR_SH_ELF > configure.out 2>&1; then
echo "Error in binutils configure...(0)"
exit 1
fi

echo "Make...(0)"
if ! make > make.out 2>&1; then
echo "Error in binutils make...(0)"
exit 1
fi

echo "Make install...(0)"
if ! make install > makeinstall.out 2>&1; then
echo "Error in binutils make install...(0)"
exit 1
fi

export PATH=$PATH:$PREFIX_NATIVE_GCC_FOR_SH_ELF/"bin"
echo $PATH

echo 
echo "Building Gcc...(0)"
cd ../build-gcc-$GCC_SH_ELF_NATIVE_VERSION
echo "Configuring...(0)"
if ! $GCCSRCDIR_SH_ELF_NATIVE/configure --enable-languages=c,c++ --target=$BUILD --prefix=$PREFIX_NATIVE_GCC_FOR_SH_ELF > configure.out 2>&1; then
echo "Error in gcc configure...(0)"
exit 1
fi

echo "Make...(0)"
if ! make all-gcc > make1.out 2>&1; then
echo "Error in gcc make all-gcc...(0)"
exit 1
fi

echo "Make install...(0)"
if ! make install-gcc > makeinstall.out 2>&1; then
echo "Error in gcc make install-gcc...(0)"
exit 1
fi

export PATH=$ORIG_PATH
echo
echo "Finished building Native Gcc for : " $BUILD" (sh-elf)"
fi
fi
#**********************************0*************************************
# Ask if the user wants to apply the coff compatibility patch
if [ $OBJ_FORMAT = coff ]; then
	echo "Do you want to apply the coff patch to make GCC coff format compatible with HDI coff format? (y/n) [n] : "
	./timed_read
	retdata=$?
	if [ $retdata = 1 ]; then
		CFLAGS=$CFLAGS" -DCOFFPATCH"
	else
		echo
	fi
fi

#*****************************************************************
# Code for creating the different version files using assign_version
# script

echo
echo "Do you want to create the version files (y/n) ?: "
echo "NOTE: Generates the KPIT specific version information"
#read CONTD 
if [ $CONTD = "y" ] || [ $CONTD = "Y" ]; then
	./assign-version
fi

#*****************************************************************
# Code for removing cygwin includes from newlib sources.
echo
echo "Do you want to remove the cygwin includes from newlib sources ([y]/n)?"
echo "NOTE: This is required to remove the dependency scan error from HEW"
#read CONTD 
if [ $CONTD = "y" ] || [ $CONTD = "Y" ]; then
	./remove_cygwin_includes
fi

#*****************************************************************
# Code for resetting the MAKEINFOFLAGS from the Makefile.in file.
# This is to be done only on the GNU/Linux where the makeinfo 
# utility does not support option --split-size.
# The below code should be removed whenever the script is to be 
# released.
echo
echo "Do you want to reset the MAKEINFOFLAGS ([y]/n)" 
echo "NOTE: This is only required when makeinfo utility does not support --split-size option"
#read CONTD 
if [ $CONTD = "y" ] || [ $CONTD = "Y" ]; then
	CURRENT_DIR=`pwd`
	cd $GCCSRCDIR
	echo "Resetting the MAKEINFOFLAGS variable in GCC Source..."
	sed 's/MAKEINFOFLAGS\ =\ --split-size=5000000/MAKEINFOFLAGS=/' Makefile.in > Makefile.in.out
	mv -f Makefile.in Makefile.in.org
	mv -f Makefile.in.out Makefile.in
	cd $BINUTILSSRCDIR
	echo
	echo "Resetting the MAKEINFOFLAGS variable in Binutils Source..."
	sed 's/MAKEINFOFLAGS\ =\ --split-size=5000000/MAKEINFOFLAGS=/' Makefile.in > Makefile.in.out
	mv -f Makefile.in Makefile.in.org
	mv -f Makefile.in.out Makefile.in
	cd $NEWLIBSRCDIR
	echo
	echo "Resetting the MAKEINFOFLAGS variable in Newlib Source..."
	sed 's/MAKEINFOFLAGS\ =\ --split-size=5000000/MAKEINFOFLAGS=/' Makefile.in > Makefile.in.out
	mv -f Makefile.in Makefile.in.org
	mv -f Makefile.in.out Makefile.in
	cd $CURRENT_DIR
fi


#**********************************1*************************************
# Building the linux-x-target compiler (Build-x-target)
#************************************************************************
echo "Do you want to Build the gcc Linux - x - $TARGET? (y/n) : "
read CONTD
if [ $CONTD = "y" ] || [ $CONTD = "Y" ]; then
if [ $CPU-$OBJ_FORMAT = sh-elf ]; then
export PATH=$PREFIX_NATIVE_GCC_FOR_SH_ELF/"bin":$PATH
echo $PATH
fi
echo
echo "Building Gcc Linux - x - " $TARGET

if [ ! -d $BUILD_X_TARGET_DIR ]; then
        mkdir $BUILD_X_TARGET_DIR
fi
cd $BUILD_X_TARGET_DIR
if [ ! -d build-binutils-$BINUTILS_VERSION ]; then
        mkdir build-binutils-$BINUTILS_VERSION
fi
if [ ! -d build-gcc-$GCC_VERSION ]; then
        mkdir build-gcc-$GCC_VERSION
fi
if [ ! -d build-newlib-$NEWLIB_VERSION ]; then
        mkdir build-newlib-$NEWLIB_VERSION
fi

echo
echo "The build and prefix directories:"
echo "Main build directory: " $BUILD_X_TARGET_DIR
echo "Subdirectories      : " build-binutils-$BINUTILS_VERSION
echo "                    : " build-gcc-$GCC_VERSION
echo "                    : " build-newlib-$NEWLIB_VERSION
echo "Prefix Directory    : " $PREFIX_BUILD_X_TARGET
echo
echo "Continue Build (y/n) ?: "
read CONTD
if [ $CONTD = "n" ] || [ $CONTD = "N" ]; then
        echo "Exiting..."
        exit 1
fi

echo
echo Build Binutils? "y" or "n" ?
./../timed_read
retdata=$?
if [ $retdata = 14 ] || [ $retdata = 1 ];  then
echo "Building Binutils...(1)"
#cp $BINUTILSSRCDIR/bfd/configure-rl78 $BINUTILSSRCDIR/bfd/configure
#cp $BINUTILSSRCDIR/bfd/configure.in-rl78 $BINUTILSSRCDIR/bfd/configure.in
cd build-binutils-$BINUTILS_VERSION
echo "Configuring...(1)"
if ! $BINUTILSSRCDIR/configure --target=$TARGET --prefix=$PREFIX_BUILD_X_TARGET --disable-werror > configure.out 2>&1; then
echo "Error in binutils configure...(1)"
exit 1
fi

echo "Make...(1)"
if ! make > make.out 2>&1; then
echo "Error in binutils make...(1)"
exit 1
fi

echo "Make install...(1)"
if ! make install > makeinstall.out 2>&1; then
echo "Error in binutils make install...(1)"
exit 1
fi
cd ..
fi

export PATH=$PATH:$PREFIX_BUILD_X_TARGET/bin
echo $PATH

echo
echo Build Gcc? "y" or "n" ?
./../timed_read
retdata=$?
if [ $retdata = 14 ] || [ $retdata = 1 ];  then 
echo "Building Gcc...(1)"
#cp $GCCSRCDIR/gcc/version.c-rl78 $GCCSRCDIR/gcc/version.c
cd build-gcc-$GCC_VERSION
echo "Configuring...(1)"
if ! $GCCSRCDIR/configure --disable-shared --enable-languages=c,c++ --target=$TARGET --with-newlib --with-gmp=$GMP_MPFR_MPC_PATH --with-mpfr=$GMP_MPFR_MPC_PATH --with-mpc=$GMP_MPFR_MPC_PATH --prefix=$PREFIX_BUILD_X_TARGET --enable-lto  --disable-nls  --disable-libstdcxx-pch > configure.out 2>&1; then
echo "Error in gcc configure...(1)"
exit 1
fi

echo "Make...(1)"
if ! make LANGUAGES="c c++" all-gcc > make1.out 2>&1; then
echo "Error in gcc make all-gcc...(1)"
exit 1
fi

echo "Make install...(1)"
if ! make LANGUAGES="c c++" install-gcc > makeinstall1.out 2>&1; then
echo "Error in gcc make install-gcc...(1)"
exit 1
fi
cd ..
fi

echo $PATH
echo
echo Build Newlib? "y" or "n" ?
./../timed_read
retdata=$?
CFLAGS=-Os
if [ $retdata = 14 ] || [ $retdata = 1 ];  then
echo "Building Newlib...(1)"
cd build-newlib-$NEWLIB_VERSION
echo "Configuring...(1)"
if ! $NEWLIBSRCDIR/configure --target=$TARGET --prefix=$PREFIX_BUILD_X_TARGET > configure.out 2>&1; then
echo "Error in newlib configure...(1)"
exit 1
fi
fi

echo "Test path b4 newlib build"
echo $PATH
echo "Make...(1)"
if ! make > make.out 2>&1; then
echo "Error in newlib make...(1)"
exit 1
fi

echo "Make install...(1)"
if ! make install > makeinstall.out 2>&1; then
echo "Error in newlib make install...(1)"
exit 1
fi
cd ..
fi

echo
echo Build Final Gcc? "y" or "n" ?
./../timed_read
retdata=$?
CFLAGS=-O2
if [ $retdata = 14 ] || [ $retdata = 1 ];  then
echo "Building final Gcc...(1)"

cd build-gcc-$GCC_VERSION
echo "Make...(1)"
if ! make > makelast.out 2>&1; then
echo "Error in gcc make...(1)"
exit 1
fi
cd ./gcc
echo "Make proto...(1)"
make proto > makeproto.out 2>&1
cd ../

echo "Make install...(1)"
if ! make install > makeinstalllast.out 2>&1; then
echo "Error in gcc make install...(1)"
exit 1
fi
fi

export PATH=$ORIG_PATH
echo
echo "Finished building Gcc Linux - x - " $TARGET


##**********************************1*************************************
# Mingw Native compiler build
 
if [ -e $PREFIX_BUILD_X_HOST/bin/$HOST-gcc ]; then
	build_native_mingw=0
else build_native_mingw=1
	url="ftp://gcc.gnu.org/pub/gcc/releases/gcc-"$GCC_MINGW_NATIVE_VERSION"/"
	download_and_extract $GCCSRCDIR_MINGW_NATIVE "gcc-"$GCC_MINGW_NATIVE_VERSION $HOST $url
	unset url

	url="ftp://sources.redhat.com/pub/binutils/releases/" 
	download_and_extract $BINUTILSSRCDIR_MINGW_NATIVE "binutils-"$BINUTILS_MINGW_NATIVE_VERSION $HOST $url
	 unset url

	url="http://aleron.dl.sourceforge.net/mingw/"
	download_and_extract $MINGWSRCDIR "mingw-runtime-"$MINGW_RUNTIME_VERSION"-src" $HOST $url
	unset url

#  Mingw native compiler.
#	If w32api-2.0 and above is to be used the script modifies
#	the mingw-runtime source. 
#	Add "-I$(prefix)/$(target_alias)/include \" line to all the
#	Makefile.in files' INCLUDES.	

	if [ -d $MINGWSRCDIR ]; then
		cd $MINGWSRCDIR
		find ./ -name Makefile.in -print | while read i
		do
		        cp $i $i.orig
			pat_cnt=`grep -c 'INCLUDES+= -I$(prefix)\/$(target_alias)\/include\ \\' $i` 
			if [ ${pat_cnt:=0} -eq 0 ]; then 
			sed 's/INCLUDES+= /INCLUDES+= -I$(prefix)\/$(target_alias)\/include \\\
 /' $i > $i.tmp
			mv $i.tmp $i
			fi
		done
		cd $BUILD_DIR_PATH
	fi
		
	url="http://aleron.dl.sourceforge.net/mingw/"
	download_and_extract $W32APISRCDIR "w32api-"$W32API_VERSION"-src" $HOST $url
	unset url

fi
#**********************************2*************************************
# Building the compiler (Build-x-host)
#************************************************************************
if [ $build_native_mingw -eq 1 ]; then
echo
echo "Building Gcc : Linux - x - Mingw " 

if [ ! -d $BUILD_X_HOST_DIR ]; then
        mkdir $BUILD_X_HOST_DIR
fi
cd $BUILD_X_HOST_DIR
if [ ! -d build-binutils-$BINUTILS_MINGW_NATIVE_VERSION ]; then
        mkdir build-binutils-$BINUTILS_MINGW_NATIVE_VERSION
fi
if [ ! -d build-gcc-$GCC_MINGW_NATIVE_VERSION ]; then
        mkdir build-gcc-$GCC_MINGW_NATIVE_VERSION
fi
if [ ! -d build-w32api-$W32API_VERSION ]; then
        mkdir build-w32api-$W32API_VERSION
fi
if [ ! -d build-mingw-$MINGW_RUNTIME_VERSION ]; then
        mkdir build-mingw-$MINGW_RUNTIME_VERSION
fi

echo
echo "The build and prefix directories:"
echo "Main build directory: " $BUILD_X_HOST_DIR 
echo "Subdirectories      : " build-binutils-$BINUTILS_MINGW_NATIVE_VERSION
echo "                    : " build-gcc-$GCC_MINGW_NATIVE_VERSION
echo "                    : " build-w32api-$W32API_VERSION
echo "                    : " build-mingw-$MINGW_RUNTIME_VERSION
echo "Prefix Directory    : " $PREFIX_BUILD_X_HOST 
echo
echo "Copying Windows Header Files"
cp -r $W32APISRCDIR/include/* $MINGWSRCDIR/include/
echo "Continue Build (y/n) ?: "
#read CONTD
if [ $CONTD = "n" ] || [ $CONTD = "N" ]; then
        echo "Exiting..."
        exit 1
fi

echo
echo "Building Binutils...(2)"
cd build-binutils-$BINUTILS_MINGW_NATIVE_VERSION
echo "Configuring...(2)"
if ! $BINUTILSSRCDIR_MINGW_NATIVE/configure  --host=$BUILD --target=$HOST --prefix=$PREFIX_BUILD_X_HOST > configure.out 2>&1; then
echo "Error in binutils configure...(2)"
exit 1
fi 

echo "Make...(2)"
if ! make > make.out 2>&1; then
echo "Error in binutils make...(2)"
exit 1
fi


echo "Make install...(2)"
if ! make install > makeinstall.out 2>&1; then
echo "Error in binutils make install...(2)"
exit 1
fi

# Copy the runtime headers from sources to the prefix directory.
echo
echo "Copying the runtime headers to prefix directory...(2)"
mkdir -p $PREFIX_BUILD_X_HOST/$HOST/include
cp -pr $MINGWSRCDIR/include/* $PREFIX_BUILD_X_HOST/$HOST/include
cp -fr $W32APISRCDIR/include/* $PREFIX_BUILD_X_HOST/$HOST/include

export PATH=$PATH:/$PREFIX_BUILD_X_HOST/"bin"
echo $PATH

echo
echo "Building Gcc...(2)"
cd ../build-gcc-$GCC_MINGW_NATIVE_VERSION
echo "Configuring...(2)"
if ! $GCCSRCDIR_MINGW_NATIVE/configure --enable-languages=c,c++ --host=$BUILD --target=$HOST --with-newlib --prefix=$PREFIX_BUILD_X_HOST > configure.out 2>&1; then
echo "Error in gcc configure...(2)"
exit 1
fi

echo "Make...(2)"
if ! make LANGUAGES="c c++" all-gcc > make1.out 2>&1; then
echo "Error in gcc make all-gcc...(2)"
exit 1
fi

CURRENT_DIR=`pwd`
cd ./gcc
echo "Remove collect2 from gcc/Makefile...(3)"
sed 's/USE_COLLECT2\ =\ collect2$(exeext)/USE_COLLECT=/' Makefile > Makefile.out
mv -f Makefile Makefile.org
mv -f Makefile.out Makefile
cd $CURRENT_DIR

echo "Make install...(2)"
if ! make LANGUAGES="c c++" install-gcc > makeinstall1.out 2>&1; then
echo "Error in gcc make install-gcc...(2)"
exit 1
fi

echo 
echo "Building W32api...(2)"
cd ../build-w32api-$W32API_VERSION
echo "Configuring...(2)"
if ! CC=$HOST-gcc AS=$HOST-as AR=$HOST-ar RANLIB=$HOST-ranlib LD=$HOST-ld DLLTOOL=$HOST-dlltool $W32APISRCDIR/configure --host=$BUILD --target=$HOST --prefix=$PREFIX_BUILD_X_HOST > configure.out 2>&1; then
echo "Error in w32api configure...(2)"
exit 1
fi

echo "Make...(2)"
if ! CC=$HOST-gcc AS=$HOST-as AR=$HOST-ar RANLIB=$HOST-ranlib LD=$HOST-ld DLLTOOL=$HOST-dlltool make > make.out 2>&1; then
echo "Error in w32api make...(2)"
exit 1
fi

echo "Make install...(2)"
if ! CC=$HOST-gcc AS=$HOST-as AR=$HOST-ar RANLIB=$HOST-ranlib LD=$HOST-ld DLLTOOL=$HOST-dlltool make install > makeinstall.out 2>&1; then
echo "Error in w32api make install...(2)"
exit 1
fi

echo 
echo "Copy all the libraries & headers to target directory...(2)"
cp -frp $PREFIX_BUILD_X_HOST/lib/* $PREFIX_BUILD_X_HOST/$HOST/lib/
cp -frp $PREFIX_BUILD_X_HOST/include/* $PREFIX_BUILD_X_HOST/$HOST/include/

echo
echo "Building mingw runtime...(2)"
cd ../build-mingw-$MINGW_RUNTIME_VERSION
echo "Configuring...(2)"
if ! CC=$HOST-gcc AS=$HOST-as AR=$HOST-ar RANLIB=$HOST-ranlib LD=$HOST-ld DLLTOOL=$HOST-dlltool $MINGWSRCDIR/configure --target=$HOST --prefix=$PREFIX_BUILD_X_HOST > configure.out 2>&1; then
echo "Error in mingw runtime configure...(2)"
exit 1
fi

# This has been added for v0402. As the libmingwex library is used before it is built.
#echo "Make Mingwex...(2)"
#CURRENT_DIR=`pwd`
#cd mingwex
#if ! CC=$HOST-gcc AS=$HOST-as AR=$HOST-ar RANLIB=$HOST-ranlib LD=$HOST-ld DLLTOOL=$HOST-dlltool make > makemingwex.out 2>&1; then
#echo "Error in mingwex make...(2)"
#exit 1
#fi
#cd $CURRENT_DIR

echo "Make...(2)"
if ! CC=$HOST-gcc AS=$HOST-as AR=$HOST-ar RANLIB=$HOST-ranlib LD=$HOST-ld DLLTOOL=$HOST-dlltool make > make.out 2>&1; then
echo "Error in mingw runtime make...(2)"
exit 1
fi

echo "Make install...(2)"
if ! CC=$HOST-gcc AS=$HOST-as AR=$HOST-ar RANLIB=$HOST-ranlib LD=$HOST-ld DLLTOOL=$HOST-dlltool make install > makeinstall.out 2>&1; then
echo "Error in mingw runtime make install...(2)"
exit 1
fi

# Some of the files like crt*.o files are generated in the make of the mingw
# runtime which are created in the root lib and include directories. 
# Copy these files to i386-pc-mingw32msvc/include and i386-pc-mingw32msvc/lib
# directories respectively.
echo
echo "Copy all the libraries & headers to target directory...(2)"
cp -frp $PREFIX_BUILD_X_HOST/include/* $PREFIX_BUILD_X_HOST/$HOST/include/ 
cp -frp $PREFIX_BUILD_X_HOST/lib/* $PREFIX_BUILD_X_HOST/$HOST/lib/

export PATH=$ORIG_PATH
echo
echo "Finished building Gcc : Linux-x-Mingw " 
fi
#**********************************2*************************************
##**********************************3*************************************
# Building the mingw-x-target compiler (host-x-target)
##************************************************************************
echo "Do you want to Build the mingw - x - $TARGET gcc? (y/n) : "
##read CONTD
#if [ $CONTD = "y" ] || [ $CONTD = "Y" ]; then
#echo
echo "Building mingw - x - $TARGET Gcc : " 

if [ ! -d $HOST_X_TARGET_DIR ]; then
        mkdir $HOST_X_TARGET_DIR
fi
cd $HOST_X_TARGET_DIR
if [ ! -d build-binutils-$BINUTILS_VERSION ]; then
        mkdir build-binutils-$BINUTILS_VERSION
fi
if [ ! -d build-gcc-$GCC_VERSION ]; then
        mkdir build-gcc-$GCC_VERSION
fi
if [ ! -d build-newlib-$NEWLIB_VERSION ]; then
        mkdir build-newlib-$NEWLIB_VERSION
fi

echo
echo "The build and prefix directories:"
echo "Main build directory: " $HOST_X_TARGET_DIR
echo "Subdirectories      : " build-binutils-$BINUTILS_VERSION
echo "                    : " build-gcc-$GCC_VERSION
echo "                    : " build-newlib-$NEWLIB_VERSION
echo "Prefix Directory    : " $PREFIX_HOST_X_TARGET
echo
echo "Continue Build (y/n) ?: "
##read CONTD
#if [ $CONTD = "n" ] || [ $CONTD = "N" ]; then
#        echo "Exiting..."
#        exit 1
#fi

export PATH=$PATH:$PREFIX_BUILD_X_HOST/bin
echo $PATH

echo
echo Build Binutils? "y" or "n" ? 
./../timed_read
retdata=$?
if [ $retdata = 14 ] || [ $retdata = 1 ];  then
echo "Building Binutils...(3)"
#cp $BINUTILSSRCDIR/bfd/configure-rl78 $BINUTILSSRCDIR/bfd/configure
#cp $BINUTILSSRCDIR/bfd/configure.in-rl78 $BINUTILSSRCDIR/bfd/configure.in
cd build-binutils-$BINUTILS_VERSION
echo "Configuring...(3)"
if [ $CPU-$OBJ_FORMAT = h8300-elf ]; then
	if ! $BINUTILSSRCDIR/configure   --build=$BUILD --host=$HOST --enable-targets=$ENABLE_TARGET --target=$TARGET --disable-werror --prefix=$PREFIX_HOST_X_TARGET > configure.out 2>&1; then
	echo "Error in binutils configure...(3)"
	exit 1
	fi
else
	if ! $BINUTILSSRCDIR/configure  --build=$BUILD --host=$HOST --target=$TARGET --prefix=$PREFIX_HOST_X_TARGET --disable-werror> configure.out 2>&1; then
	echo "Error in binutils configure...(3)"
	exit 1
	fi
fi

echo "Make...(3)"
if ! make > make.out 2>&1; then
echo "Error in binutils make...(3)"
exit 1
fi

echo "Make install...(3)"
if ! make install > makeinstall.out 2>&1; then
echo "Error in binutils make install...(3)"
exit 1
fi
cd ..
fi

export PATH=$PATH:$PREFIX_BUILD_X_TARGET/"bin":$PREFIX_HOST_X_TARGET/"bin"
echo $PATH

# Mingw doesn't support collect2 i.e. it is not ported to mingw yet.
# Therefore set the USE_COLLECT2 variable to null in gcc/Makefile.in
CURRENT_DIR=`pwd`
cd $GCCSRCDIR/gcc
echo "Remove collect2 from gcc/Makefile...(3)"
sed 's/USE_COLLECT2\ =\ collect2$(exeext)/USE_COLLECT=/' Makefile.in > Makefile.in.out
mv -f Makefile.in Makefile.in.original
mv -f Makefile.in.out Makefile.in
cd $CURRENT_DIR

echo
echo Build Gcc? "y" or "n" ?
./../timed_read
retdata=$?
if [ $retdata = 14 ] || [ $retdata = 1 ];  then
echo "Building Gcc...(3)"
#cp $GCCSRCDIR/gcc/version.c-rl78 $GCCSRCDIR/gcc/version.c
cd build-gcc-$GCC_VERSION
echo "Configuring...(3)"
if ! $GCCSRCDIR/configure --disable-shared  --build=$BUILD --host=$HOST --enable-languages=c,c++ --target=$TARGET --with-newlib --with-gmp=$GMP_MPFR_MPC_MINGW_PATH --with-mpfr=$GMP_MPFR_MPC_MINGW_PATH --with-mpc=$GMP_MPFR_MPC_MINGW_PATH --prefix=$PREFIX_HOST_X_TARGET --enable-lto --disable-nls  --disable-libstdcxx-pch > configure.out 2>&1; then
echo "Error in gcc configure...(3)"
exit 1
fi

echo "Configuring libiberty...(3)"
if ! make configure-build-libiberty > makec.out 2>&1; then
echo "Error in gcc configure libiberty...(3)"
exit 1
fi

echo "Make libiberty...(3)"
if ! make all-build-libiberty > makeac.out 2>&1; then
echo "Error in gcc make libiberty...(3)"
exit 1
fi

echo "Make...(3)"
if ! make LANGUAGES="c c++" all-gcc > make1.out 2>&1; then
echo "Error in gcc make all-gcc...(3)"
exit 1
fi

echo "Make install...(3)"
if ! make LANGUAGES="c c++" install-gcc > makeinstall1.out 2>&1; then
echo "Error in gcc make install-gcc...(3)"
exit 1
fi
cd ..
fi

echo
echo Build Newlib? "y" or "n" ?
./../timed_read
retdata=$?
CFLAGS=-Os
if [ $retdata = 14 ] || [ $retdata = 1 ];  then
echo "Building Newlib...(3)"
cd build-newlib-$NEWLIB_VERSION
echo "Configuring...(3)"
if [ $CPU = h8300 ]; then
echo h8300 
if ! $NEWLIBSRCDIR/configure --build=$BUILD --host=$HOST --target=$TARGET --prefix=$PREFIX_HOST_X_TARGET > configure.out 2>&1; then
echo "Error in newlib configure...(3)"
exit 1
fi
else
echo sh
if ! $NEWLIBSRCDIR/configure --build=$BUILD --host=$HOST --target=$TARGET --prefix=$PREFIX_HOST_X_TARGET > configure.out 2>&1; then
echo "Error in newlib configure...(3)"
exit 1
fi
fi

echo "Make...(3)"
if ! make > make.out 2>&1; then
echo "Error in newlib make...(3)"
exit 1
fi

echo "Make install...(3)"
if ! make install > makeinstall.out 2>&1; then
echo "Error in newlib make install...(3)"
exit 1
fi
cd ..
fi

echo
echo Build Final Gcc? "y" or "n" ?
./../timed_read
retdata=$?
CFLAGS=-O2
if [ $retdata = 14 ] || [ $retdata = 1 ]; then
echo "Building final Gcc...(3)"
cd build-gcc-$GCC_VERSION

echo "Make...(3)"
if ! make > makelast.out 2>&1; then
echo "Error in gcc make...(3)"
exit 1
fi


echo "Make install...(3)"
if ! make install > makeinstalllast.out 2>&1; then
echo "Error in gcc make install...(3)"
exit 1
fi

# Protoize building
cp $BUILD_X_TARGET_DIR/build-gcc-$GCC_VERSION/gcc/SYSCALLS.c.X ./gcc
CURRENT_DIR=`pwd`
cd $GCCSRCDIR/gcc
cp -f Makefile.in Makefile.in.org
patch < Makefile.in.diff
cd $CURRENT_DIR
cd ./gcc
echo "Make proto...(2)"
make proto > makeproto.out 2>&1

echo "Make install...(3)"
make install > makeinstallproto.out 2>&1
cd ../

#Restore the original Makefile.in for linux builds
cp -f $GCCSRCDIR/gcc/Makefile.in.original $GCCSRCDIR/gcc/Makefile.in

fi

echo
echo "Finished building mingw - x - $TARGET Gcc " 

#**********************************3*************************************
