/***************************************************************/
/*                                                             */
/*      PROJECT NAME :  kaede_64M_new                          */
/*      FILE         :  hardware_setup.c                       */
/*      DESCRIPTION  :  Hardware Initialization                */
/*      CPU SERIES   :  RX600                                  */
/*      CPU TYPE     :  RX64M                                  */
/*                                                             */
/*      This file is generated by e2 studio.                   */
/*                                                             */
/***************************************************************/                                
                                                                           
                                                                           
/************************************************************************/
/*    File Version: V1.00                                               */
/*    Date Generated: 08/07/2013                                        */
/************************************************************************/
/*
 *  Modified 25 Sep 2014 by Koji Uchida :  Changed added to the RSK +
 */ 

#include "iodefine.h"
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

extern void HardwareSetup(void);

#ifdef __cplusplus
}
#endif

void HardwareSetup(void)
{
    // Protection off
    SYSTEM.PRCR.WORD = 0xA503u;

    // Stop sub-clock
    SYSTEM.SOSCCR.BYTE = 0x01u;

    // Set main oscillator settling time to 10ms (131072 cycles @ 12MHz)
    //SYSTEM.MOSCWTCR.BYTE = 0x0Du;
	SYSTEM.MOSCWTCR.BYTE = 0x20u;			//RSK+ ・ｽN・ｽ・ｽ・ｽb・ｽN24MHz・ｽﾈので値・ｽﾍ大き・ｽ・ｽ・ｽ・ｽ・ｽﾄまゑｿｽ
											//kaede・ｽﾈゑｿｽsakura・ｽﾆ難ｿｽ・ｽ・ｽ・ｽl・ｽﾅゑｿｽ・ｽ・ｽ・ｽ・ｷ・ｽ驍ｩ・ｽ・ｽ・ｽH

    // Set PLL circuit settling time to 10ms (2097152 cycles @ 192MHz)
    //SYSTEM.PLLWTCR.BYTE = 0x0Eu;

    // Set PLL circuit to x16
#ifdef GRKAEDE  /* KAEDE 2 divides the PLL input */
    SYSTEM.PLLCR.WORD = 0x1F00u;
#else         /* RSK+  2 divides the PLL input */
    SYSTEM.PLLCR.WORD = 0x1F01u;
#endif
    // Start the external 12Mhz oscillator
    SYSTEM.MOSCCR.BYTE = 0x00u;

    // Turn on the PLL
    SYSTEM.PLLCR2.BYTE = 0x00u;

    // Wait over 12ms (~2075op/s @ 125KHz)
    for(volatile uint16_t i = 0; i < 5000u ; i++)		//RSK+・ｽ・ｽ・ｽ・ｽ・ｽ・ｽ・ｽ・ｽ・ｽ・ｽﾟに取得
    {
        __asm("nop");
    }

    // Configure the clocks as follows -
    //Clock Description              Frequency
    //----------------------------------------
    //PLL Clock frequency...............192MHz
    //FlashIF Clock......................48MHz
    //System Clock Frequency(ICK)........96MHz
    //External Bus Clock.................48MHz
    //Peripheral Module Clock A..........48MHz
    //Peripheral Module Clock B..........48MHz
    //Peripheral Module Clock C..........48MHz
    //Peripheral Module Clock D..........48MHz
     SYSTEM.SCKCR.LONG = 0x21022222u;

    // Configure the clocks as follows -
    //Clock Description              Frequency
    //----------------------------------------
    //USB Clock..........................48MHz
    SYSTEM.SCKCR2.WORD = 0x0031u;

    // Set the clock source to PLL
    SYSTEM.SCKCR3.WORD = 0x0400u;

    /* The external bus is disabled. */
    SYSTEM.SYSCR0.WORD = 0x5A01;

    //EtherC, EDMAC
    SYSTEM.MSTPCRB.BIT.MSTPB15 = 0;

#if 0
    // Protection on
    SYSTEM.PRCR.WORD = 0xA500u;
#endif
    // Enable the PFSWE midification.
    MPC.PWPR.BIT.B0WI = 0;
    // Disable the PFS register protect.
    MPC.PWPR.BIT.PFSWE = 1;

}

