/*
  Set time and alarm 
 
  This example code is in the public domain.
 */
 

#include <RTC.h>

RTC rtc;
int g_year    = 2016;
int g_mon     = 4;
int g_day     = 13;
int g_hour    = 9;
int g_min     = 20;
int g_sec     = 50;
int g_week    = RTC_WEEK_WEDNESDAY;

void alarm_handler();
void setup()
{
  Serial.begin(9600);
  pinMode(PIN_LED0, OUTPUT); // led for alarm
  digitalWrite(PIN_LED0, LOW); //turn off
  rtc.begin();
  rtc.setDateTime(g_year, g_mon, g_day, g_hour, g_min, g_sec, g_week);
 
  rtc.attachAlarmHandler(alarm_handler);
  rtc.setAlarmTime(g_hour, g_min + 1);
  rtc.alarmOn();
 
}
 
void loop()
{
  rtc.getDateTime(g_year, g_mon, g_day, g_hour, g_min, g_sec, g_week);

  Serial.print(g_year, DEC);Serial.print("/");
  Serial.print(g_mon, DEC); Serial.print("/");
  Serial.print(g_day, DEC); Serial.print(" ");
  Serial.print(g_hour, DEC); Serial.print(":");
  Serial.print(g_min, DEC); Serial.print(":");
  Serial.println(g_sec, DEC);
 
  delay(500);
 
}
 
void alarm_handler()
{
  digitalWrite(PIN_LED0, HIGH);// led for alarm
}