/***********************************************************************/
/*  													               */
/*      PROJECT NAME :  test                                           */
/*      FILE         :  reset_program.asm                              */
/*      DESCRIPTION  :  Reset Program                                  */
/*      CPU SERIES   :  RX600                                          */
/*      CPU TYPE     :  RX62T                                          */
/*  													               */
/*      This file is generated by KPIT Eclipse.                        */
/*  													               */
/***********************************************************************/                                                                        


	/*reset_program.asm*/

	.list
	.section .text
	.global _PowerON_Reset    /*global Start routine */
	
#ifdef CPPAPP	
___dso_handle:
	.global ___dso_handle
#endif	

	.extern _HardwareSetup /*external Sub-routine to initialise Hardware*/
	.extern _data
	.extern _mdata
	.extern _ebss
	.extern _bss
	.extern _edata
	.extern _main 
	.extern _ustack
	.extern _istack
	.extern _rvectors
#if GDB_SIMULATOR_DEBUG
	.extern _exit
#endif

	
_PowerON_Reset :
/* initialise user stack pointer */
	mvtc	#_ustack,USP

/* initialise interrupt stack pointer */
	mvtc	#_istack,ISP

/* setup intb */
	mvtc	#_rvectors_start, intb	/* INTERRUPT VECTOR ADDRESS  definition	*/

/* setup FPSW */
	mvtc    #100h, fpsw	

/* load data section from ROM to RAM */

	mov     #_mdata,r2      /* src ROM address of data section in R2 */
	mov     #_data,r1       /* dest start RAM address of data section in R1 */
	mov     #_edata,r3      /* end RAM address of data section in R3 */
	sub    r1,r3            /* size of data section in R3 (R3=R3-R1) */
	smovf                   /* block copy R3 bytes from R2 to R1 */

/* bss initialisation : zero out bss */

	mov	#00h,r2  	/* load R2 reg with zero */
	mov	#_ebss, r3  /* store the end address of bss in R3 */
	mov	#_bss, r1 	/* store the start address of bss in R1 */
	sub   r1,r3	   	/* size of bss section in R3 (R3=R3-R1) */
	sstr.b
#ifndef GDB_SIMULATOR_DEBUG
/* call the hardware initialiser */
	bsr.a	_HardwareSetup	
	nop

/* setup PSW */
	mvtc	#10000h, psw			/* Set Ubit & Ibit for PSW */

/* change PSW PM to user-mode */
	MVFC   PSW,R1
	OR     #00100000h,R1
	PUSH.L R1
	MVFC   PC,R1
	ADD    #10,R1
	PUSH.L R1
	RTE
	NOP
	NOP
#endif
/* start user program */
	bsr.a	_main		
	
/* call to exit*/
_exit:
	bsr.a 	_exit
	
	.end
