/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message.stream;

import com.sun.xml.internal.org.jvnet.staxex.Base64Data;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.encoding.DataSourceStreamingDataHandler;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class StreamAttachment
implements Attachment {
    private final String contentId;
    private final String contentType;
    private final ByteArrayBuffer byteArrayBuffer;
    private final byte[] data;
    private final int len;

    public StreamAttachment(ByteArrayBuffer byteArrayBuffer, String string, String string2) {
        this.contentId = string;
        this.contentType = string2;
        this.byteArrayBuffer = byteArrayBuffer;
        this.data = this.byteArrayBuffer.getRawData();
        this.len = this.byteArrayBuffer.size();
    }

    @Override
    public String getContentId() {
        return this.contentId;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public byte[] asByteArray() {
        return this.byteArrayBuffer.toByteArray();
    }

    @Override
    public DataHandler asDataHandler() {
        return new DataSourceStreamingDataHandler(new ByteArrayDataSource(this.data, 0, this.len, this.getContentType()));
    }

    @Override
    public Source asSource() {
        return new StreamSource(new ByteArrayInputStream(this.data, 0, this.len));
    }

    @Override
    public InputStream asInputStream() {
        return this.byteArrayBuffer.newInputStream();
    }

    public Base64Data asBase64Data() {
        Base64Data base64Data = new Base64Data();
        base64Data.set(this.data, this.len, this.contentType);
        return base64Data;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.byteArrayBuffer.writeTo(outputStream);
    }

    @Override
    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
        attachmentPart.setRawContentBytes(this.data, 0, this.len, this.getContentType());
        attachmentPart.setContentId(this.contentId);
        sOAPMessage.addAttachmentPart(attachmentPart);
    }
}

