// Sample for GR-PEACH, GR-LYCHEE
//
// Required hardware: Camera, USB, LCD
//
// Public Domain

#include <Arduino.h>
#include <Camera.h>
#include <LCD.h>

#define IMAGE_HW 480
#define IMAGE_VW 272

#if defined(PIN_SW0)
#define BUTTON PIN_SW0
#else
#define BUTTON PIN_SW
#endif

Camera camera(IMAGE_HW, IMAGE_VW);
LCD lcd(IMAGE_HW, IMAGE_VW);
bool lcd_on = true;
void setup() {
  // put your setup code here, to run once:
  pinMode(BUTTON, INPUT);
  camera.begin();
  lcd.begin(camera.getImageAdr(), camera.getWidth(), camera.getHeight());
  lcd.clear();

}

void loop() {
  // put your main code here, to run repeatedly:
  if(digitalRead(BUTTON) == LOW){
    lcd_on = !lcd_on;
    if(lcd_on){
      lcd.restart();
    } else {
      lcd.stop();
    }
    while(digitalRead(BUTTON) == LOW); // cut chattering
  } 

}
