;   Copyright (C) 2016 Free Software Foundation, Inc.
;   Contributed by CTS.
;
; This file is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by the
; Free Software Foundation; either version 3, or (at your option) any
; later version.
;
; This file is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;
; Under Section 7 of GPL version 3, you are granted additional
; permissions described in the GCC Runtime Library Exception, version
; 3.1, as published by the Free Software Foundation.
;
; You should have received a copy of the GNU General Public License and
; a copy of the GCC Runtime Library Exception along with this program;
; see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
; <http://www.gnu.org/licenses/>.


#include "vregs.h"

    .text


#ifdef __RL78_MUL_NONE__

; inputs:   AX  = (un)signed 16 bit value
;           BC  = (un)signed 16 bit value
; output:   AX  = the lower 16 bits of the product of the two inputs
; clobbers: BC, DE
START_FUNC ___mulhi3       ; ~23 clocks on the S1 core

    xch    a, c
    movw   de, ax
    xch    a, b
    mulu   x
    xchw   ax, bc
    mulu   x
    xchw   ax, de
    mulu   x
    add    a, e
    add    a, c
    ret

END_FUNC ___mulhi3

#endif /* __RL78_MUL_NONE__ */


#ifdef __RL78_MUL_G13__

; inputs:   AX  = (un)signed 16 bit value
;           BC  = (un)signed 16 bit value
; output:   AX  = the lower 16 bits of the product of the two inputs
; clobbers: -
START_FUNC ___mulhi3

    mov    !MDUC, #0       ; unsigned multiply operation
    movw   MDAL, ax
    movw   ax, bc
    movw   MDAH, ax
    nop                    ; MDBH:MDBL = MDAL * MDAH
    movw   ax, MDBL
    ret

END_FUNC ___mulhi3

#endif /* __RL78_MUL_G13__ */
