/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.ThreadContext;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.snmp.internal.SnmpIncomingRequest;
import java.util.Vector;
import java.util.logging.Level;

class SnmpSubRequestHandler
implements SnmpDefinitions,
Runnable {
    protected SnmpIncomingRequest incRequest = null;
    protected SnmpEngine engine = null;
    protected int version = 0;
    protected int type = 0;
    protected SnmpMibAgent agent;
    protected int errorStatus = 0;
    protected int errorIndex = -1;
    protected Vector<SnmpVarBind> varBind;
    protected int[] translation;
    protected Object data;
    private SnmpMibRequest mibRequest = null;
    private SnmpPdu reqPdu = null;

    protected SnmpSubRequestHandler(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        this(snmpMibAgent, snmpPdu);
        this.init(snmpEngine, snmpIncomingRequest);
    }

    protected SnmpSubRequestHandler(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, boolean bl) {
        this(snmpMibAgent, snmpPdu, bl);
        this.init(snmpEngine, snmpIncomingRequest);
    }

    protected SnmpSubRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "constructor", "creating instance for request " + String.valueOf(snmpPdu.requestId));
        }
        this.version = snmpPdu.version;
        this.type = snmpPdu.type;
        this.agent = snmpMibAgent;
        this.reqPdu = snmpPdu;
        int n = snmpPdu.varBindList.length;
        this.translation = new int[n];
        this.varBind = new NonSyncVector<SnmpVarBind>(n);
    }

    protected SnmpSubRequestHandler(SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu, boolean bl) {
        this(snmpMibAgent, snmpPdu);
        int n = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        for (int i = 0; i < n; ++i) {
            this.translation[i] = i;
            ((NonSyncVector)this.varBind).addNonSyncElement(snmpVarBindArray[i]);
        }
    }

    SnmpMibRequest createMibRequest(Vector<SnmpVarBind> vector, int n, Object object) {
        if (this.type == 163 && this.mibRequest != null) {
            return this.mibRequest;
        }
        SnmpMibRequest snmpMibRequest = null;
        snmpMibRequest = this.incRequest != null ? SnmpMibAgent.newMibRequest(this.engine, this.reqPdu, vector, n, object, this.incRequest.getPrincipal(), this.incRequest.getSecurityLevel(), this.incRequest.getSecurityModel(), this.incRequest.getContextName(), this.incRequest.getAccessContext()) : SnmpMibAgent.newMibRequest(this.reqPdu, vector, n, object);
        if (this.type == 253) {
            this.mibRequest = snmpMibRequest;
        }
        return snmpMibRequest;
    }

    void setUserData(Object object) {
        this.data = object;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block19: {
            try {
                var1_1 = ThreadContext.push("SnmpUserData", this.data);
                try {
                    switch (this.type) {
                        case 160: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:get operation on " + this.agent.getMibName());
                            }
                            this.agent.get(this.createMibRequest(this.varBind, this.version, this.data));
                            ** break;
lbl10:
                            // 1 sources

                            break;
                        }
                        case 161: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:getNext operation on " + this.agent.getMibName());
                            }
                            this.agent.getNext(this.createMibRequest(this.varBind, this.version, this.data));
                            ** break;
lbl16:
                            // 1 sources

                            break;
                        }
                        case 163: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:set operation on " + this.agent.getMibName());
                            }
                            this.agent.set(this.createMibRequest(this.varBind, this.version, this.data));
                            ** break;
lbl22:
                            // 1 sources

                            break;
                        }
                        case 253: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:check operation on " + this.agent.getMibName());
                            }
                            this.agent.check(this.createMibRequest(this.varBind, this.version, this.data));
                            ** break;
lbl28:
                            // 1 sources

                            break;
                        }
                        default: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:unknown operation (" + this.type + ") on " + this.agent.getMibName());
                            }
                            this.errorStatus = 5;
                            this.errorIndex = 1;
                            break;
                        }
                    }
                }
                finally {
                    ThreadContext.restore(var1_1);
                }
            }
            catch (SnmpStatusException var1_2) {
                this.errorStatus = var1_2.getStatus();
                this.errorIndex = var1_2.getErrorIndex();
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:an Snmp error occurred during the operation", var1_2);
                }
            }
            catch (Exception var1_3) {
                this.errorStatus = 5;
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block19;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:a generic error occurred during the operation", var1_3);
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    static final int mapErrorStatusToV1(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n == 5) {
            return 5;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 224 || n == 225 || n == 6 || n == 18 || n == 16) {
            return 2;
        }
        if (n == 16 || n == 17) {
            if (n2 == 253) {
                return 4;
            }
            return 2;
        }
        if (n == 11) {
            return 2;
        }
        if (n == 7 || n == 8 || n == 9 || n == 10 || n == 8 || n == 12) {
            if (n2 == 163 || n2 == 253) {
                return 3;
            }
            return 2;
        }
        if (n == 13 || n == 14 || n == 15) {
            return 5;
        }
        if (n == 1) {
            return 1;
        }
        if (n == 3 || n == 4) {
            if (n2 == 163 || n2 == 253) {
                return n;
            }
            return 2;
        }
        return 5;
    }

    static final int mapErrorStatusToV2(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n == 5) {
            return 5;
        }
        if (n == 1) {
            return 1;
        }
        if (n2 != 163 && n2 != 253) {
            if (n == 16) {
                return n;
            }
            return 5;
        }
        if (n == 2) {
            return 6;
        }
        if (n == 4) {
            return 17;
        }
        if (n == 3) {
            return 10;
        }
        if (n == 6 || n == 18 || n == 16 || n == 17 || n == 11 || n == 7 || n == 8 || n == 9 || n == 10 || n == 8 || n == 12 || n == 13 || n == 14 || n == 15) {
            return n;
        }
        return 5;
    }

    static final int mapErrorStatus(int n, int n2, int n3) {
        if (n == 0) {
            return 0;
        }
        if (n2 == 0) {
            return SnmpSubRequestHandler.mapErrorStatusToV1(n, n3);
        }
        if (n2 == 1 || n2 == 3) {
            return SnmpSubRequestHandler.mapErrorStatusToV2(n, n3);
        }
        return 5;
    }

    protected int getErrorStatus() {
        if (this.errorStatus == 0) {
            return 0;
        }
        return SnmpSubRequestHandler.mapErrorStatus(this.errorStatus, this.version, this.type);
    }

    protected int getErrorIndex() {
        if (this.errorStatus == 0) {
            return -1;
        }
        if (this.errorIndex == 0 || this.errorIndex == -1) {
            this.errorIndex = 1;
        }
        return this.translation[this.errorIndex - 1];
    }

    protected void updateRequest(SnmpVarBind snmpVarBind, int n) {
        int n2 = this.varBind.size();
        this.translation[n2] = n;
        this.varBind.addElement(snmpVarBind);
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        if (snmpVarBindArray == null) {
            return;
        }
        int n = this.varBind.size();
        int n2 = snmpVarBindArray.length;
        for (int i = 0; i < n; ++i) {
            int n3 = this.translation[i];
            if (n3 < n2) {
                snmpVarBindArray[n3] = (SnmpVarBind)((NonSyncVector)this.varBind).elementAtNonSync(i);
                continue;
            }
            if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "updateResult", "Position `" + n3 + "' is out of bound...");
        }
    }

    private void init(SnmpEngine snmpEngine, SnmpIncomingRequest snmpIncomingRequest) {
        this.incRequest = snmpIncomingRequest;
        this.engine = snmpEngine;
    }

    class NonSyncVector<E>
    extends Vector<E> {
        public NonSyncVector(int n) {
            super(n);
        }

        final void addNonSyncElement(E e) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = e;
        }

        final E elementAtNonSync(int n) {
            return (E)this.elementData[n];
        }
    }
}

