/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.glassfish.external.amx;

import com.sun.org.glassfish.external.amx.AMXUtil;
import com.sun.org.glassfish.external.arc.Stability;
import com.sun.org.glassfish.external.arc.Taxonomy;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

@Taxonomy(stability=Stability.UNCOMMITTED)
public class MBeanListener<T extends Callback>
implements NotificationListener {
    private final String mJMXDomain;
    private final String mType;
    private final String mName;
    private final ObjectName mObjectName;
    private final MBeanServerConnection mMBeanServer;
    private final T mCallback;

    private static void debug(Object object) {
        System.out.println("" + object);
    }

    public String toString() {
        return "MBeanListener: ObjectName=" + this.mObjectName + ", type=" + this.mType + ", name=" + this.mName;
    }

    public String getType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    public MBeanServerConnection getMBeanServer() {
        return this.mMBeanServer;
    }

    public T getCallback() {
        return this.mCallback;
    }

    public MBeanListener(MBeanServerConnection mBeanServerConnection, ObjectName objectName, T t) {
        this.mMBeanServer = mBeanServerConnection;
        this.mObjectName = objectName;
        this.mJMXDomain = null;
        this.mType = null;
        this.mName = null;
        this.mCallback = t;
    }

    public MBeanListener(MBeanServerConnection mBeanServerConnection, String string, String string2, T t) {
        this(mBeanServerConnection, string, string2, null, t);
    }

    public MBeanListener(MBeanServerConnection mBeanServerConnection, String string, String string2, String string3, T t) {
        this.mMBeanServer = mBeanServerConnection;
        this.mJMXDomain = string;
        this.mType = string2;
        this.mName = string3;
        this.mObjectName = null;
        this.mCallback = t;
    }

    private boolean isRegistered(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
        try {
            return mBeanServerConnection.isRegistered(objectName);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void startListening() {
        try {
            this.mMBeanServer.addNotificationListener(AMXUtil.getMBeanServerDelegateObjectName(), this, null, (Object)this);
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't add NotificationListener", exception);
        }
        if (this.mObjectName != null) {
            if (this.isRegistered(this.mMBeanServer, this.mObjectName)) {
                this.mCallback.mbeanRegistered(this.mObjectName, this);
            }
        } else {
            String string = "type=" + this.mType;
            if (this.mName != null) {
                string = string + "," + "name" + this.mName;
            }
            ObjectName objectName = AMXUtil.newObjectName(this.mJMXDomain + ":" + string);
            try {
                Set<ObjectName> set = this.mMBeanServer.queryNames(objectName, null);
                for (ObjectName objectName2 : set) {
                    this.mCallback.mbeanRegistered(objectName2, this);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public void stopListening() {
        try {
            this.mMBeanServer.removeNotificationListener(AMXUtil.getMBeanServerDelegateObjectName(), this);
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't remove NotificationListener " + this, exception);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object object) {
        if (notification instanceof MBeanServerNotification) {
            String string;
            MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
            ObjectName objectName = mBeanServerNotification.getMBeanName();
            boolean bl = false;
            if (this.mObjectName != null && this.mObjectName.equals(objectName)) {
                bl = true;
            } else if (objectName.getDomain().equals(this.mJMXDomain) && this.mType != null && this.mType.equals(objectName.getKeyProperty("type"))) {
                string = objectName.getKeyProperty("name");
                if (this.mName != null && this.mName.equals(string)) {
                    bl = true;
                }
            }
            if (bl) {
                string = mBeanServerNotification.getType();
                if ("JMX.mbean.registered".equals(string)) {
                    this.mCallback.mbeanRegistered(objectName, this);
                } else if ("JMX.mbean.unregistered".equals(string)) {
                    this.mCallback.mbeanUnregistered(objectName, this);
                }
            }
        }
    }

    public static interface Callback {
        public void mbeanRegistered(ObjectName var1, MBeanListener var2);

        public void mbeanUnregistered(ObjectName var1, MBeanListener var2);
    }

    public static class CallbackImpl
    implements Callback {
        private volatile ObjectName mRegistered = null;
        private volatile ObjectName mUnregistered = null;
        private final boolean mStopAtFirst;
        protected final CountDownLatch mLatch = new CountDownLatch(1);

        public CallbackImpl() {
            this(true);
        }

        public CallbackImpl(boolean bl) {
            this.mStopAtFirst = bl;
        }

        public ObjectName getRegistered() {
            return this.mRegistered;
        }

        public ObjectName getUnregistered() {
            return this.mUnregistered;
        }

        public void await() {
            try {
                this.mLatch.await();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }

        @Override
        public void mbeanRegistered(ObjectName objectName, MBeanListener mBeanListener) {
            this.mRegistered = objectName;
            if (this.mStopAtFirst) {
                mBeanListener.stopListening();
            }
        }

        @Override
        public void mbeanUnregistered(ObjectName objectName, MBeanListener mBeanListener) {
            this.mUnregistered = objectName;
            if (this.mStopAtFirst) {
                mBeanListener.stopListening();
            }
        }
    }
}

