/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.model.impl;

import com.sun.xml.internal.bind.v2.model.annotation.AnnotationReader;
import com.sun.xml.internal.bind.v2.model.core.BuiltinLeafInfo;
import com.sun.xml.internal.bind.v2.model.core.LeafInfo;
import com.sun.xml.internal.bind.v2.model.core.NonElement;
import com.sun.xml.internal.bind.v2.model.core.Ref;
import com.sun.xml.internal.bind.v2.model.core.TypeInfoSet;
import com.sun.xml.internal.bind.v2.model.impl.AnyTypeImpl;
import com.sun.xml.internal.bind.v2.model.impl.ArrayInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.BuiltinLeafInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.ClassInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.ElementInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.EnumLeafInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.Messages;
import com.sun.xml.internal.bind.v2.model.impl.ModelBuilder;
import com.sun.xml.internal.bind.v2.model.nav.Navigator;
import com.sun.xml.internal.bind.v2.runtime.IllegalAnnotationException;
import com.sun.xml.internal.bind.v2.runtime.RuntimeUtil;
import com.sun.xml.internal.bind.v2.util.FlattenIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;

class TypeInfoSetImpl<T, C, F, M>
implements TypeInfoSet<T, C, F, M> {
    @XmlTransient
    public final Navigator<T, C, F, M> nav;
    @XmlTransient
    public final AnnotationReader<T, C, F, M> reader;
    private final Map<T, BuiltinLeafInfo<T, C>> builtins = new LinkedHashMap<T, BuiltinLeafInfo<T, C>>();
    private final Map<C, EnumLeafInfoImpl<T, C, F, M>> enums = new LinkedHashMap<C, EnumLeafInfoImpl<T, C, F, M>>();
    private final Map<T, ArrayInfoImpl<T, C, F, M>> arrays = new LinkedHashMap<T, ArrayInfoImpl<T, C, F, M>>();
    @XmlJavaTypeAdapter(value=RuntimeUtil.ToStringAdapter.class)
    private final Map<C, ClassInfoImpl<T, C, F, M>> beans = new LinkedHashMap<C, ClassInfoImpl<T, C, F, M>>();
    @XmlTransient
    private final Map<C, ClassInfoImpl<T, C, F, M>> beansView = Collections.unmodifiableMap(this.beans);
    private final Map<C, Map<QName, ElementInfoImpl<T, C, F, M>>> elementMappings = new LinkedHashMap<C, Map<QName, ElementInfoImpl<T, C, F, M>>>();
    private final Iterable<? extends ElementInfoImpl<T, C, F, M>> allElements = new Iterable<ElementInfoImpl<T, C, F, M>>(){

        @Override
        public Iterator<ElementInfoImpl<T, C, F, M>> iterator() {
            return new FlattenIterator(TypeInfoSetImpl.this.elementMappings.values());
        }
    };
    private final NonElement<T, C> anyType;
    private Map<String, Map<String, String>> xmlNsCache;

    public TypeInfoSetImpl(Navigator<T, C, F, M> navigator, AnnotationReader<T, C, F, M> annotationReader, Map<T, ? extends BuiltinLeafInfoImpl<T, C>> map) {
        this.nav = navigator;
        this.reader = annotationReader;
        this.builtins.putAll(map);
        this.anyType = this.createAnyType();
        for (Map.Entry<Class, Class> entry : RuntimeUtil.primitiveToBox.entrySet()) {
            this.builtins.put(navigator.getPrimitive(entry.getKey()), map.get(navigator.ref(entry.getValue())));
        }
        this.elementMappings.put(null, new LinkedHashMap());
    }

    protected NonElement<T, C> createAnyType() {
        return new AnyTypeImpl<T, C>(this.nav);
    }

    @Override
    public Navigator<T, C, F, M> getNavigator() {
        return this.nav;
    }

    public void add(ClassInfoImpl<T, C, F, M> classInfoImpl) {
        this.beans.put(classInfoImpl.getClazz(), classInfoImpl);
    }

    public void add(EnumLeafInfoImpl<T, C, F, M> enumLeafInfoImpl) {
        this.enums.put(enumLeafInfoImpl.clazz, enumLeafInfoImpl);
    }

    public void add(ArrayInfoImpl<T, C, F, M> arrayInfoImpl) {
        this.arrays.put(arrayInfoImpl.getType(), arrayInfoImpl);
    }

    @Override
    public NonElement<T, C> getTypeInfo(T t) {
        LeafInfo leafInfo = this.builtins.get(t = this.nav.erasure(t));
        if (leafInfo != null) {
            return leafInfo;
        }
        if (this.nav.isArray(t)) {
            return this.arrays.get(t);
        }
        C c = this.nav.asDecl(t);
        if (c == null) {
            return null;
        }
        return this.getClassInfo(c);
    }

    @Override
    public NonElement<T, C> getAnyTypeInfo() {
        return this.anyType;
    }

    @Override
    public NonElement<T, C> getTypeInfo(Ref<T, C> ref) {
        assert (!ref.valueList);
        C c = this.nav.asDecl(ref.type);
        if (c != null && this.reader.getClassAnnotation(XmlRegistry.class, c, null) != null) {
            return null;
        }
        return this.getTypeInfo(ref.type);
    }

    @Override
    public Map<C, ? extends ClassInfoImpl<T, C, F, M>> beans() {
        return this.beansView;
    }

    @Override
    public Map<T, ? extends BuiltinLeafInfo<T, C>> builtins() {
        return this.builtins;
    }

    @Override
    public Map<C, ? extends EnumLeafInfoImpl<T, C, F, M>> enums() {
        return this.enums;
    }

    @Override
    public Map<? extends T, ? extends ArrayInfoImpl<T, C, F, M>> arrays() {
        return this.arrays;
    }

    @Override
    public NonElement<T, C> getClassInfo(C c) {
        LeafInfo leafInfo = this.builtins.get(this.nav.use(c));
        if (leafInfo != null) {
            return leafInfo;
        }
        leafInfo = this.enums.get(c);
        if (leafInfo != null) {
            return leafInfo;
        }
        if (this.nav.asDecl(Object.class).equals(c)) {
            return this.anyType;
        }
        return this.beans.get(c);
    }

    public ElementInfoImpl<T, C, F, M> getElementInfo(C c, QName qName) {
        while (c != null) {
            ElementInfoImpl<T, C, F, M> elementInfoImpl;
            Map<QName, ElementInfoImpl<T, C, F, M>> map = this.elementMappings.get(c);
            if (map != null && (elementInfoImpl = map.get(qName)) != null) {
                return elementInfoImpl;
            }
            c = this.nav.getSuperClass(c);
        }
        return this.elementMappings.get(null).get(qName);
    }

    public final void add(ElementInfoImpl<T, C, F, M> elementInfoImpl, ModelBuilder<T, C, F, M> modelBuilder) {
        ElementInfoImpl<T, C, F, M> elementInfoImpl2;
        Map<QName, ElementInfoImpl<T, C, F, M>> map;
        Object k = null;
        if (elementInfoImpl.getScope() != null) {
            k = elementInfoImpl.getScope().getClazz();
        }
        if ((map = this.elementMappings.get(k)) == null) {
            map = new LinkedHashMap<QName, ElementInfoImpl<T, C, F, M>>();
            this.elementMappings.put(k, map);
        }
        if ((elementInfoImpl2 = map.put(elementInfoImpl.getElementName(), elementInfoImpl)) != null) {
            QName qName = elementInfoImpl.getElementName();
            modelBuilder.reportError(new IllegalAnnotationException(Messages.CONFLICTING_XML_ELEMENT_MAPPING.format(qName.getNamespaceURI(), qName.getLocalPart()), elementInfoImpl, elementInfoImpl2));
        }
    }

    @Override
    public Map<QName, ? extends ElementInfoImpl<T, C, F, M>> getElementMappings(C c) {
        return this.elementMappings.get(c);
    }

    @Override
    public Iterable<? extends ElementInfoImpl<T, C, F, M>> getAllElements() {
        return this.allElements;
    }

    @Override
    public Map<String, String> getXmlNs(String string) {
        Object object;
        if (this.xmlNsCache == null) {
            this.xmlNsCache = new HashMap<String, Map<String, String>>();
            object = this.beans().values().iterator();
            while (object.hasNext()) {
                ClassInfoImpl classInfoImpl = (ClassInfoImpl)object.next();
                XmlSchema xmlSchema = this.reader.getPackageAnnotation(XmlSchema.class, classInfoImpl.getClazz(), null);
                if (xmlSchema == null) continue;
                String string2 = xmlSchema.namespace();
                Map<String, String> map = this.xmlNsCache.get(string2);
                if (map == null) {
                    map = new HashMap<String, String>();
                    this.xmlNsCache.put(string2, map);
                }
                for (XmlNs xmlNs : xmlSchema.xmlns()) {
                    map.put(xmlNs.prefix(), xmlNs.namespaceURI());
                }
            }
        }
        if ((object = this.xmlNsCache.get(string)) != null) {
            return object;
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, String> getSchemaLocations() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (ClassInfoImpl<T, C, F, M> classInfoImpl : this.beans().values()) {
            String string;
            XmlSchema xmlSchema = this.reader.getPackageAnnotation(XmlSchema.class, classInfoImpl.getClazz(), null);
            if (xmlSchema == null || (string = xmlSchema.location()).equals("##generate")) continue;
            hashMap.put(xmlSchema.namespace(), string);
        }
        return hashMap;
    }

    @Override
    public final XmlNsForm getElementFormDefault(String string) {
        for (ClassInfoImpl<T, C, F, M> classInfoImpl : this.beans().values()) {
            XmlNsForm xmlNsForm;
            XmlSchema xmlSchema = this.reader.getPackageAnnotation(XmlSchema.class, classInfoImpl.getClazz(), null);
            if (xmlSchema == null || !xmlSchema.namespace().equals(string) || (xmlNsForm = xmlSchema.elementFormDefault()) == XmlNsForm.UNSET) continue;
            return xmlNsForm;
        }
        return XmlNsForm.UNSET;
    }

    @Override
    public final XmlNsForm getAttributeFormDefault(String string) {
        for (ClassInfoImpl<T, C, F, M> classInfoImpl : this.beans().values()) {
            XmlNsForm xmlNsForm;
            XmlSchema xmlSchema = this.reader.getPackageAnnotation(XmlSchema.class, classInfoImpl.getClazz(), null);
            if (xmlSchema == null || !xmlSchema.namespace().equals(string) || (xmlNsForm = xmlSchema.attributeFormDefault()) == XmlNsForm.UNSET) continue;
            return xmlNsForm;
        }
        return XmlNsForm.UNSET;
    }

    @Override
    public void dump(Result result) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance(this.getClass());
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.marshal((Object)this, result);
    }
}

