/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import processing.app.I18n;
import processing.app.debug.TargetPlatform;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.filefilters.OnlyDirs;

public class TargetPackage {
    private String id;
    Map<String, TargetPlatform> platforms = new LinkedHashMap<String, TargetPlatform>();

    public TargetPackage(String _id, File _folder) throws TargetPlatformException {
        this.id = _id;
        File[] folders = _folder.listFiles(new OnlyDirs());
        if (folders == null) {
            return;
        }
        for (File subFolder : folders) {
            if (!subFolder.exists() || !subFolder.canRead()) continue;
            String arch = subFolder.getName();
            try {
                TargetPlatform platform = new TargetPlatform(arch, subFolder, this);
                this.platforms.put(arch, platform);
            }
            catch (TargetPlatformException e) {
                System.out.println(e.getMessage());
            }
        }
        if (this.platforms.size() == 0) {
            throw new TargetPlatformException(I18n.format(I18n._("No valid hardware definitions found in folder {0}."), _folder.getName()));
        }
    }

    public Map<String, TargetPlatform> getPlatforms() {
        return this.platforms;
    }

    public Collection<TargetPlatform> platforms() {
        return this.platforms.values();
    }

    public TargetPlatform get(String platform) {
        return this.platforms.get(platform);
    }

    public String getId() {
        return this.id;
    }
}

