/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.jaxws;

import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.PolicyMapExtender;
import com.sun.xml.internal.ws.policy.PolicyMapMutator;
import com.sun.xml.internal.ws.policy.jaxws.BuilderHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

class PolicyMapBuilder {
    private List<BuilderHandler> policyBuilders = new LinkedList<BuilderHandler>();

    PolicyMapBuilder() {
    }

    void registerHandler(BuilderHandler builderHandler) {
        if (null != builderHandler) {
            this.policyBuilders.add(builderHandler);
        }
    }

    PolicyMap getPolicyMap(PolicyMapMutator ... policyMapMutatorArray) throws PolicyException {
        return this.getNewPolicyMap(policyMapMutatorArray);
    }

    private PolicyMap getNewPolicyMap(PolicyMapMutator ... policyMapMutatorArray) throws PolicyException {
        HashSet<PolicyMapMutator> hashSet = new HashSet<PolicyMapMutator>();
        PolicyMapExtender policyMapExtender = PolicyMapExtender.createPolicyMapExtender();
        hashSet.add(policyMapExtender);
        if (null != policyMapMutatorArray) {
            hashSet.addAll(Arrays.asList(policyMapMutatorArray));
        }
        PolicyMap policyMap = PolicyMap.createPolicyMap(hashSet);
        for (BuilderHandler builderHandler : this.policyBuilders) {
            builderHandler.populate(policyMapExtender);
        }
        return policyMap;
    }

    void unregisterAll() {
        this.policyBuilders = null;
    }
}

