/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.Component;
import com.sun.xml.internal.ws.api.ComponentEx;
import com.sun.xml.internal.ws.api.server.ContainerResolver;
import com.sun.xml.internal.ws.util.ServiceConfigurationError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class ServiceFinder<T>
implements Iterable<T> {
    private static final String prefix = "META-INF/services/";
    private static WeakHashMap<ClassLoader, ConcurrentHashMap<String, ServiceName[]>> serviceNameCache = new WeakHashMap();
    private final Class<T> serviceClass;
    @Nullable
    private final ClassLoader classLoader;
    @Nullable
    private final ComponentEx component;

    public static <T> ServiceFinder<T> find(@NotNull Class<T> clazz, @Nullable ClassLoader classLoader, Component component) {
        return new ServiceFinder<T>(clazz, classLoader, component);
    }

    public static <T> ServiceFinder<T> find(@NotNull Class<T> clazz, Component component) {
        return ServiceFinder.find(clazz, Thread.currentThread().getContextClassLoader(), component);
    }

    public static <T> ServiceFinder<T> find(@NotNull Class<T> clazz, @Nullable ClassLoader classLoader) {
        return ServiceFinder.find(clazz, classLoader, ContainerResolver.getInstance().getContainer());
    }

    public static <T> ServiceFinder<T> find(Class<T> clazz) {
        return ServiceFinder.find(clazz, Thread.currentThread().getContextClassLoader());
    }

    private ServiceFinder(Class<T> clazz, ClassLoader classLoader, Component component) {
        this.serviceClass = clazz;
        this.classLoader = classLoader;
        this.component = ServiceFinder.getComponentEx(component);
    }

    private static ServiceName[] serviceClassNames(Class clazz, ClassLoader classLoader) {
        ArrayList arrayList = new ArrayList();
        ServiceNameIterator serviceNameIterator = new ServiceNameIterator(clazz, classLoader);
        while (serviceNameIterator.hasNext()) {
            arrayList.add(serviceNameIterator.next());
        }
        return arrayList.toArray(new ServiceName[arrayList.size()]);
    }

    @Override
    public Iterator<T> iterator() {
        LazyIterator lazyIterator = new LazyIterator(this.serviceClass, this.classLoader);
        return this.component != null ? new CompositeIterator(this.component.getIterableSPI(this.serviceClass).iterator(), lazyIterator) : lazyIterator;
    }

    public T[] toArray() {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : this) {
            arrayList.add(t);
        }
        return arrayList.toArray((Object[])Array.newInstance(this.serviceClass, arrayList.size()));
    }

    private static void fail(Class clazz, String string, Throwable throwable) throws ServiceConfigurationError {
        ServiceConfigurationError serviceConfigurationError = new ServiceConfigurationError(clazz.getName() + ": " + string);
        serviceConfigurationError.initCause(throwable);
        throw serviceConfigurationError;
    }

    private static void fail(Class clazz, String string) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(clazz.getName() + ": " + string);
    }

    private static void fail(Class clazz, URL uRL, int n, String string) throws ServiceConfigurationError {
        ServiceFinder.fail(clazz, uRL + ":" + n + ": " + string);
    }

    private static int parseLine(Class clazz, URL uRL, BufferedReader bufferedReader, int n, List<String> list, Set<String> set) throws IOException, ServiceConfigurationError {
        int n2;
        String string = bufferedReader.readLine();
        if (string == null) {
            return -1;
        }
        int n3 = string.indexOf(35);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if ((n2 = (string = string.trim()).length()) != 0) {
            int n4;
            if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0) {
                ServiceFinder.fail(clazz, uRL, n, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(n4 = string.codePointAt(0))) {
                ServiceFinder.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            for (int i = Character.charCount(n4); i < n2; i += Character.charCount(n4)) {
                n4 = string.codePointAt(i);
                if (Character.isJavaIdentifierPart(n4) || n4 == 46) continue;
                ServiceFinder.fail(clazz, uRL, n, "Illegal provider-class name: " + string);
            }
            if (!set.contains(string)) {
                list.add(string);
                set.add(string);
            }
        }
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<String> parse(Class clazz, URL uRL, Set<String> set) throws ServiceConfigurationError {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            inputStream = uRL.openStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            int n = 1;
            while ((n = ServiceFinder.parseLine(clazz, uRL, bufferedReader, n, arrayList, set)) >= 0) {
            }
        }
        catch (IOException iOException) {
            ServiceFinder.fail(clazz, ": " + iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                ServiceFinder.fail(clazz, ": " + iOException);
            }
        }
        return arrayList.iterator();
    }

    private static ComponentEx getComponentEx(Component component) {
        if (component instanceof ComponentEx) {
            return (ComponentEx)component;
        }
        return component != null ? new ComponentExWrapper(component) : null;
    }

    private static class ComponentExWrapper
    implements ComponentEx {
        private final Component component;

        public ComponentExWrapper(Component component) {
            this.component = component;
        }

        @Override
        public <S> S getSPI(Class<S> clazz) {
            return this.component.getSPI(clazz);
        }

        @Override
        public <S> Iterable<S> getIterableSPI(Class<S> clazz) {
            S s = this.getSPI(clazz);
            if (s != null) {
                List<S> list = Collections.singletonList(s);
                return list;
            }
            return Collections.emptySet();
        }
    }

    private static class CompositeIterator<T>
    implements Iterator<T> {
        private final Iterator<Iterator<T>> it;
        private Iterator<T> current = null;

        public CompositeIterator(Iterator<T> ... iteratorArray) {
            this.it = Arrays.asList(iteratorArray).iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.current != null && this.current.hasNext()) {
                return true;
            }
            while (this.it.hasNext()) {
                this.current = this.it.next();
                if (!this.current.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class LazyIterator<T>
    implements Iterator<T> {
        Class<T> service;
        @Nullable
        ClassLoader loader;
        ServiceName[] names;
        int index;

        private LazyIterator(Class<T> clazz, ClassLoader classLoader) {
            this.service = clazz;
            this.loader = classLoader;
            this.names = null;
            this.index = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (this.names == null) {
                ConcurrentHashMap<String, ServiceName[]> concurrentHashMap = null;
                WeakHashMap weakHashMap = serviceNameCache;
                synchronized (weakHashMap) {
                    concurrentHashMap = (ConcurrentHashMap<String, ServiceName[]>)serviceNameCache.get(this.loader);
                }
                ServiceName[] serviceNameArray = this.names = concurrentHashMap != null ? (ServiceName[])concurrentHashMap.get(this.service.getName()) : null;
                if (this.names == null) {
                    this.names = ServiceFinder.serviceClassNames(this.service, this.loader);
                    if (concurrentHashMap == null) {
                        concurrentHashMap = new ConcurrentHashMap<String, ServiceName[]>();
                    }
                    concurrentHashMap.put(this.service.getName(), this.names);
                    weakHashMap = serviceNameCache;
                    synchronized (weakHashMap) {
                        serviceNameCache.put(this.loader, concurrentHashMap);
                    }
                }
            }
            return this.index < this.names.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ServiceName serviceName = this.names[this.index++];
            String string = serviceName.className;
            URL uRL = serviceName.config;
            try {
                return this.service.cast(Class.forName(string, true, this.loader).newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
                ServiceFinder.fail(this.service, "Provider " + string + " is specified in " + uRL + " but not found");
            }
            catch (Exception exception) {
                ServiceFinder.fail(this.service, "Provider " + string + " is specified in " + uRL + "but could not be instantiated: " + exception, exception);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ServiceName {
        final String className;
        final URL config;

        public ServiceName(String string, URL uRL) {
            this.className = string;
            this.config = uRL;
        }
    }

    private static class ServiceNameIterator
    implements Iterator<ServiceName> {
        Class service;
        @Nullable
        ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        Set<String> returned = new TreeSet<String>();
        String nextName = null;
        URL currentConfig = null;

        private ServiceNameIterator(Class clazz, ClassLoader classLoader) {
            this.service = clazz;
            this.loader = classLoader;
        }

        @Override
        public boolean hasNext() throws ServiceConfigurationError {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String string = ServiceFinder.prefix + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(string) : this.loader.getResources(string);
                }
                catch (IOException iOException) {
                    ServiceFinder.fail(this.service, ": " + iOException);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.currentConfig = this.configs.nextElement();
                this.pending = ServiceFinder.parse(this.service, this.currentConfig, this.returned);
            }
            this.nextName = this.pending.next();
            return true;
        }

        @Override
        public ServiceName next() throws ServiceConfigurationError {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = this.nextName;
            this.nextName = null;
            return new ServiceName(string, this.currentConfig);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

